/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ocsp.CertID;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.jruby.Ruby;
import org.jruby.RubyBignum;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.openssl.ASN1;
import org.jruby.ext.openssl.Digest;
import org.jruby.ext.openssl.OCSP;
import org.jruby.ext.openssl.PKey;
import org.jruby.ext.openssl.StringHelper;
import org.jruby.ext.openssl.X509Cert;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class OCSPCertificateId
extends RubyObject {
    private static final long serialVersionUID = 6324454052172773918L;
    private static ObjectAllocator CERTIFICATEID_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new OCSPCertificateId(runtime, klass);
        }
    };
    private CertID bcCertId;
    private X509Cert originalIssuer;

    public static void createCertificateId(Ruby runtime, RubyModule _OCSP) {
        RubyClass _certificateId = _OCSP.defineClassUnder("CertificateId", runtime.getObject(), CERTIFICATEID_ALLOCATOR);
        _certificateId.defineAnnotatedMethods(OCSPCertificateId.class);
    }

    public OCSPCertificateId(Ruby runtime, RubyClass metaClass) {
        super(runtime, metaClass);
    }

    public OCSPCertificateId(Ruby runtime) {
        this(runtime, (RubyClass)OCSP._OCSP(runtime).getConstantAt("CertificateId"));
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context2, IRubyObject subject2, IRubyObject issuer2, IRubyObject digest2) {
        if (digest2 == null || digest2.isNil()) {
            return this.initialize(context2, subject2, issuer2);
        }
        X509Cert subjectCert = (X509Cert)subject2;
        this.originalIssuer = (X509Cert)issuer2;
        BigInteger serial2 = subjectCert.getSerial();
        return this.initializeImpl(context2, serial2, (IRubyObject)this.originalIssuer, digest2);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context2, IRubyObject subject2, IRubyObject issuer2) {
        Ruby runtime = context2.getRuntime();
        X509Cert subjectCert = (X509Cert)subject2;
        this.originalIssuer = (X509Cert)issuer2;
        BigInteger serial2 = subjectCert.getSerial();
        Digest digestInstance = new Digest(runtime, Digest._Digest(runtime));
        IRubyObject digest2 = digestInstance.initialize(context2, new IRubyObject[]{RubyString.newString((Ruby)runtime, (String)"SHA1")});
        return this.initializeImpl(context2, serial2, (IRubyObject)this.originalIssuer, digest2);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context2, IRubyObject der) {
        Ruby runtime = context2.getRuntime();
        RubyString derStr = StringHelper.readPossibleDERInput(context2, der);
        try {
            return this.initializeImpl(derStr.getBytes());
        }
        catch (IOException e) {
            throw OCSP.newOCSPError(runtime, e);
        }
    }

    private IRubyObject initializeImpl(ThreadContext context2, BigInteger serial2, IRubyObject issuerCert, IRubyObject digest2) {
        DigestCalculator calc;
        Ruby runtime = context2.getRuntime();
        Digest rubyDigest = (Digest)digest2;
        ASN1ObjectIdentifier oid2 = ASN1.sym2Oid(runtime, rubyDigest.getName().toLowerCase());
        AlgorithmIdentifier bcAlgId = new AlgorithmIdentifier(oid2);
        BcDigestCalculatorProvider calculatorProvider = new BcDigestCalculatorProvider();
        try {
            calc = calculatorProvider.get(bcAlgId);
        }
        catch (OperatorCreationException e) {
            throw OCSP.newOCSPError(runtime, (Exception)((Object)e));
        }
        X509Cert rubyCert = (X509Cert)issuerCert;
        try {
            this.bcCertId = new CertificateID(calc, new X509CertificateHolder(rubyCert.getAuxCert().getEncoded()), serial2).toASN1Primitive();
        }
        catch (Exception e) {
            throw OCSP.newOCSPError(runtime, e);
        }
        return this;
    }

    private IRubyObject initializeImpl(byte[] derByteStream) throws IOException {
        this.bcCertId = CertID.getInstance((Object)derByteStream);
        return this;
    }

    @JRubyMethod(name={"serial"})
    public IRubyObject serial() {
        return RubyBignum.newBignum((Ruby)this.getRuntime(), (BigInteger)this.bcCertId.getSerialNumber().getValue());
    }

    @JRubyMethod(name={"issuer_name_hash"})
    public IRubyObject issuer_name_hash() {
        Ruby runtime = this.getRuntime();
        String oidSym = ASN1.oid2Sym(runtime, this.getBCCertificateID().getHashAlgOID());
        RubyString digestName = RubyString.newString((Ruby)runtime, (String)oidSym);
        if (this.originalIssuer == null) {
            try {
                return Digest.hexdigest(runtime.getCurrentContext(), (IRubyObject)this, (IRubyObject)digestName, (IRubyObject)RubyString.newString((Ruby)runtime, (byte[])this.bcCertId.getIssuerNameHash().getEncoded("DER")));
            }
            catch (IOException e) {
                throw OCSP.newOCSPError(runtime, e);
            }
        }
        return Digest.hexdigest(runtime.getCurrentContext(), (IRubyObject)this, (IRubyObject)digestName, (IRubyObject)this.originalIssuer.getSubject().to_der(runtime.getCurrentContext()));
    }

    @JRubyMethod(name={"issuer_key_hash"})
    public IRubyObject issuer_key_hash() {
        Ruby runtime = this.getRuntime();
        String oidSym = ASN1.oid2Sym(runtime, this.getBCCertificateID().getHashAlgOID());
        RubyString digestName = RubyString.newString((Ruby)runtime, (String)oidSym);
        if (this.originalIssuer == null) {
            try {
                return Digest.hexdigest(runtime.getCurrentContext(), (IRubyObject)this, (IRubyObject)RubyString.newString((Ruby)runtime, (String)oidSym), (IRubyObject)RubyString.newString((Ruby)runtime, (byte[])this.bcCertId.getIssuerKeyHash().getEncoded("DER")));
            }
            catch (IOException e) {
                throw OCSP.newOCSPError(runtime, e);
            }
        }
        PKey key = (PKey)this.originalIssuer.public_key(runtime.getCurrentContext());
        return Digest.hexdigest(runtime.getCurrentContext(), (IRubyObject)this, (IRubyObject)digestName, (IRubyObject)key.to_der());
    }

    @JRubyMethod(name={"hash_algorithm"})
    public IRubyObject hash_algorithm() {
        Ruby runtime = this.getRuntime();
        ASN1ObjectIdentifier oid2 = this.bcCertId.getHashAlgorithm().getAlgorithm();
        Integer nid = ASN1.oid2nid(runtime, oid2);
        String ln2 = ASN1.nid2ln(runtime, nid);
        return RubyString.newString((Ruby)runtime, (String)ln2);
    }

    @JRubyMethod(name={"cmp"})
    public IRubyObject cmp(IRubyObject other) {
        Ruby runtime = this.getRuntime();
        RubyFixnum ret = (RubyFixnum)this.cmp_issuer(other);
        if (!ret.eql((IRubyObject)RubyFixnum.zero((Ruby)runtime))) {
            return ret;
        }
        OCSPCertificateId that = (OCSPCertificateId)other;
        return RubyFixnum.newFixnum((Ruby)runtime, (long)this.getCertID().getSerialNumber().getValue().compareTo(that.getCertID().getSerialNumber().getValue()));
    }

    @JRubyMethod(name={"cmp_issuer"})
    public IRubyObject cmp_issuer(IRubyObject other) {
        Ruby runtime = this.getRuntime();
        if (this.equals(other)) {
            return RubyFixnum.zero((Ruby)runtime);
        }
        if (other instanceof OCSPCertificateId) {
            OCSPCertificateId that = (OCSPCertificateId)other;
            CertID thisCert = this.getCertID();
            CertID thatCert = that.getCertID();
            int ret = thisCert.getHashAlgorithm().getAlgorithm().toString().compareTo(thatCert.getHashAlgorithm().getAlgorithm().toString());
            if (ret != 0) {
                return RubyFixnum.newFixnum((Ruby)runtime, (long)ret);
            }
            ret = thisCert.getIssuerNameHash().toString().compareTo(thatCert.getIssuerNameHash().toString());
            if (ret != 0) {
                return RubyFixnum.newFixnum((Ruby)runtime, (long)ret);
            }
            return RubyFixnum.newFixnum((Ruby)runtime, (long)thisCert.getIssuerKeyHash().toString().compareTo(thatCert.getIssuerKeyHash().toString()));
        }
        return runtime.getCurrentContext().nil;
    }

    @JRubyMethod(name={"to_der"})
    public IRubyObject to_der() {
        Ruby runtime = this.getRuntime();
        try {
            return StringHelper.newString(runtime, this.bcCertId.getEncoded("DER"));
        }
        catch (IOException e) {
            throw OCSP.newOCSPError(runtime, e);
        }
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject obj) {
        if (this == obj) {
            return this;
        }
        this.checkFrozen();
        this.bcCertId = ((OCSPCertificateId)obj).getCertID();
        return this;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof OCSPCertificateId) {
            OCSPCertificateId that = (OCSPCertificateId)((Object)other);
            return this.getCertID().equals((Object)that.getCertID());
        }
        return false;
    }

    public CertID getCertID() {
        return this.bcCertId;
    }

    public CertificateID getBCCertificateID() {
        if (this.bcCertId == null) {
            return null;
        }
        return new CertificateID(this.bcCertId);
    }
}

