/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.undo;

import tim.prune.I18nManager;
import tim.prune.data.DataPoint;
import tim.prune.data.Track;
import tim.prune.data.TrackInfo;
import tim.prune.undo.UndoException;
import tim.prune.undo.UndoOperation;

public class UndoReverseSection
implements UndoOperation {
    private int _startIndex;
    private int _endIndex;
    private DataPoint _firstTrackPoint;
    private DataPoint _lastTrackPoint;
    private DataPoint _nextTrackPoint;
    private boolean _firstSegmentFlag;
    private boolean _lastSegmentFlag;
    private boolean _nextSegmentFlag;

    public UndoReverseSection(Track track, int n, int n2) {
        this._startIndex = n;
        this._endIndex = n2;
        this._firstTrackPoint = track.getNextTrackPoint(n);
        if (this._firstTrackPoint != null) {
            this._firstSegmentFlag = this._firstTrackPoint.getSegmentStart();
        }
        this._lastTrackPoint = track.getPreviousTrackPoint(n2);
        if (this._lastTrackPoint != null) {
            this._lastSegmentFlag = this._lastTrackPoint.getSegmentStart();
        }
        this._nextTrackPoint = track.getNextTrackPoint(n2 + 1);
        if (this._nextTrackPoint != null) {
            this._nextSegmentFlag = this._nextTrackPoint.getSegmentStart();
        }
    }

    public String getDescription() {
        return I18nManager.getText("undo.reverse");
    }

    public void performUndo(TrackInfo trackInfo) throws UndoException {
        if (!trackInfo.getTrack().reverseRange(this._startIndex, this._endIndex)) {
            throw new UndoException(this.getDescription());
        }
        if (this._firstTrackPoint != null) {
            this._firstTrackPoint.setSegmentStart(this._firstSegmentFlag);
        }
        if (this._lastTrackPoint != null) {
            this._lastTrackPoint.setSegmentStart(this._lastSegmentFlag);
        }
        if (this._nextTrackPoint != null) {
            this._nextTrackPoint.setSegmentStart(this._nextSegmentFlag);
        }
    }
}

