/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.components;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.PixelGrabber;
import javax.swing.JPanel;

public class JImagePanel
extends JPanel {
    private static MediaTracker mTracker = new MediaTracker(new JPanel());
    private Image image;
    private int imageAlign;

    public JImagePanel(Image image) {
        this(image, 1);
    }

    public JImagePanel(Image image, int imageAlign) {
        this.setImage(image);
        this.setImageAlign(imageAlign);
    }

    public void setImage(Image image) {
        this.image = JImagePanel.loadImage(image);
        if (this.image == null) {
            throw new RuntimeException("JImagePanel failed to load image");
        }
        this.setPreferredBackground();
        this.setPreferredSize(new Dimension(this.image.getWidth(null), this.image.getHeight(null)));
        this.refresh();
    }

    public void setImageAlign(int imageAlign) {
        this.imageAlign = imageAlign;
        this.setPreferredBackground();
        this.refresh();
    }

    protected static Image loadImage(Image image) {
        mTracker.addImage(image, 0);
        try {
            mTracker.waitForID(0);
        }
        catch (InterruptedException e) {
            return null;
        }
        mTracker.removeImage(image, 0);
        return image;
    }

    protected void setPreferredBackground() {
        int[] pixels = new int[1];
        PixelGrabber pg = null;
        switch (this.imageAlign) {
            case 1: {
                pg = new PixelGrabber(this.image, 0, this.image.getHeight(null) - 1, 1, 1, pixels, 0, 1);
                break;
            }
            case 3: {
                pg = new PixelGrabber(this.image, 0, 0, 1, 1, pixels, 0, 1);
                break;
            }
            default: {
                pg = new PixelGrabber(this.image, 0, this.image.getHeight(null) - 1, 1, 1, pixels, 0, 1);
            }
        }
        try {
            if (pg != null && pg.grabPixels()) {
                this.setBackground(new Color(pixels[0]));
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        switch (this.imageAlign) {
            case 1: {
                graphics.drawImage(this.image, (this.getWidth() - this.image.getWidth(null)) / 2, 0, this);
                break;
            }
            case 3: {
                graphics.drawImage(this.image, (this.getWidth() - this.image.getWidth(null)) / 2, this.getHeight() - this.image.getHeight(null), this);
                break;
            }
            default: {
                graphics.drawImage(this.image, (this.getWidth() - this.image.getWidth(null)) / 2, 0, this);
            }
        }
    }

    private void refresh() {
        if (this.isShowing()) {
            this.invalidate();
            this.repaint();
        }
    }
}

