#Fluajho
Program version 1.4


"Fluajho" (with jh as in pleasure) means fluid in Esperanto. It is a simple sf2 soundfont
host/player for Linux. Behind the scenes the Fluidsynth library is at work, hence the name.

.sf2 is an old file format for making MIDI signals audible through virtual instruments, although it
is still in moderate use today.

Why does Fluajho exist? There are many soundfont players for Linux,
most of them even based on Fluidsynth. Fluajho was written for a clearly defined use case:
Load an .sf2 in the Non Session Manager and save the soundfont in the session directory.
This makes it possible to archive the session, for example as a backup or to share it.

You can load one soundfont file per Fluajho instance. Each instance holds 16 of the soundfonts 
instruments that can be assigned to 16 MIDI channels. Finally connect external sequencers, such as
Laborejo, Patroneo or Vico, through JACK-Midi to play the instruments.


This README is just a short introduction. Consult the manual (see below) for more information.

# Contact and Information

* Website https://www.laborejo.org
* Documentation and Manual https://www.laborejo.org/documentation/fluajho

# Installation and Starting

## Download

### Release Version
If the latest release is not available through your package manger you can build it yourself:
Download the latest code release on https://www.laborejo.org/downloads and extract it.

### Git Version
It is possible to clone a git repository.

`git clone --recurse-submodules https://laborejo.org/fluajho.git`

If you want to update at a later date you must use

`git pull --recurse-submodules`


## Dependencies
* Glibc
* Python 3.6 (maybe earlier)
* PyQt5 for Python 3
* DejaVu Sans Sarif TTF (Font) (recommended, but not technically necessary)
* Fluidsynth

#### Build Dependencies
* Bash
* Nuitka >= 0.6 (maybe earlier. Optional when running from source dir)
* GCC (development is done on 8.2, but most likely you can use a much earlier version)

### Environment:
* Jack Audio Connection Kit must be running
* Non Session Manager

## Build
    ./configure --prefix=/usr/local
    make
    sudo make install


## Starting

There are multiple ways to run Fluajho which should give you the flexibility to configure your
system as you want.

We make no distinction if you installed Fluajho yourself or through the distributions package-manager.

The differences are: With or without NSM, with or without sound, installed or from the source dir.

### Installed with Non Session Manager (recommended)
Starting Fluajho through the Non Session Manager after you installed fluajho system-wide
is the recommended and only supported way. Start non-session-manager and load or create a new
session. Then use the button "Add Client to Session" and type in `fluajho`.
It should appear with an icon in the list and open its GUI.

### Installed without NSM
If you start fluajho directly it will present you with a dialog to choose your session directory.

You can also start fluajho from a terminal (or create a starter script).

`fluajho --save DIRECTORY`

Uses the given directory to save. The dir will be created or loaded from if already present. Use
the applications file menu to save (Ctrl+s).

You can use this to load and save the files from an existing NSM session. If you create a new
directory you can copy it manually to an NSM session directory, but that requires renaming the
directory to append the unique ID provided by NSM.

Sending SIGUSR1 to the program in this mode will trigger a save.

Closing through your window manager in this mode will actually quit the application without a
prompt to save changes.

## From source directory
You can run Fluajho after extracting the release archive or cloning from git, without installation.

### Calfbox
"Calfbox" is the name of our internal realtime midi/audio python module.

* You can either choose to install the module systemwide, which will make running all Laborejo Software Suite programs more convenient (when run from the source dir). Please consult https://github.com/kfoltman/calfbox 
* Or you just run `./configure` and `make calfbox` without subsequent install, which creates a `site-packages` directory in the source dir.
* A third option is `fluajho --mute` which runs without sound at all and does not need calfbox.

### From source directory with NSM
The developer uses this way to develop and use the software, so it will always be as stable as the
compiled version. But it is a bit less performant than building and installing it.

After extracting the release archive create a symlink from `fluajho` into your PATH. e.g. /usr/bin
or ~/bin, if that exists on your system.

If you compiled without installing you can also symlink to `./fluajho.bin`

### From source dir without NSM
Use `./fluajho --save` (see above). If you compiled without installing you can also run `./fluajho.bin`

### No NSM, no Make, No Sound
Combining the above options you can start the program directly after unpacking or cloning from git:

`./fluajho --save /tmp --mute`

Or even shorter:

`./fluajho -s /tmp -m`

This is the minimal run mode which is only useful for testing and development. But if you only want
to look at the GUI and are not in the mood to install anything -including dependencies-, go ahead.

