/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.ShapeField;
import org.apache.lucene.document.XYShapeBoundingBoxQuery;
import org.apache.lucene.document.XYShapeLineQuery;
import org.apache.lucene.document.XYShapePolygonQuery;
import org.apache.lucene.geo.Tessellator;
import org.apache.lucene.geo.XYEncodingUtils;
import org.apache.lucene.geo.XYLine;
import org.apache.lucene.geo.XYPolygon;
import org.apache.lucene.search.Query;

public class XYShape {
    private XYShape() {
    }

    public static Field[] createIndexableFields(String fieldName, XYPolygon polygon) {
        List<Tessellator.Triangle> tessellation = Tessellator.tessellate(polygon);
        ArrayList<ShapeField.Triangle> fields = new ArrayList<ShapeField.Triangle>(tessellation.size());
        for (Tessellator.Triangle t : tessellation) {
            fields.add(new ShapeField.Triangle(fieldName, t));
        }
        return fields.toArray(new Field[fields.size()]);
    }

    public static Field[] createIndexableFields(String fieldName, XYLine line) {
        int numPoints = line.numPoints();
        Field[] fields = new Field[numPoints - 1];
        int i = 0;
        for (int j = 1; j < numPoints; ++j) {
            fields[i] = new ShapeField.Triangle(fieldName, XYEncodingUtils.encode(line.getX(i)), XYEncodingUtils.encode(line.getY(i)), XYEncodingUtils.encode(line.getX(j)), XYEncodingUtils.encode(line.getY(j)), XYEncodingUtils.encode(line.getX(i)), XYEncodingUtils.encode(line.getY(i)));
            ++i;
        }
        return fields;
    }

    public static Field[] createIndexableFields(String fieldName, float x, float y) {
        return new Field[]{new ShapeField.Triangle(fieldName, XYEncodingUtils.encode(x), XYEncodingUtils.encode(y), XYEncodingUtils.encode(x), XYEncodingUtils.encode(y), XYEncodingUtils.encode(x), XYEncodingUtils.encode(y))};
    }

    public static Query newBoxQuery(String field, ShapeField.QueryRelation queryRelation, float minX, float maxX, float minY, float maxY) {
        return new XYShapeBoundingBoxQuery(field, queryRelation, minX, maxX, minY, maxY);
    }

    public static Query newLineQuery(String field, ShapeField.QueryRelation queryRelation, XYLine ... lines) {
        return new XYShapeLineQuery(field, queryRelation, lines);
    }

    public static Query newPolygonQuery(String field, ShapeField.QueryRelation queryRelation, XYPolygon ... polygons) {
        return new XYShapePolygonQuery(field, queryRelation, polygons);
    }
}

