/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.compiler.task;

import org.eclipse.dltk.compiler.task.ITodoTaskPreferences;
import org.eclipse.dltk.compiler.task.TodoTaskSimpleParser;

public class TodoTaskRangeParser
extends TodoTaskSimpleParser {
    private static final int ALLOC_INCREMENT = 1024;
    private boolean checkRanges = true;
    private int[] ranges = new int[1024];
    private int rangeCount = 0;

    public TodoTaskRangeParser(ITodoTaskPreferences preferences) {
        super(preferences);
    }

    public boolean isCheckRanges() {
        return this.checkRanges;
    }

    public void setCheckRanges(boolean value) {
        this.checkRanges = value;
    }

    protected void reset() {
        this.rangeCount = 0;
    }

    protected void excludeRange(int sourceStart, int sourceEnd) {
        if (this.rangeCount * 2 >= this.ranges.length) {
            int[] newArray = new int[this.ranges.length + 1024];
            System.arraycopy(this.ranges, 0, newArray, 0, this.ranges.length);
            this.ranges = newArray;
        }
        this.ranges[this.rangeCount * 2] = sourceStart;
        this.ranges[this.rangeCount * 2 + 1] = sourceEnd;
        ++this.rangeCount;
    }

    protected boolean isValid(int location) {
        int i = 0;
        while (i < this.rangeCount) {
            if (location >= this.ranges[i * 2] && location < this.ranges[i * 2 + 1]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    protected int findCommentStart(char[] content, int begin, int end) {
        if (!this.checkRanges) {
            return super.findCommentStart(content, begin, end);
        }
        int i = begin;
        while (i < end) {
            if (content[i] == '#' && this.isValid(i)) {
                return i + 1;
            }
            ++i;
        }
        return -1;
    }
}

