/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java;

import java.util.StringTokenizer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.texteditor.ITextEditorExtension3;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;

public class JavaStringAutoIndentStrategy
extends DefaultIndentLineAutoEditStrategy {
    private String fPartitioning;

    private String displayString(String inputString, String indentation, String delimiter) {
        int length = inputString.length();
        StringBuffer buffer = new StringBuffer(length);
        StringTokenizer tokenizer = new StringTokenizer(inputString, "\n\r", true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("\r")) {
                buffer.append("\\r");
                if (!tokenizer.hasMoreTokens()) continue;
                token = tokenizer.nextToken();
                if (token.equals("\n")) {
                    buffer.append("\\n");
                    buffer.append("\" + " + delimiter);
                    buffer.append(indentation);
                    buffer.append("\"");
                    continue;
                }
                buffer.append("\" + " + delimiter);
                buffer.append(indentation);
                buffer.append("\"");
            } else if (token.equals("\n")) {
                buffer.append("\\n");
                buffer.append("\" + " + delimiter);
                buffer.append(indentation);
                buffer.append("\"");
                continue;
            }
            StringBuffer tokenBuffer = new StringBuffer();
            int i = 0;
            while (i < token.length()) {
                char c = token.charAt(i);
                switch (c) {
                    case '\r': {
                        tokenBuffer.append("\\r");
                        break;
                    }
                    case '\n': {
                        tokenBuffer.append("\\n");
                        break;
                    }
                    case '\b': {
                        tokenBuffer.append("\\b");
                        break;
                    }
                    case '\t': {
                        tokenBuffer.append("\t");
                        break;
                    }
                    case '\f': {
                        tokenBuffer.append("\\f");
                        break;
                    }
                    case '\"': {
                        tokenBuffer.append("\\\"");
                        break;
                    }
                    case '\'': {
                        tokenBuffer.append("\\'");
                        break;
                    }
                    case '\\': {
                        tokenBuffer.append("\\\\");
                        break;
                    }
                    default: {
                        tokenBuffer.append(c);
                    }
                }
                ++i;
            }
            buffer.append(tokenBuffer);
        }
        return buffer.toString();
    }

    public JavaStringAutoIndentStrategy(String partitioning) {
        this.fPartitioning = partitioning;
    }

    private boolean isLineDelimiter(IDocument document, String text) {
        String[] delimiters = document.getLegalLineDelimiters();
        if (delimiters != null) {
            return TextUtilities.equals((String[])delimiters, (String)text) > -1;
        }
        return false;
    }

    private String getLineIndentation(IDocument document, int offset) throws BadLocationException {
        int adjustedOffset = offset == document.getLength() ? offset - 1 : offset;
        IRegion line = document.getLineInformationOfOffset(adjustedOffset);
        int start = line.getOffset();
        int end = this.findEndOfWhiteSpace(document, start, offset);
        return document.get(start, end - start);
    }

    private String getModifiedText(String string, String indentation, String delimiter) {
        return this.displayString(string, indentation, delimiter);
    }

    private void javaStringIndentAfterNewLine(IDocument document, DocumentCommand command) throws BadLocationException {
        int length;
        ITypedRegion partition = TextUtilities.getPartition((IDocument)document, (String)this.fPartitioning, (int)command.offset, (boolean)true);
        int offset = partition.getOffset();
        if (command.offset == offset + (length = partition.getLength()) && document.getChar(offset + length - 1) == '\"') {
            return;
        }
        String indentation = this.getLineIndentation(document, command.offset);
        String delimiter = TextUtilities.getDefaultLineDelimiter((IDocument)document);
        IRegion line = document.getLineInformationOfOffset(offset);
        String string = document.get(line.getOffset(), offset - line.getOffset());
        if (string.trim().length() != 0) {
            indentation = String.valueOf(indentation) + String.valueOf("\t\t");
        }
        IPreferenceStore preferenceStore = JavaScriptPlugin.getDefault().getPreferenceStore();
        if (this.isLineDelimiter(document, command.text)) {
            command.text = "\" +" + command.text + indentation + "\"";
        } else if (command.text.length() > 1 && preferenceStore.getBoolean("escapeStrings")) {
            command.text = this.getModifiedText(command.text, indentation, delimiter);
        }
    }

    private boolean isSmartMode() {
        IEditorPart part;
        IWorkbenchPage page = JavaScriptPlugin.getActivePage();
        if (page != null && (part = page.getActiveEditor()) instanceof ITextEditorExtension3) {
            ITextEditorExtension3 extension = (ITextEditorExtension3)part;
            return extension.getInsertMode() == ITextEditorExtension3.SMART_INSERT;
        }
        return false;
    }

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        try {
            if (command.text == null) {
                return;
            }
            IPreferenceStore preferenceStore = JavaScriptPlugin.getDefault().getPreferenceStore();
            if (preferenceStore.getBoolean("wrapStrings") && this.isSmartMode()) {
                this.javaStringIndentAfterNewLine(document, command);
            }
        }
        catch (BadLocationException badLocationException) {}
    }
}

