/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.envelope;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import javax.xml.namespace.QName;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionFailException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionNotApplicableException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionPassException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseMessageValidator;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.HTTPUtils;
import org.eclipse.wst.wsi.internal.core.util.OperationSignature;
import org.eclipse.wst.wsi.internal.core.util.TypesRegistry;
import org.eclipse.wst.wsi.internal.core.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BP1204
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public BP1204(BaseMessageValidator impl) {
        super(impl);
        this.validator = impl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            TypesRegistry registry;
            Binding binding;
            OperationSignature.OperationMatch match;
            if (this.validator.isOneWayResponse(entryContext)) {
                throw new AssertionNotApplicableException();
            }
            Document doc = XMLUtils.parseXML(entryContext.getMessageEntry().getMessage());
            if (this.validator.isFault(doc)) {
                throw new AssertionPassException();
            }
            Document docRequest = XMLUtils.parseXML(entryContext.getRequest().getMessage());
            String headers = entryContext.getRequest().getHTTPHeaders();
            String action = null;
            if (headers != null) {
                action = (String)HTTPUtils.getHttpHeaderTokens(headers, ":").get("SOAPAction".toUpperCase());
            }
            if ((match = OperationSignature.matchOperation(docRequest, action, binding = this.validator.analyzerContext.getCandidateInfo().getBindings()[0], registry = new TypesRegistry(this.validator.getWSDLDocument().getDefinitions(), this.validator))) == null) {
                throw new AssertionPassException();
            }
            BindingOperation bindingOperation = match.getOperation();
            Message operationMessage = null;
            if ("request".equals(entryContext.getMessageEntry().getType()) && bindingOperation.getOperation().getInput() != null) {
                operationMessage = bindingOperation.getOperation().getInput().getMessage();
            } else if ("response".equals(entryContext.getMessageEntry().getType()) && bindingOperation.getOperation().getOutput() != null) {
                operationMessage = bindingOperation.getOperation().getOutput().getMessage();
            }
            if (operationMessage == null) {
                throw new AssertionPassException();
            }
            boolean isContainArray = false;
            Collection parts = operationMessage.getParts().values();
            Iterator iter = parts.iterator();
            while (iter.hasNext()) {
                Part part = (Part)iter.next();
                QName type = null;
                type = part.getTypeName() == null ? registry.getType(part.getElementName()) : part.getTypeName();
                boolean bl = isContainArray = registry.isExtendsArray(type) || registry.isUsesWSDLArrayType(type) || this.isArrayType(type);
                if (isContainArray) break;
            }
            if (isContainArray) {
                NodeList soapBodyList = doc.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Body");
                if (soapBodyList.getLength() == 0 || soapBodyList.getLength() > 1) {
                    throw new AssertionFailException();
                }
                Element soapBodyElem = (Element)soapBodyList.item(0);
                NodeList soapBodyCildrenList = soapBodyElem.getElementsByTagNameNS("*", "*");
                int indexChild = 0;
                while (indexChild < soapBodyCildrenList.getLength()) {
                    Element elem = (Element)soapBodyCildrenList.item(indexChild);
                    if (elem.hasAttributeNS("http://schemas.xmlsoap.org/soap/encoding/", "arrayType")) {
                        throw new AssertionFailException();
                    }
                    ++indexChild;
                }
                throw new AssertionPassException();
            }
            throw new AssertionPassException();
        }
        catch (AssertionNotApplicableException assertionNotApplicableException) {
            this.result = "notApplicable";
        }
        catch (AssertionFailException assertionFailException) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(entryContext.getMessageEntry().getMessage(), entryContext);
        }
        catch (AssertionPassException assertionPassException) {
            this.result = "passed";
        }
        catch (Exception exception) {
            this.result = "notApplicable";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private boolean isArrayType(QName type) {
        NodeList list;
        boolean arrayType = false;
        Element typeElement = this.getTypeElement(type);
        if (typeElement != null && (list = typeElement.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "sequence")).getLength() > 0) {
            arrayType = true;
        }
        return arrayType;
    }

    private Element getTypeElement(QName type) {
        Types[] allTypes = this.validator.analyzerContext.getCandidateInfo().getTypes();
        int i = 0;
        while (allTypes != null && i < allTypes.length) {
            Element typesElement = null;
            if (allTypes[i] != null) {
                typesElement = allTypes[i].getDocumentationElement();
                if (typesElement == null) {
                    List extList = allTypes[i].getExtensibilityElements();
                    Iterator iter = extList.iterator();
                    while (iter.hasNext()) {
                        ExtensibilityElement extElem = (ExtensibilityElement)iter.next();
                        if (!extElem.getElementType().equals(new QName("http://www.w3.org/2001/XMLSchema", "schema"))) continue;
                        typesElement = ((Schema)extElem).getElement();
                        break;
                    }
                }
                if (typesElement != null) {
                    NodeList complexTypesList = typesElement.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "complexType");
                    int j = 0;
                    while (j < complexTypesList.getLength()) {
                        Element typeElem = (Element)complexTypesList.item(j);
                        if (type.getLocalPart().equals(typeElem.getAttribute("name"))) {
                            return typeElem;
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        return null;
    }
}

