/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.contentassist;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.core.IImportContainer;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jst.jsp.core.internal.provisional.contenttype.ContentTypeIdForJSP;
import org.eclipse.jst.jsp.ui.internal.Logger;
import org.eclipse.jst.jsp.ui.internal.contentassist.JSPCompletionProposal;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AutoImportProposal
extends JSPCompletionProposal {
    String fImportDeclaration;
    IImportContainer fImportContainer;

    public AutoImportProposal(String importDeclaration, String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo, int relevance, boolean updateReplacementLengthOnValidate) {
        super(replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo, relevance, updateReplacementLengthOnValidate);
        this.setImportDeclaration(importDeclaration);
    }

    public AutoImportProposal(String importDeclaration, IImportContainer importContainer, String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo, int relevance, boolean updateReplacementLengthOnValidate) {
        this(importDeclaration, replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo, relevance, updateReplacementLengthOnValidate);
        this.fImportContainer = importContainer;
    }

    @Override
    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        super.apply(viewer, trigger, stateMask, offset);
        String importDecl = this.getImportDeclaration().replaceAll(";", "");
        if (this.fImportContainer == null || !this.fImportContainer.getImport(importDecl).exists() && !this.isImportPageDirective(viewer, offset)) {
            this.addImportDeclaration(viewer);
        }
    }

    private boolean isImportPageDirective(ITextViewer viewer, int offset) {
        NamedNodeMap nodeMap;
        Node node = (Node)ContentAssistUtils.getNodeAt((ITextViewer)viewer, (int)offset);
        while (node != null && node.getNodeType() == 3 && node.getParentNode() != null) {
            node = node.getParentNode();
        }
        if (node.getNodeName().equalsIgnoreCase("jsp:directive.page") && (nodeMap = node.getAttributes()) != null) {
            return nodeMap.getNamedItem("import") != null;
        }
        return false;
    }

    private void addImportDeclaration(ITextViewer viewer) {
        IDocument doc = viewer.getDocument();
        boolean isXml = this.isXmlFormat(doc);
        int insertPosition = this.getInsertPosition(doc, isXml);
        String insertText = this.createImportDeclaration(doc, isXml);
        InsertEdit insert = new InsertEdit(insertPosition, insertText);
        try {
            insert.apply(doc);
        }
        catch (MalformedTreeException e) {
            Logger.logException(e);
        }
        catch (BadLocationException e) {
            Logger.logException(e);
        }
        this.setCursorPosition(this.getCursorPosition() + insertText.length());
    }

    private Node getInsertNode(IDOMDocument documentNode) {
        NodeList childNodes = documentNode.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            if (childNodes.item(i).getNodeType() == 1) {
                return childNodes.item(i);
            }
            ++i;
        }
        return documentNode.getFirstChild();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getInsertPosition(IDocument doc, boolean isXml) {
        int pos = 0;
        IStructuredModel sModel = StructuredModelManager.getModelManager().getExistingModelForRead(doc);
        try {
            if (sModel == null) return pos;
            if (!(sModel instanceof IDOMModel)) return pos;
            IDOMDocument documentNode = ((IDOMModel)sModel).getDocument();
            Node targetElement = null;
            if (isXml) {
                targetElement = documentNode.getDocumentElement();
            }
            if (targetElement == null) {
                targetElement = this.getInsertNode(documentNode);
            }
            if (targetElement != null) {
                IStructuredDocumentRegion sdRegion = ((IDOMNode)targetElement).getFirstStructuredDocumentRegion();
                if (!isXml) {
                    pos = sdRegion.getStartOffset();
                    return pos;
                }
                pos = sdRegion.getEndOffset();
                try {
                    while (pos < doc.getLength()) {
                        if (doc.getChar(pos) != '\r' && doc.getChar(pos) != '\n') {
                            return pos;
                        }
                        ++pos;
                    }
                    return pos;
                }
                catch (BadLocationException badLocationException) {
                    return pos;
                }
            }
            pos = 0;
            return pos;
        }
        finally {
            if (sModel != null) {
                sModel.releaseFromRead();
            }
        }
    }

    private boolean isCustomTagDocument(IDocument doc) {
        boolean isTag = false;
        IStructuredModel sModel = StructuredModelManager.getModelManager().getExistingModelForRead(doc);
        try {
            String contentType;
            if (sModel instanceof IDOMModel && (contentType = ((IDOMModel)sModel).getContentTypeIdentifier()) != null) {
                IContentType modelCT = Platform.getContentTypeManager().getContentType(contentType);
                IContentType tagCT = Platform.getContentTypeManager().getContentType(ContentTypeIdForJSP.ContentTypeID_JSPTAG);
                if (modelCT != null && tagCT != null) {
                    isTag = modelCT.isKindOf(tagCT);
                }
            }
        }
        finally {
            if (sModel != null) {
                sModel.releaseFromRead();
            }
        }
        return isTag;
    }

    private boolean isXmlFormat(IDocument doc) {
        boolean isXml = false;
        IStructuredModel sModel = StructuredModelManager.getModelManager().getExistingModelForRead(doc);
        try {
            if (sModel != null && !isXml && sModel instanceof IDOMModel) {
                IDOMDocument documentNode = ((IDOMModel)sModel).getDocument();
                Element docElement = documentNode.getDocumentElement();
                isXml = docElement != null && (docElement.getNodeName().equals("jsp:root") || docElement.getAttributeNode("xmlns:jsp") != null || ((IDOMNode)docElement).getStartStructuredDocumentRegion() == null && ((IDOMNode)docElement).getEndStructuredDocumentRegion() == null);
            }
        }
        finally {
            if (sModel != null) {
                sModel.releaseFromRead();
            }
        }
        return isXml;
    }

    private String createImportDeclaration(IDocument doc, boolean isXml) {
        String closing;
        String opening;
        String delim = doc instanceof IStructuredDocument ? ((IStructuredDocument)doc).getLineDelimiter() : TextUtilities.getDefaultLineDelimiter((IDocument)doc);
        boolean isCustomTag = this.isCustomTagDocument(doc);
        if (isCustomTag) {
            if (isXml) {
                opening = "<jsp:directive.tag import=\"";
                closing = "\"/>";
            } else {
                opening = "<%@tag import=\"";
                closing = "\"%>";
            }
        } else if (isXml) {
            opening = "<jsp:directive.page import=\"";
            closing = "\"/>";
        } else {
            opening = "<%@page import=\"";
            closing = "\"%>";
        }
        return String.valueOf(opening) + this.getImportDeclaration() + closing + delim;
    }

    public String getImportDeclaration() {
        return this.fImportDeclaration;
    }

    public void setImportDeclaration(String importDeclaration) {
        this.fImportDeclaration = importDeclaration;
    }
}

