/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.model.timegraph;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.tmf.core.TmfStrings;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphState;

public class TimeGraphState
implements ITimeGraphState {
    private final long fStartTime;
    private final long fDuration;
    private final int fValue;
    private final @Nullable String fLabel;
    private int fActiveProperties = 0;

    public TimeGraphState(long time, long duration, int value) {
        this.fStartTime = time;
        this.fDuration = duration;
        this.fValue = value;
        this.fLabel = null;
    }

    public TimeGraphState(long time, long duration, int value, String label) {
        this.fStartTime = time;
        this.fDuration = duration;
        this.fValue = value;
        this.fLabel = label;
    }

    @Override
    public long getStartTime() {
        return this.fStartTime;
    }

    @Override
    public long getDuration() {
        return this.fDuration;
    }

    @Override
    public int getValue() {
        return this.fValue;
    }

    @Override
    public @Nullable String getLabel() {
        return this.fLabel;
    }

    @Override
    public Multimap<String, Object> getMetadata() {
        HashMultimap toTest = HashMultimap.create();
        String label = this.getLabel();
        if (label != null) {
            toTest.put((Object)"label", (Object)label);
        }
        toTest.put((Object)TmfStrings.startTime(), (Object)this.fStartTime);
        toTest.put((Object)TmfStrings.endTime(), (Object)(this.fStartTime + this.fDuration));
        toTest.put((Object)TmfStrings.duration(), (Object)this.fDuration);
        return toTest;
    }

    @Override
    public int getActiveProperties() {
        return this.fActiveProperties;
    }

    @Override
    public void setActiveProperties(int activeProperties) {
        this.fActiveProperties = activeProperties;
    }

    @Override
    @Deprecated
    public Map<String, String> computeData() {
        HashMap<String, String> toTest = new HashMap<String, String>();
        String label = this.getLabel();
        if (label != null) {
            toTest.put("label", label);
        }
        return toTest;
    }
}

