/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.table;

import com.google.common.annotations.VisibleForTesting;
import java.io.OutputStream;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.table.AbstractSegmentStoreTableViewer;
import org.eclipse.tracecompass.internal.tmf.ui.commands.ExportToTsvAction;
import org.eclipse.tracecompass.internal.tmf.ui.commands.ExportToTsvUtils;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.views.TmfView;

public abstract class AbstractSegmentStoreTableView
extends TmfView {
    private final Action fExportAction = new ExportToTsvAction(){

        protected void exportToTsv(@Nullable OutputStream stream) {
            AbstractSegmentStoreTableView.this.exportToTsv(stream);
        }

        protected @Nullable Shell getShell() {
            return AbstractSegmentStoreTableView.this.getViewSite().getShell();
        }
    };
    private @Nullable AbstractSegmentStoreTableViewer fSegmentStoreViewer;

    public AbstractSegmentStoreTableView() {
        super("");
    }

    public void createPartControl(@Nullable Composite parent) {
        super.createPartControl(parent);
        SashForm sf = new SashForm(parent, 0);
        TableViewer tableViewer = new TableViewer((Composite)sf, 0x10010000);
        this.fSegmentStoreViewer = this.createSegmentStoreViewer(tableViewer);
        this.getViewSite().getActionBars().getMenuManager().add((IAction)this.fExportAction);
        ITmfTrace trace = TmfTraceManager.getInstance().getActiveTrace();
        if (trace != null) {
            TmfTraceSelectedSignal signal = new TmfTraceSelectedSignal((Object)this, trace);
            if (this.fSegmentStoreViewer != null) {
                this.fSegmentStoreViewer.traceSelected(signal);
            }
        }
        this.setInitialData();
    }

    public void setFocus() {
        if (this.fSegmentStoreViewer != null) {
            this.fSegmentStoreViewer.getTableViewer().getControl().setFocus();
        }
    }

    public void dispose() {
        super.dispose();
        if (this.fSegmentStoreViewer != null) {
            this.fSegmentStoreViewer.dispose();
        }
    }

    protected abstract AbstractSegmentStoreTableViewer createSegmentStoreViewer(TableViewer var1);

    public @Nullable AbstractSegmentStoreTableViewer getSegmentStoreViewer() {
        return this.fSegmentStoreViewer;
    }

    private void setInitialData() {
        if (this.fSegmentStoreViewer != null) {
            this.fSegmentStoreViewer.setData(this.fSegmentStoreViewer.getSegmentProvider());
        }
    }

    @VisibleForTesting
    protected void exportToTsv(@Nullable OutputStream stream) {
        AbstractSegmentStoreTableViewer segmentStoreViewer = this.getSegmentStoreViewer();
        if (segmentStoreViewer == null) {
            return;
        }
        Table table = segmentStoreViewer.getTableViewer().getTable();
        ExportToTsvUtils.exportTableToTsv((Table)table, (OutputStream)stream);
    }
}

