/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.sse.core.internal.Logger;
import org.eclipse.wst.sse.core.internal.SSECorePlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public abstract class AbstractMemoryListener
implements EventHandler {
    public static final String SEV_NORMAL = "org/eclipse/equinox/events/MemoryEvent/NORMAL";
    public static final String SEV_SERIOUS = "org/eclipse/equinox/events/MemoryEvent/SERIOUS";
    public static final String SEV_CRITICAL = "org/eclipse/equinox/events/MemoryEvent/CRITICAL";
    public static final String[] SEV_ALL = new String[]{"org/eclipse/equinox/events/MemoryEvent/NORMAL", "org/eclipse/equinox/events/MemoryEvent/SERIOUS", "org/eclipse/equinox/events/MemoryEvent/CRITICAL"};
    private static BundleContext CONTEXT = SSECorePlugin.getDefault() != null ? SSECorePlugin.getDefault().getBundle().getBundleContext() : null;
    private final List fSeverities;
    private ServiceRegistration fRegisterService;

    public AbstractMemoryListener() {
        this(SEV_ALL);
    }

    public AbstractMemoryListener(String severity) {
        Assert.isNotNull((Object)severity, (String)"Severity can not be null");
        ArrayList<String> severities = new ArrayList<String>(1);
        severities.add(severity);
        this.fSeverities = severities;
    }

    public AbstractMemoryListener(String[] severities) {
        Assert.isNotNull((Object)severities, (String)"Severities can not be null");
        Assert.isLegal((severities.length > 0 ? 1 : 0) != 0, (String)"Severities must specify at least one severity");
        this.fSeverities = Arrays.asList(severities);
    }

    public AbstractMemoryListener(List severities) {
        Assert.isNotNull((Object)severities, (String)"Severities can not be null");
        Assert.isLegal((!severities.isEmpty() ? 1 : 0) != 0, (String)"Severities must specify at least one severity");
        this.fSeverities = severities;
    }

    public final void connect() {
        if (CONTEXT != null) {
            Bundle b = Platform.getBundle((String)"org.eclipse.equinox.event");
            if (b != null && b.getState() == 4) {
                try {
                    b.start(1);
                }
                catch (BundleException e) {
                    e.printStackTrace();
                }
            }
            String[] severities = this.fSeverities.toArray(new String[this.fSeverities.size()]);
            Hashtable<String, String[]> prop = new Hashtable<String, String[]>(1);
            prop.put("event.topics", severities);
            this.fRegisterService = CONTEXT.registerService(EventHandler.class.getName(), (Object)this, prop);
            this.doConnect();
        } else {
            Logger.log(2, "Error accessing bundle context. Is Platform running? Not tracking memory events. ");
        }
    }

    public final void disconnect() {
        if (this.fRegisterService != null) {
            this.fRegisterService.unregister();
            this.fRegisterService = null;
        }
        this.doDisconnect();
    }

    public final void handleEvent(Event event) {
        if (this.fSeverities.contains(event.getTopic())) {
            this.handleMemoryEvent(event);
        }
    }

    protected abstract void handleMemoryEvent(Event var1);

    protected void doConnect() {
    }

    protected void doDisconnect() {
    }
}

