/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mssql.SQLServerUtils;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDataSource;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDatabase;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerObject;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableBase;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPStatefulObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectState;
import org.jkiss.dbeaver.model.struct.DBSObjectWithScript;
import org.jkiss.dbeaver.model.struct.rdb.DBSTrigger;

public abstract class SQLServerTriggerBase<OWNER extends DBSObject>
implements DBSTrigger,
DBSObjectWithScript,
DBPQualifiedObject,
DBPRefreshableObject,
SQLServerObject,
DBPStatefulObject {
    private OWNER container;
    private String name;
    private String type;
    private String body;
    private long objectId;
    private boolean insteadOfTrigger;
    private volatile int disabled;
    private volatile boolean persisted;

    public SQLServerTriggerBase(OWNER container, ResultSet dbResult) {
        this.container = container;
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"name");
        this.type = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"type");
        this.objectId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"object_id");
        this.insteadOfTrigger = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"is_instead_of_trigger") != 0;
        this.disabled = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"is_disabled");
        this.persisted = true;
    }

    public SQLServerTriggerBase(OWNER container, String name) {
        this.container = container;
        this.name = name;
        this.body = "";
        this.persisted = false;
    }

    public SQLServerTriggerBase(OWNER container, SQLServerTriggerBase source) {
        this.container = container;
        this.name = source.name;
        this.type = source.type;
        this.body = source.body;
        this.persisted = source.persisted;
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Property(viewable=false, order=10)
    public long getObjectId() {
        return this.objectId;
    }

    @Property(viewable=true, order=11)
    public boolean isInsteadOfTrigger() {
        return this.insteadOfTrigger;
    }

    public void setInsteadOfTrigger(boolean insteadOfTrigger) {
        this.insteadOfTrigger = insteadOfTrigger;
    }

    @Property(viewable=false, order=20)
    public boolean isDisabled() {
        return this.disabled != 0;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = 1;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public OWNER getParentObject() {
        return this.container;
    }

    public String getDescription() {
        return null;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    @Override
    @NotNull
    public SQLServerDataSource getDataSource() {
        return (SQLServerDataSource)this.container.getDataSource();
    }

    @Property(hidden=true, editable=true, updatable=true, order=-1)
    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        if (this.body == null && this.isPersisted()) {
            OWNER owner = this.getParentObject();
            SQLServerDatabase database = null;
            if (owner instanceof SQLServerDatabase) {
                database = (SQLServerDatabase)owner;
            } else if (owner instanceof SQLServerTableBase) {
                database = ((SQLServerTableBase)owner).getDatabase();
            }
            this.body = SQLServerUtils.extractSource(monitor, database, this);
        }
        return this.body;
    }

    @NotNull
    public DBSObjectState getObjectState() {
        if (this.disabled != 0) {
            return DBSObjectState.INVALID;
        }
        return DBSObjectState.NORMAL;
    }

    public void refreshObjectState(@NotNull DBRProgressMonitor monitor) throws DBCException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Refresh triggers state");){
                Throwable throwable2 = null;
                Object var6_10 = null;
                try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT is_disabled FROM sys.triggers WHERE object_id=?");){
                    dbStat.setLong(1, this.getObjectId());
                    Throwable throwable3 = null;
                    Object var9_15 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        if (dbResult.next()) {
                            this.disabled = JDBCUtils.safeGetInt((ResultSet)dbResult, (int)1);
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBCException(e, (DBPDataSource)this.getDataSource());
        }
    }

    public void setObjectDefinitionText(String sourceText) {
        this.body = sourceText;
    }

    public String toString() {
        return this.getName();
    }
}

