/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.ui.wizard;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.impl.DataSourceContextProvider;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProjectDatabases;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.data.SQLQueryDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskConfigPanel;
import org.jkiss.dbeaver.model.task.DBTTaskConfigurator;
import org.jkiss.dbeaver.model.task.DBTTaskType;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ui.UIServiceSQL;
import org.jkiss.dbeaver.tools.transfer.DataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.IDataTransferNode;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseTransferProducer;
import org.jkiss.dbeaver.tools.transfer.ui.wizard.DataTransferWizard;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.ui.navigator.dialogs.BrowseObjectDialog;
import org.jkiss.dbeaver.ui.navigator.dialogs.SelectDataSourceDialog;
import org.jkiss.utils.ArrayUtils;

public class DataTransferTaskConfigurator
implements DBTTaskConfigurator {
    private static final Log log = Log.getLog(DataTransferTaskConfigurator.class);

    public ConfigPanel createInputConfigurator(DBRRunnableContext runnableContext, @NotNull DBTTaskType taskType) {
        return new ConfigPanel(runnableContext, taskType);
    }

    public IWizard createTaskConfigWizard(@NotNull DBTTask taskConfiguration) {
        return new DataTransferWizard(UIUtils.getDefaultRunnableContext(), taskConfiguration);
    }

    private static class ConfigPanel
    implements DBTTaskConfigPanel {
        private DBRRunnableContext runnableContext;
        private DBTTaskType taskType;
        private Table objectsTable;
        private DBPProject currentProject;
        private DataTransferWizard dtWizard;

        ConfigPanel(DBRRunnableContext runnableContext, DBTTaskType taskType) {
            this.runnableContext = runnableContext;
            this.taskType = taskType;
            this.currentProject = NavigatorUtils.getSelectedProject();
        }

        public DBPDataSource getLastDataSource() {
            int itemCount = this.objectsTable.getItemCount();
            DBSObject lastObject = itemCount <= 0 ? null : (DBSObject)this.objectsTable.getItem(itemCount - 1).getData();
            return lastObject == null ? null : lastObject.getDataSource();
        }

        public void createControl(Object parent, Object wizard, final Runnable propertyChangeListener) {
            this.dtWizard = (DataTransferWizard)((Object)wizard);
            final boolean isExport = this.isExport();
            final Group group = UIUtils.createControlGroup((Composite)((Composite)parent), (String)("dataExport".equals(this.taskType.getId()) ? "Export tables" : "Import into"), (int)1, (int)1808, (int)0);
            this.objectsTable = new Table((Composite)group, 2052);
            this.objectsTable.setLayoutData((Object)new GridData(1808));
            UIUtils.createTableColumn((Table)this.objectsTable, (int)0, (String)"Object");
            UIUtils.createTableColumn((Table)this.objectsTable, (int)0, (String)"Data Source");
            Composite buttonsPanel = UIUtils.createComposite((Composite)group, (int)(isExport ? 3 : 2));
            UIUtils.createDialogButton((Composite)buttonsPanel, (String)"Add Table ...", (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    List tables;
                    DBPDataSource lastDataSource;
                    Class tableClass = isExport ? DBSDataContainer.class : DBSDataManipulator.class;
                    DBNProjectDatabases rootNode = DBWorkbench.getPlatform().getNavigatorModel().getRoot().getProjectNode(currentProject).getDatabases();
                    DBNDataSource selNode = null;
                    if (objectsTable.getItemCount() > 0 && (lastDataSource = this.getLastDataSource()) != null) {
                        selNode = rootNode.getDataSource(lastDataSource.getContainer().getId());
                    }
                    if ((tables = BrowseObjectDialog.selectObjects((Shell)group.getShell(), (String)(isExport ? "Choose source table(s)" : "Choose target table(s)"), (DBNNode)rootNode, (DBNNode)selNode, (Class[])new Class[]{DBSObjectContainer.class, tableClass}, (Class[])new Class[]{tableClass}, null)) != null) {
                        for (DBNNode node : tables) {
                            if (!(node instanceof DBNDatabaseNode)) continue;
                            this.addObjectToTable(((DBNDatabaseNode)node).getObject());
                        }
                        this.updateSettings(propertyChangeListener);
                    }
                }
            });
            if (isExport) {
                UIUtils.createDialogButton((Composite)buttonsPanel, (String)"Add Query ...", (SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        DataSourceContextProvider contextProvider;
                        String query;
                        UIServiceSQL serviceSQL;
                        SelectDataSourceDialog dsDialog;
                        DBPDataSource lastDataSource = this.getLastDataSource();
                        if (lastDataSource == null && (dsDialog = new SelectDataSourceDialog(group.getShell(), currentProject, null)).open() == 0) {
                            DBPDataSourceContainer dataSource = dsDialog.getDataSource();
                            if (!dataSource.isConnected()) {
                                try {
                                    runnableContext.run(true, true, monitor -> {
                                        try {
                                            dataSource.connect(monitor, true, true);
                                        }
                                        catch (DBException ex) {
                                            throw new InvocationTargetException(ex);
                                        }
                                    });
                                }
                                catch (InvocationTargetException ex) {
                                    DBWorkbench.getPlatformUI().showError("Error opening datasource", "Error while opening datasource", (Throwable)ex);
                                    return;
                                }
                                catch (InterruptedException interruptedException) {
                                    return;
                                }
                            }
                            lastDataSource = dataSource.getDataSource();
                        }
                        if (lastDataSource != null && (serviceSQL = (UIServiceSQL)DBWorkbench.getService(UIServiceSQL.class)) != null && (query = serviceSQL.openSQLEditor((DBPContextProvider)(contextProvider = new DataSourceContextProvider((DBSObject)lastDataSource)), "SQL Query", (DBPImage)UIIcon.SQL_SCRIPT, "")) != null) {
                            this.addObjectToTable((DBSObject)new SQLQueryDataContainer((DBPContextProvider)contextProvider, new SQLQuery(lastDataSource, query), log));
                            this.updateSettings(propertyChangeListener);
                        }
                    }
                });
            }
            final Button removeButton = UIUtils.createDialogButton((Composite)buttonsPanel, (String)"Remove", (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DBSObject object = (DBSObject)objectsTable.getItem(objectsTable.getSelectionIndex()).getData();
                    if (UIUtils.confirmAction((String)"Remove object", (String)("Remove object " + DBUtils.getObjectFullName((DBPNamedObject)object, (DBPEvaluationContext)DBPEvaluationContext.UI) + "?"))) {
                        objectsTable.remove(objectsTable.getSelectionIndex());
                        this.updateSettings(propertyChangeListener);
                    }
                }
            });
            removeButton.setEnabled(false);
            this.objectsTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    removeButton.setEnabled(objectsTable.getSelectionIndex() >= 0);
                }
            });
        }

        private void updateSettings(Runnable propertyChangeListener) {
            this.saveSettings();
            propertyChangeListener.run();
            UIUtils.asyncExec(() -> UIUtils.packColumns((Table)this.objectsTable, (boolean)true));
        }

        private boolean isExport() {
            return this.taskType.getId().equals("dataExport");
        }

        public void loadSettings() {
            DataTransferSettings settings = this.dtWizard.getSettings();
            ArrayList<Object> selectedObjects = new ArrayList<Object>();
            for (IDataTransferNode iDataTransferNode : ArrayUtils.safeArray((Object[])settings.getInitConsumers())) {
                if (!(iDataTransferNode instanceof DatabaseTransferConsumer)) continue;
                selectedObjects.add(((DatabaseTransferConsumer)iDataTransferNode).getTargetObject());
            }
            for (IDataTransferNode iDataTransferNode : ArrayUtils.safeArray((Object[])settings.getInitProducers())) {
                if (!(iDataTransferNode instanceof DatabaseTransferProducer)) continue;
                selectedObjects.add(((DatabaseTransferProducer)iDataTransferNode).getDatabaseObject());
            }
            if (!selectedObjects.isEmpty()) {
                for (DBSObject dBSObject : selectedObjects) {
                    if (dBSObject == null) continue;
                    this.addObjectToTable(dBSObject);
                }
            }
            UIUtils.asyncExec(() -> UIUtils.packColumns((Table)this.objectsTable, (boolean)true));
        }

        private void addObjectToTable(DBSObject object) {
            TableItem item = new TableItem(this.objectsTable, 0);
            item.setData((Object)object);
            item.setImage(0, DBeaverIcons.getImage((DBPImage)DBValueFormatting.getObjectImage((DBPObject)object)));
            item.setText(0, DBUtils.getObjectFullName((DBPNamedObject)object, (DBPEvaluationContext)DBPEvaluationContext.UI));
            if (object.getDataSource() != null) {
                item.setText(1, object.getDataSource().getContainer().getName());
            }
        }

        public void saveSettings() {
            TableItem[] items;
            if (this.objectsTable == null) {
                return;
            }
            boolean isExport = this.isExport();
            ArrayList<DatabaseTransferProducer> producers = isExport ? new ArrayList<DatabaseTransferProducer>() : null;
            ArrayList<DatabaseTransferConsumer> consumers = isExport ? null : new ArrayList<DatabaseTransferConsumer>();
            TableItem[] tableItemArray = items = this.objectsTable.getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                DBSObject object = (DBSObject)item.getData();
                if (object instanceof DBSDataContainer) {
                    if (isExport) {
                        producers.add(new DatabaseTransferProducer((DBSDataContainer)object));
                    } else if (object instanceof DBSDataManipulator) {
                        consumers.add(new DatabaseTransferConsumer((DBSDataManipulator)object));
                    }
                }
                ++n2;
            }
            this.dtWizard.getSettings().setDataPipes(producers, consumers);
            this.dtWizard.loadSettings(this.dtWizard.getRunnableContext());
        }

        public boolean isComplete() {
            return this.objectsTable.getItemCount() > 0;
        }
    }
}

