/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;

@BugPattern(name="ForOverride", summary="Method annotated @ForOverride must be protected or package-private and only invoked from declaring class, or from an override of the method", category=BugPattern.Category.GUAVA, severity=BugPattern.SeverityLevel.ERROR)
public class ForOverrideChecker
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.MethodTreeMatcher {
    private static final String FOR_OVERRIDE = "com.google.errorprone.annotations.ForOverride";
    private static final String MESSAGE_BASE = "Method annotated @ForOverride ";

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        Symbol.MethodSymbol currentMethodSymbol;
        MethodTree currentMethod;
        Symbol.MethodSymbol method = ASTHelpers.getSymbol((MethodInvocationTree)tree);
        if (method == null) {
            return Description.NO_MATCH;
        }
        Type currentClass = this.getOutermostClass(state);
        if (method.isStatic() || method.isConstructor() || currentClass == null) {
            return Description.NO_MATCH;
        }
        if (ForOverrideChecker.isSuperCall(currentClass, tree, state) && (currentMethod = ForOverrideChecker.findDirectMethod(state.getPath())) != null && currentMethod.getName().equals(method.name) && (currentMethodSymbol = ASTHelpers.getSymbol((MethodTree)currentMethod)).overrides(method, (Symbol.TypeSymbol)method.owner, state.getTypes(), true)) {
            return Description.NO_MATCH;
        }
        List<Symbol.MethodSymbol> overriddenMethods = this.getOverriddenMethods(state, method);
        for (Symbol symbol : overriddenMethods) {
            TypeMirror declaringClass = symbol.outermostClass().asType();
            if (((Type)declaringClass).equals(currentClass)) continue;
            String customMessage = "Method annotated @ForOverride must not be invoked directly (except by the declaring class, " + declaringClass + ")";
            return this.buildDescription(tree).setMessage(customMessage).build();
        }
        return Description.NO_MATCH;
    }

    public Description matchMethod(MethodTree tree, VisitorState state) {
        List<Symbol.MethodSymbol> overriddenMethods;
        Symbol.MethodSymbol method = ASTHelpers.getSymbol((MethodTree)tree);
        if (method.isStatic() || method.isConstructor()) {
            return Description.NO_MATCH;
        }
        if ((method.getModifiers().contains((Object)Modifier.PUBLIC) || method.getModifiers().contains((Object)Modifier.PRIVATE)) && !(overriddenMethods = this.getOverriddenMethods(state, method)).isEmpty()) {
            String customMessage = "Method annotated @ForOverride must have protected or package-private visibility";
            return this.buildDescription(tree).setMessage(customMessage).build();
        }
        return Description.NO_MATCH;
    }

    private static MethodTree findDirectMethod(TreePath path) {
        while ((path = path.getParentPath()) != null) {
            Tree leaf = path.getLeaf();
            if (leaf instanceof MethodTree) {
                return (MethodTree)leaf;
            }
            if (!(leaf instanceof ClassTree)) continue;
            return null;
        }
        return null;
    }

    private static boolean isSuperCall(Type type, MethodInvocationTree tree, VisitorState state) {
        if (tree.getMethodSelect().getKind() == Tree.Kind.MEMBER_SELECT) {
            MemberSelectTree select = (MemberSelectTree)tree.getMethodSelect();
            if (select.getExpression().getKind() == Tree.Kind.IDENTIFIER) {
                IdentifierTree ident = (IdentifierTree)select.getExpression();
                return ident.getName().contentEquals("super");
            }
            if (select.getExpression().getKind() == Tree.Kind.MEMBER_SELECT) {
                MemberSelectTree subSelect = (MemberSelectTree)select.getExpression();
                return subSelect.getIdentifier().contentEquals("super") && ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)subSelect.getExpression()), (Type)type, (VisitorState)state);
            }
        }
        return false;
    }

    private List<Symbol.MethodSymbol> getOverriddenMethods(VisitorState state, Symbol.MethodSymbol method) {
        if (method.isStatic()) {
            throw new IllegalArgumentException("getOverriddenMethods may not be called on a static method");
        }
        LinkedList<Symbol.MethodSymbol> list = new LinkedList<Symbol.MethodSymbol>();
        list.add(method);
        Type currType = state.getTypes().supertype(method.owner.type);
        while (currType != null && !currType.equals(state.getSymtab().objectType) && !currType.equals(Type.noType)) {
            Symbol sym = currType.tsym.members().findFirst(method.name);
            if (sym instanceof Symbol.MethodSymbol) {
                list.add((Symbol.MethodSymbol)sym);
            }
            currType = state.getTypes().supertype(currType);
        }
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Symbol.MethodSymbol member = (Symbol.MethodSymbol)iter.next();
            if (this.hasAnnotation(FOR_OVERRIDE, member) && method.overrides(member, (Symbol.TypeSymbol)member.owner, state.getTypes(), true)) continue;
            iter.remove();
        }
        return list;
    }

    private Type getOutermostClass(VisitorState state) {
        Type type = null;
        for (TreePath path = state.getPath(); path != null; path = path.getParentPath()) {
            if (path.getLeaf().getKind() != Tree.Kind.CLASS && path.getLeaf().getKind() != Tree.Kind.INTERFACE && path.getLeaf().getKind() != Tree.Kind.ENUM) continue;
            type = ASTHelpers.getSymbol((Tree)path.getLeaf()).type;
        }
        return type;
    }

    private boolean hasAnnotation(String annotation, Symbol member) {
        for (Attribute.Compound attribute : member.getAnnotationMirrors()) {
            if (!annotation.equals(attribute.type.toString())) continue;
            return true;
        }
        return false;
    }
}

