(function() {
  var CompositeDisposable, FindParentDir, Grim, TextEditor, TextEditorElement, TextMateLanguageMode, TreeSitterLanguageMode, _, addCustomMatchers, clipboard, emitObject, ensureNoDeprecatedFunctionCalls, ensureNoDeprecatedStylesheets, fixturePackagesPath, fs, grimDeprecationsSnapshot, jasmineStyle, packageMetadata, path, pathwatcher, specDirectory, specPackageName, specPackagePath, specProjectPath, stylesDeprecationsSnapshot, testPaths, warnIfLeakingPathSubscriptions,
    slice = [].slice;

  require('jasmine-json');

  require('../src/window');

  require('../vendor/jasmine-jquery');

  path = require('path');

  _ = require('underscore-plus');

  fs = require('fs-plus');

  Grim = require('grim');

  pathwatcher = require('pathwatcher');

  FindParentDir = require('find-parent-dir');

  CompositeDisposable = require('event-kit').CompositeDisposable;

  TextEditor = require('../src/text-editor');

  TextEditorElement = require('../src/text-editor-element');

  TextMateLanguageMode = require('../src/text-mate-language-mode');

  TreeSitterLanguageMode = require('../src/tree-sitter-language-mode');

  clipboard = require('electron').clipboard;

  jasmineStyle = document.createElement('style');

  jasmineStyle.textContent = atom.themes.loadStylesheet(atom.themes.resolveStylesheet('../static/jasmine'));

  document.head.appendChild(jasmineStyle);

  fixturePackagesPath = path.resolve(__dirname, './fixtures/packages');

  atom.packages.packageDirPaths.unshift(fixturePackagesPath);

  document.querySelector('html').style.overflow = 'auto';

  document.body.style.overflow = 'auto';

  Set.prototype.jasmineToString = function() {
    var first, result;
    result = "Set {";
    first = true;
    this.forEach(function(element) {
      if (!first) {
        result += ", ";
      }
      return result += element.toString();
    });
    first = false;
    return result + "}";
  };

  Set.prototype.isEqual = function(other) {
    var next, values;
    if (other instanceof Set) {
      if (this.size !== other.size) {
        return false;
      }
      values = this.values();
      while (!(next = values.next()).done) {
        if (!other.has(next.value)) {
          return false;
        }
      }
      return true;
    } else {
      return false;
    }
  };

  jasmine.getEnv().addEqualityTester(function(a, b) {
    if ((a != null ? a.jasmineMatches : void 0) != null) {
      return a.jasmineMatches(b);
    }
    if ((b != null ? b.jasmineMatches : void 0) != null) {
      return b.jasmineMatches(a);
    }
    return _.isEqual(a, b);
  });

  if (process.env.CI) {
    jasmine.getEnv().defaultTimeoutInterval = 60000;
  } else {
    jasmine.getEnv().defaultTimeoutInterval = 5000;
  }

  testPaths = atom.getLoadSettings().testPaths;

  if (specPackagePath = FindParentDir.sync(testPaths[0], 'package.json')) {
    packageMetadata = require(path.join(specPackagePath, 'package.json'));
    specPackageName = packageMetadata.name;
  }

  if (specDirectory = FindParentDir.sync(testPaths[0], 'fixtures')) {
    specProjectPath = path.join(specDirectory, 'fixtures');
  } else {
    specProjectPath = require('os').tmpdir();
  }

  beforeEach(function() {
    var clipboardContent, resolvePackagePath, spy;
    spyOn(Object.getPrototypeOf(atom.history), 'saveState').andReturn(Promise.resolve());
    atom.project.setPaths([specProjectPath]);
    window.resetTimeouts();
    spyOn(_._, "now").andCallFake(function() {
      return window.now;
    });
    spyOn(Date, 'now').andCallFake(function() {
      return window.now;
    });
    spyOn(window, "setTimeout").andCallFake(window.fakeSetTimeout);
    spyOn(window, "clearTimeout").andCallFake(window.fakeClearTimeout);
    spy = spyOn(atom.packages, 'resolvePackagePath').andCallFake(function(packageName) {
      if (specPackageName && packageName === specPackageName) {
        return resolvePackagePath(specPackagePath);
      } else {
        return resolvePackagePath(packageName);
      }
    });
    resolvePackagePath = _.bind(spy.originalValue, atom.packages);
    spyOn(atom.menu, 'sendToBrowserProcess');
    atom.config.set("core.destroyEmptyPanes", false);
    atom.config.set("editor.fontFamily", "Courier");
    atom.config.set("editor.fontSize", 16);
    atom.config.set("editor.autoIndent", false);
    atom.config.set("core.disabledPackages", ["package-that-throws-an-exception", "package-with-broken-package-json", "package-with-broken-keymap"]);
    advanceClock(1000);
    window.setTimeout.reset();
    TextEditorElement.prototype.setUpdatedSynchronously(true);
    spyOn(pathwatcher.File.prototype, "detectResurrectionAfterDelay").andCallFake(function() {
      return this.detectResurrection();
    });
    spyOn(TextEditor.prototype, "shouldPromptToSave").andReturn(false);
    TextMateLanguageMode.prototype.chunkSize = 2e308;
    TreeSitterLanguageMode.prototype.syncTimeoutMicros = 2e308;
    spyOn(TextMateLanguageMode.prototype, "tokenizeInBackground").andCallFake(function() {
      return this.tokenizeNextChunk();
    });
    spyOn(TextEditor.prototype, "onDidTokenize").andCallFake(function(callback) {
      return new CompositeDisposable(this.emitter.on("did-tokenize", callback), this.onDidChangeGrammar((function(_this) {
        return function() {
          var languageMode, ref;
          languageMode = _this.buffer.getLanguageMode();
          if ((ref = languageMode.tokenizeInBackground) != null ? ref.originalValue : void 0) {
            return callback();
          }
        };
      })(this)));
    });
    clipboardContent = 'initial clipboard content';
    spyOn(clipboard, 'writeText').andCallFake(function(text) {
      return clipboardContent = text;
    });
    spyOn(clipboard, 'readText').andCallFake(function() {
      return clipboardContent;
    });
    return addCustomMatchers(this);
  });

  afterEach(function() {
    ensureNoDeprecatedFunctionCalls();
    ensureNoDeprecatedStylesheets();
    waitsForPromise(function() {
      return atom.reset();
    });
    return runs(function() {
      if (!window.debugContent) {
        document.getElementById('jasmine-content').innerHTML = '';
      }
      warnIfLeakingPathSubscriptions();
      return waits(0);
    });
  });

  warnIfLeakingPathSubscriptions = function() {
    var watchedPaths;
    watchedPaths = pathwatcher.getWatchedPaths();
    if (watchedPaths.length > 0) {
      console.error("WARNING: Leaking subscriptions for paths: " + watchedPaths.join(", "));
    }
    return pathwatcher.closeAllWatchers();
  };

  ensureNoDeprecatedFunctionCalls = function() {
    var deprecations, error, originalPrepareStackTrace;
    deprecations = _.clone(Grim.getDeprecations());
    Grim.clearDeprecations();
    if (deprecations.length > 0) {
      originalPrepareStackTrace = Error.prepareStackTrace;
      Error.prepareStackTrace = function(error, stack) {
        var deprecation, functionName, i, j, k, len, len1, len2, location, output, ref, ref1;
        output = [];
        for (i = 0, len = deprecations.length; i < len; i++) {
          deprecation = deprecations[i];
          output.push(deprecation.originName + " is deprecated. " + deprecation.message);
          output.push(_.multiplyString("-", output[output.length - 1].length));
          ref = deprecation.getStacks();
          for (j = 0, len1 = ref.length; j < len1; j++) {
            stack = ref[j];
            for (k = 0, len2 = stack.length; k < len2; k++) {
              ref1 = stack[k], functionName = ref1.functionName, location = ref1.location;
              output.push(functionName + " -- " + location);
            }
          }
          output.push("");
        }
        return output.join("\n");
      };
      error = new Error("Deprecated function(s) " + (deprecations.map(function(arg) {
        var originName;
        originName = arg.originName;
        return originName;
      }).join(', ')) + ") were called.");
      error.stack;
      Error.prepareStackTrace = originalPrepareStackTrace;
      throw error;
    }
  };

  ensureNoDeprecatedStylesheets = function() {
    var deprecation, deprecations, results, sourcePath, title;
    deprecations = _.clone(atom.styles.getDeprecations());
    atom.styles.clearDeprecations();
    results = [];
    for (sourcePath in deprecations) {
      deprecation = deprecations[sourcePath];
      title = sourcePath !== 'undefined' ? "Deprecated stylesheet at '" + sourcePath + "':" : "Deprecated stylesheet:";
      throw new Error(title + "\n" + deprecation.message);
    }
    return results;
  };

  emitObject = jasmine.StringPrettyPrinter.prototype.emitObject;

  jasmine.StringPrettyPrinter.prototype.emitObject = function(obj) {
    if (obj.inspect) {
      return this.append(obj.inspect());
    } else {
      return emitObject.call(this, obj);
    }
  };

  jasmine.unspy = function(object, methodName) {
    if (!object[methodName].hasOwnProperty('originalValue')) {
      throw new Error("Not a spy");
    }
    return object[methodName] = object[methodName].originalValue;
  };

  jasmine.attachToDOM = function(element) {
    var jasmineContent;
    jasmineContent = document.querySelector('#jasmine-content');
    if (!jasmineContent.contains(element)) {
      return jasmineContent.appendChild(element);
    }
  };

  grimDeprecationsSnapshot = null;

  stylesDeprecationsSnapshot = null;

  jasmine.snapshotDeprecations = function() {
    grimDeprecationsSnapshot = _.clone(Grim.deprecations);
    return stylesDeprecationsSnapshot = _.clone(atom.styles.deprecationsBySourcePath);
  };

  jasmine.restoreDeprecationsSnapshot = function() {
    Grim.deprecations = grimDeprecationsSnapshot;
    return atom.styles.deprecationsBySourcePath = stylesDeprecationsSnapshot;
  };

  jasmine.useRealClock = function() {
    jasmine.unspy(window, 'setTimeout');
    jasmine.unspy(window, 'clearTimeout');
    jasmine.unspy(_._, 'now');
    return jasmine.unspy(Date, 'now');
  };

  jasmine.useMockClock = function() {
    spyOn(window, 'setInterval').andCallFake(fakeSetInterval);
    return spyOn(window, 'clearInterval').andCallFake(fakeClearInterval);
  };

  addCustomMatchers = function(spec) {
    return spec.addMatchers({
      toBeInstanceOf: function(expected) {
        var beOrNotBe;
        beOrNotBe = this.isNot ? "not be" : "be";
        this.message = (function(_this) {
          return function() {
            return "Expected " + (jasmine.pp(_this.actual)) + " to " + beOrNotBe + " instance of " + expected.name + " class";
          };
        })(this);
        return this.actual instanceof expected;
      },
      toHaveLength: function(expected) {
        var haveOrNotHave;
        if (this.actual == null) {
          this.message = (function(_this) {
            return function() {
              return "Expected object " + _this.actual + " has no length method";
            };
          })(this);
          return false;
        } else {
          haveOrNotHave = this.isNot ? "not have" : "have";
          this.message = (function(_this) {
            return function() {
              return "Expected object with length " + _this.actual.length + " to " + haveOrNotHave + " length " + expected;
            };
          })(this);
          return this.actual.length === expected;
        }
      },
      toExistOnDisk: function(expected) {
        var toOrNotTo;
        toOrNotTo = this.isNot && "not to" || "to";
        this.message = function() {
          return "Expected path '" + this.actual + "' " + toOrNotTo + " exist.";
        };
        return fs.existsSync(this.actual);
      },
      toHaveFocus: function() {
        var element, toOrNotTo;
        toOrNotTo = this.isNot && "not to" || "to";
        if (!document.hasFocus()) {
          console.error("Specs will fail because the Dev Tools have focus. To fix this close the Dev Tools or click the spec runner.");
        }
        this.message = function() {
          return "Expected element '" + this.actual + "' or its descendants " + toOrNotTo + " have focus.";
        };
        element = this.actual;
        if (element.jquery) {
          element = element.get(0);
        }
        return element === document.activeElement || element.contains(document.activeElement);
      },
      toShow: function() {
        var element, ref, toOrNotTo;
        toOrNotTo = this.isNot && "not to" || "to";
        element = this.actual;
        if (element.jquery) {
          element = element.get(0);
        }
        this.message = function() {
          return "Expected element '" + element + "' or its descendants " + toOrNotTo + " show.";
        };
        return (ref = element.style.display) === 'block' || ref === 'inline-block' || ref === 'static' || ref === 'fixed';
      },
      toEqualPath: function(expected) {
        var actualPath, expectedPath;
        actualPath = path.normalize(this.actual);
        expectedPath = path.normalize(expected);
        this.message = function() {
          return "Expected path '" + actualPath + "' to be equal to '" + expectedPath + "'.";
        };
        return actualPath === expectedPath;
      }
    });
  };

  window.waitsForPromise = function() {
    var args, fn, label, ref, shouldReject, timeout;
    args = 1 <= arguments.length ? slice.call(arguments, 0) : [];
    label = null;
    if (args.length > 1) {
      ref = args[0], shouldReject = ref.shouldReject, timeout = ref.timeout, label = ref.label;
    } else {
      shouldReject = false;
    }
    if (label == null) {
      label = 'promise to be resolved or rejected';
    }
    fn = _.last(args);
    return window.waitsFor(label, timeout, function(moveOn) {
      var promise;
      promise = fn();
      if (shouldReject) {
        promise["catch"].call(promise, moveOn);
        return promise.then(function() {
          jasmine.getEnv().currentSpec.fail("Expected promise to be rejected, but it was resolved");
          return moveOn();
        });
      } else {
        promise.then(moveOn);
        return promise["catch"].call(promise, function(error) {
          jasmine.getEnv().currentSpec.fail("Expected promise to be resolved, but it was rejected with: " + (error != null ? error.message : void 0) + " " + (jasmine.pp(error)));
          return moveOn();
        });
      }
    });
  };

  window.resetTimeouts = function() {
    window.now = 0;
    window.timeoutCount = 0;
    window.intervalCount = 0;
    window.timeouts = [];
    return window.intervalTimeouts = {};
  };

  window.fakeSetTimeout = function(callback, ms) {
    var id;
    if (ms == null) {
      ms = 0;
    }
    id = ++window.timeoutCount;
    window.timeouts.push([id, window.now + ms, callback]);
    return id;
  };

  window.fakeClearTimeout = function(idToClear) {
    return window.timeouts = window.timeouts.filter(function(arg) {
      var id;
      id = arg[0];
      return id !== idToClear;
    });
  };

  window.fakeSetInterval = function(callback, ms) {
    var action, id;
    id = ++window.intervalCount;
    action = function() {
      callback();
      return window.intervalTimeouts[id] = window.fakeSetTimeout(action, ms);
    };
    window.intervalTimeouts[id] = window.fakeSetTimeout(action, ms);
    return id;
  };

  window.fakeClearInterval = function(idToClear) {
    return window.fakeClearTimeout(this.intervalTimeouts[idToClear]);
  };

  window.advanceClock = function(delta) {
    var callback, callbacks, i, len, results;
    if (delta == null) {
      delta = 1;
    }
    window.now += delta;
    callbacks = [];
    window.timeouts = window.timeouts.filter(function(arg) {
      var callback, id, strikeTime;
      id = arg[0], strikeTime = arg[1], callback = arg[2];
      if (strikeTime <= window.now) {
        callbacks.push(callback);
        return false;
      } else {
        return true;
      }
    });
    results = [];
    for (i = 0, len = callbacks.length; i < len; i++) {
      callback = callbacks[i];
      results.push(callback());
    }
    return results;
  };

  exports.mockLocalStorage = function() {
    var items;
    items = {};
    spyOn(global.localStorage, 'setItem').andCallFake(function(key, item) {
      items[key] = item.toString();
      return void 0;
    });
    spyOn(global.localStorage, 'getItem').andCallFake(function(key) {
      var ref;
      return (ref = items[key]) != null ? ref : null;
    });
    return spyOn(global.localStorage, 'removeItem').andCallFake(function(key) {
      delete items[key];
      return void 0;
    });
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
