"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _reactRelay = require("react-relay");

var _relayRuntime = require("relay-runtime");

var _moment = _interopRequireDefault(require("moment"));

var _helpers = require("../helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/* istanbul ignore file */
const mutation = function () {
  const node = require("./__generated__/addPrReviewCommentMutation.graphql");

  if (node.hash && node.hash !== "0485900371928de8c6b843560dfe441c") {
    console.error("The definition of 'addPrReviewCommentMutation' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
  }

  return require("./__generated__/addPrReviewCommentMutation.graphql");
};

let placeholderID = 0;

var _default = (environment, {
  body,
  inReplyTo,
  reviewID,
  threadID,
  viewerID,
  path,
  position
}) => {
  const variables = {
    input: {
      body,
      inReplyTo,
      pullRequestReviewId: reviewID
    }
  };
  const configs = [{
    type: 'RANGE_ADD',
    parentID: threadID,
    connectionInfo: [{
      key: 'ReviewCommentsAccumulator_comments',
      rangeBehavior: 'append'
    }],
    edgeName: 'commentEdge'
  }];

  function optimisticUpdater(store) {
    const reviewThread = store.get(threadID);

    if (!reviewThread) {
      return;
    }

    const id = `add-pr-review-comment:comment:${placeholderID++}`;
    const comment = store.create(id, 'PullRequestReviewComment');
    comment.setValue(id, 'id');
    comment.setValue(body, 'body');
    comment.setValue((0, _helpers.renderMarkdown)(body), 'bodyHTML');
    comment.setValue(false, 'isMinimized');
    comment.setValue(false, 'viewerCanMinimize');
    comment.setValue(false, 'viewerCanReact');
    comment.setValue(false, 'viewerCanUpdate');
    comment.setValue((0, _moment["default"])().toISOString(), 'createdAt');
    comment.setValue(null, 'lastEditedAt');
    comment.setValue('NONE', 'authorAssociation');
    comment.setValue('https://github.com', 'url');
    comment.setValue(path, 'path');
    comment.setValue(position, 'position');
    comment.setLinkedRecords([], 'reactionGroups');
    let author;

    if (viewerID) {
      author = store.get(viewerID);
    } else {
      author = store.create(`add-pr-review-comment:author:${placeholderID++}`, 'User');
      author.setValue('...', 'login');
      author.setValue('atom://github/img/avatar.svg', 'avatarUrl');
    }

    comment.setLinkedRecord(author, 'author');

    const comments = _relayRuntime.ConnectionHandler.getConnection(reviewThread, 'ReviewCommentsAccumulator_comments');

    const edge = _relayRuntime.ConnectionHandler.createEdge(store, comments, comment, 'PullRequestReviewCommentEdge');

    _relayRuntime.ConnectionHandler.insertEdgeAfter(comments, edge);
  }

  return new Promise((resolve, reject) => {
    (0, _reactRelay.commitMutation)(environment, {
      mutation,
      variables,
      configs,
      optimisticUpdater,
      onCompleted: resolve,
      onError: reject
    });
  });
};

exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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