"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const path = require("path");
const require_project_module_1 = require("../utilities/require-project-module");
function readTsconfig(tsconfigPath) {
    const projectTs = require_project_module_1.requireProjectModule(path.dirname(tsconfigPath), 'typescript');
    const configResult = projectTs.readConfigFile(tsconfigPath, projectTs.sys.readFile);
    const tsConfig = projectTs.parseJsonConfigFileContent(configResult.config, projectTs.sys, path.dirname(tsconfigPath), undefined, tsconfigPath);
    return tsConfig;
}
exports.readTsconfig = readTsconfig;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicmVhZC10c2NvbmZpZy5qcyIsInNvdXJjZVJvb3QiOiIuLyIsInNvdXJjZXMiOlsicGFja2FnZXMvYW5ndWxhcl9kZXZraXQvYnVpbGRfYW5ndWxhci9zcmMvYW5ndWxhci1jbGktZmlsZXMvdXRpbGl0aWVzL3JlYWQtdHNjb25maWcudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFVQSw2QkFBNkI7QUFDN0IsZ0ZBQTJFO0FBRTNFLFNBQWdCLFlBQVksQ0FBQyxZQUFvQjtJQUMvQyxNQUFNLFNBQVMsR0FBRyw2Q0FBb0IsQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLFlBQVksQ0FBQyxFQUFFLFlBQVksQ0FBYyxDQUFDO0lBQzlGLE1BQU0sWUFBWSxHQUFHLFNBQVMsQ0FBQyxjQUFjLENBQUMsWUFBWSxFQUFFLFNBQVMsQ0FBQyxHQUFHLENBQUMsUUFBUSxDQUFDLENBQUM7SUFDcEYsTUFBTSxRQUFRLEdBQUcsU0FBUyxDQUFDLDBCQUEwQixDQUFDLFlBQVksQ0FBQyxNQUFNLEVBQUUsU0FBUyxDQUFDLEdBQUcsRUFDdEYsSUFBSSxDQUFDLE9BQU8sQ0FBQyxZQUFZLENBQUMsRUFBRSxTQUFTLEVBQUUsWUFBWSxDQUFDLENBQUM7SUFDdkQsT0FBTyxRQUFRLENBQUM7QUFDbEIsQ0FBQztBQU5ELG9DQU1DIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBAbGljZW5zZVxuICogQ29weXJpZ2h0IEdvb2dsZSBJbmMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG4gKlxuICogVXNlIG9mIHRoaXMgc291cmNlIGNvZGUgaXMgZ292ZXJuZWQgYnkgYW4gTUlULXN0eWxlIGxpY2Vuc2UgdGhhdCBjYW4gYmVcbiAqIGZvdW5kIGluIHRoZSBMSUNFTlNFIGZpbGUgYXQgaHR0cHM6Ly9hbmd1bGFyLmlvL2xpY2Vuc2VcbiAqL1xuLy8gdHNsaW50OmRpc2FibGVcbi8vIFRPRE86IGNsZWFudXAgdGhpcyBmaWxlLCBpdCdzIGNvcGllZCBhcyBpcyBmcm9tIEFuZ3VsYXIgQ0xJLlxuaW1wb3J0ICogYXMgdHMgZnJvbSAndHlwZXNjcmlwdCc7XG5pbXBvcnQgKiBhcyBwYXRoIGZyb20gJ3BhdGgnO1xuaW1wb3J0IHsgcmVxdWlyZVByb2plY3RNb2R1bGUgfSBmcm9tICcuLi91dGlsaXRpZXMvcmVxdWlyZS1wcm9qZWN0LW1vZHVsZSc7XG5cbmV4cG9ydCBmdW5jdGlvbiByZWFkVHNjb25maWcodHNjb25maWdQYXRoOiBzdHJpbmcpIHtcbiAgY29uc3QgcHJvamVjdFRzID0gcmVxdWlyZVByb2plY3RNb2R1bGUocGF0aC5kaXJuYW1lKHRzY29uZmlnUGF0aCksICd0eXBlc2NyaXB0JykgYXMgdHlwZW9mIHRzO1xuICBjb25zdCBjb25maWdSZXN1bHQgPSBwcm9qZWN0VHMucmVhZENvbmZpZ0ZpbGUodHNjb25maWdQYXRoLCBwcm9qZWN0VHMuc3lzLnJlYWRGaWxlKTtcbiAgY29uc3QgdHNDb25maWcgPSBwcm9qZWN0VHMucGFyc2VKc29uQ29uZmlnRmlsZUNvbnRlbnQoY29uZmlnUmVzdWx0LmNvbmZpZywgcHJvamVjdFRzLnN5cyxcbiAgICBwYXRoLmRpcm5hbWUodHNjb25maWdQYXRoKSwgdW5kZWZpbmVkLCB0c2NvbmZpZ1BhdGgpO1xuICByZXR1cm4gdHNDb25maWc7XG59XG4iXX0=