/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.matchers.method;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.VisitorState;
import com.google.errorprone.matchers.method.AbstractChainedMatcher;
import com.google.errorprone.matchers.method.AbstractSimpleMatcher;
import com.google.errorprone.matchers.method.MatchState;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.matchers.method.ParameterMatcherImpl;
import com.google.errorprone.suppliers.Suppliers;
import com.sun.source.tree.ExpressionTree;
import com.sun.tools.javac.util.Name;
import java.util.Arrays;
import java.util.regex.Pattern;

public abstract class MethodNameMatcherImpl
extends AbstractChainedMatcher<MatchState, MatchState>
implements MethodMatchers.MethodNameMatcher {
    MethodNameMatcherImpl(AbstractSimpleMatcher<MatchState> baseMatcher) {
        super(baseMatcher);
    }

    @Override
    public MethodMatchers.ParameterMatcher withParameters(String ... parameters) {
        return this.withParameters(Arrays.asList(parameters));
    }

    @Override
    public MethodMatchers.ParameterMatcher withParameters(Iterable<String> parameters) {
        return new ParameterMatcherImpl(this, Suppliers.fromStrings(parameters));
    }

    static class AnyOf
    extends MethodNameMatcherImpl {
        private final ImmutableList<String> names;

        AnyOf(AbstractSimpleMatcher<MatchState> baseMatcher, Iterable<String> names) {
            super(baseMatcher);
            this.names = ImmutableList.copyOf(names);
        }

        @Override
        protected Optional<MatchState> matchResult(ExpressionTree item, MatchState method, VisitorState state) {
            javax.lang.model.element.Name symbolName = method.sym().getSimpleName();
            return this.names.stream().anyMatch(((Name)symbolName)::contentEquals) ? Optional.of((Object)method) : Optional.absent();
        }
    }

    static class Regex
    extends MethodNameMatcherImpl {
        private final Pattern regex;

        Regex(AbstractSimpleMatcher<MatchState> baseMatcher, Pattern regex) {
            super(baseMatcher);
            this.regex = regex;
        }

        @Override
        protected Optional<MatchState> matchResult(ExpressionTree item, MatchState method, VisitorState state) {
            if (!this.regex.matcher(((Name)method.sym().getSimpleName()).toString()).matches()) {
                return Optional.absent();
            }
            return Optional.of((Object)method);
        }
    }

    static class Any
    extends MethodNameMatcherImpl {
        Any(AbstractSimpleMatcher<MatchState> baseMatcher) {
            super(baseMatcher);
        }

        @Override
        protected Optional<MatchState> matchResult(ExpressionTree item, MatchState method, VisitorState state) {
            return Optional.of((Object)method);
        }
    }

    static class Exact
    extends MethodNameMatcherImpl {
        private final String name;

        Exact(AbstractSimpleMatcher<MatchState> baseMatcher, String name) {
            super(baseMatcher);
            this.name = name;
            Preconditions.checkArgument((!name.contains("(") && !name.contains(")") ? 1 : 0) != 0, (String)"method name (%s) cannot contain parentheses. e.g., use \"foo\" instead of \"foo()\"", (Object)name);
        }

        @Override
        protected Optional<MatchState> matchResult(ExpressionTree item, MatchState method, VisitorState state) {
            if (!((Name)method.sym().getSimpleName()).contentEquals(this.name)) {
                return Optional.absent();
            }
            return Optional.of((Object)method);
        }
    }
}

