# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class SynchronizedRenderers(Object):
    """
    SynchronizedRenderers - synchronizes renderers across processes.
    
    Superclass: Object
    
    SynchronizedRenderers is used to synchronize renderers
    (vtk_renderer and subclasses) across processes for parallel rendering.
    It's designed to be used in conjunction with
    SynchronizedRenderWindows to synchronize the render windows among
    those processes. This class handles synchronization of certain render
    parameters among the renderers such as viewport, camera parameters.
    It doesn't support compositing of rendered images across processes on
    its own. You typically either subclass to implement a compositing
    algorithm or use a renderer capable of compositing eg. ice_t based
    renderer.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkSynchronizedRenderers, obj, update, **traits)
    
    automatic_event_handling = tvtk_base.true_bool_trait(desc=\
        """
        When multiple groups of processes are synchronized together using
        different controllers, one needs to specify the order in which
        the various synchronizers execute. In such cases one starts with
        the outer most SynchronizedRenderers, sets the dependent one
        as a capture_delegate on it and the turn off
        automatic_event_handling on the delegate.
        """
    )

    def _automatic_event_handling_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAutomaticEventHandling,
                        self.automatic_event_handling_)

    parallel_rendering = tvtk_base.true_bool_trait(desc=\
        """
        Enable/Disable parallel rendering. Unless Parallel rendering is
        on, the cameras won't be synchronized across processes.
        """
    )

    def _parallel_rendering_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetParallelRendering,
                        self.parallel_rendering_)

    write_back_images = tvtk_base.true_bool_trait(desc=\
        """
        If on (default), the rendered images are pasted back on to the
        screen. You should turn this flag off on processes that are not
        meant to be visible to the user.
        """
    )

    def _write_back_images_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetWriteBackImages,
                        self.write_back_images_)

    def _get_capture_delegate(self):
        return wrap_vtk(self._vtk_obj.GetCaptureDelegate())
    def _set_capture_delegate(self, arg):
        old_val = self._get_capture_delegate()
        self._wrap_call(self._vtk_obj.SetCaptureDelegate,
                        deref_vtk(arg))
        self.trait_property_changed('capture_delegate', old_val, arg)
    capture_delegate = traits.Property(_get_capture_delegate, _set_capture_delegate, desc=\
        """
        When set, this->_capture_rendered_image() does not capture image
        from the screen instead passes the call to the delegate.
        """
    )

    image_reduction_factor = traits.Trait(1, traits.Range(1, 50, enter_set=True, auto_set=False), desc=\
        """
        Get/Set the image reduction factor.
        """
    )

    def _image_reduction_factor_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetImageReductionFactor,
                        self.image_reduction_factor)

    def _get_parallel_controller(self):
        return wrap_vtk(self._vtk_obj.GetParallelController())
    def _set_parallel_controller(self, arg):
        old_val = self._get_parallel_controller()
        self._wrap_call(self._vtk_obj.SetParallelController,
                        deref_vtk(arg))
        self.trait_property_changed('parallel_controller', old_val, arg)
    parallel_controller = traits.Property(_get_parallel_controller, _set_parallel_controller, desc=\
        """
        Set the parallel message communicator. This is used to
        communicate among processes.
        """
    )

    def _get_renderer(self):
        return wrap_vtk(self._vtk_obj.GetRenderer())
    def _set_renderer(self, arg):
        old_val = self._get_renderer()
        self._wrap_call(self._vtk_obj.SetRenderer,
                        deref_vtk(arg))
        self.trait_property_changed('renderer', old_val, arg)
    renderer = traits.Property(_get_renderer, _set_renderer, desc=\
        """
        Set the renderer to be synchronized by this instance. A
        SynchronizedRenderers instance can be used to synchronize
        exactly 1 renderer on each processes. You can create multiple
        instances on SynchronizedRenderers to synchronize multiple
        renderers.
        """
    )

    root_process_id = traits.Int(0, enter_set=True, auto_set=False, desc=\
        """
        Get/Set the root-process id. This is required when the
        parallel_controller is a SocketController. Set to 0 by default
        (which will not work when using a SocketController but will
        work for MPIController).
        """
    )

    def _root_process_id_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRootProcessId,
                        self.root_process_id)

    def collective_expand_for_visible_prop_bounds(self, *args):
        """
        V.collective_expand_for_visible_prop_bounds([float, float, float,
            float, float, float])
        C++: void CollectiveExpandForVisiblePropBounds(double bounds[6])
        Computes visible prob bounds. This must be called on all
        processes at the same time. The collective result is made
        available on all processes once this method returns. Note that
        this method requires that bounds is initialized to some value.
        This expands the bounds to include the prop bounds.
        """
        ret = self._wrap_call(self._vtk_obj.CollectiveExpandForVisiblePropBounds, *args)
        return ret

    _updateable_traits_ = \
    (('automatic_event_handling', 'GetAutomaticEventHandling'),
    ('parallel_rendering', 'GetParallelRendering'), ('write_back_images',
    'GetWriteBackImages'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('image_reduction_factor', 'GetImageReductionFactor'),
    ('root_process_id', 'GetRootProcessId'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['automatic_event_handling', 'debug', 'global_warning_display',
    'parallel_rendering', 'write_back_images', 'image_reduction_factor',
    'root_process_id'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(SynchronizedRenderers, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit SynchronizedRenderers properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['automatic_event_handling', 'parallel_rendering',
            'write_back_images'], [], ['image_reduction_factor',
            'root_process_id']),
            title='Edit SynchronizedRenderers properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit SynchronizedRenderers properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

