/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.openide.loaders.AWTTask;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.FolderList;
import org.openide.loaders.FolderListListener;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.WeakListeners;

public abstract class FolderInstance
extends Task
implements InstanceCookie {
    static final RequestProcessor PROCESSOR = new RequestProcessor("Folder Instance Processor");
    private static final ThreadLocal<Object> CURRENT = new ThreadLocal();
    private static final ThreadLocal<Object> LAST_CURRENT = new ThreadLocal();
    protected DataFolder folder;
    private DataObject.Container container;
    private HashMap<FileObject, HoldInstance> map = new HashMap(17);
    private Task[] waitFor;
    private Object object = CURRENT;
    private Listener listener;
    private Logger err;
    private Task recognizingTask;
    private Task creationTask;
    private volatile int creationSequence;
    private boolean precreateInstances;

    public FolderInstance(DataFolder dataFolder) {
        this((DataObject.Container)dataFolder);
    }

    public FolderInstance(DataObject.Container container) {
        this(container, null);
    }

    private FolderInstance(DataObject.Container container, String string) {
        if (container instanceof DataFolder) {
            this.folder = (DataFolder)container;
            if (string == null) {
                string = this.folder.getPrimaryFile().getPath().replace('/', '.');
            }
            container = FolderList.find(this.folder.getPrimaryFile(), true);
        }
        this.listener = new Listener();
        string = string == null ? "org.openide.loaders.FolderInstance" : "org.openide.loaders.FolderInstance." + string;
        this.err = Logger.getLogger(string);
        this.container = container;
        container.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.listener, (Object)container));
        if (this.err.isLoggable(Level.FINE)) {
            this.err.fine("new " + (Object)((Object)this));
        }
    }

    void precreateInstances() {
        this.precreateInstances = true;
    }

    public String instanceName() {
        try {
            return this.instanceClass().getName();
        }
        catch (IOException iOException) {
            return "java.lang.Object";
        }
        catch (ClassNotFoundException classNotFoundException) {
            return "java.lang.Object";
        }
    }

    public Class<?> instanceClass() throws IOException, ClassNotFoundException {
        Object object = this.object;
        if (object != null) {
            if (object instanceof IOException) {
                throw (IOException)object;
            }
            if (object instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)object;
            }
            return object.getClass();
        }
        return Object.class;
    }

    public Object instanceCreate() throws IOException, ClassNotFoundException {
        Object object = CURRENT.get();
        if (object == null || LAST_CURRENT.get() != this) {
            this.err.fine("do into waitFinished");
            this.waitFinished();
            object = this.object;
        }
        if (this.err.isLoggable(Level.FINE)) {
            this.err.fine("instanceCreate: " + object);
        }
        if (object instanceof IOException) {
            throw (IOException)object;
        }
        if (object instanceof ClassNotFoundException) {
            throw (ClassNotFoundException)object;
        }
        if (object == CURRENT) {
            throw new IOException("Cyclic reference. Somebody is trying to get value from FolderInstance (" + ((Object)((Object)this)).getClass().getName() + ") from the same thread that is processing the instance");
        }
        return object;
    }

    public final void instanceFinished() {
        this.waitFinished();
    }

    public void waitFinished() {
        block11: {
            boolean bl = this.err.isLoggable(Level.FINE);
            while (true) {
                this.err.fine("waitProcessingFinished on container");
                FolderInstance.waitProcessingFinished(this.container);
                Task task = this.checkRecognizingStarted();
                if (bl) {
                    this.err.fine("checkRecognizingStarted: " + task);
                }
                task.waitFinished();
                Task task2 = this.creationTask;
                if (bl) {
                    this.err.fine("creationTask: " + task2);
                }
                if (task2 != null) {
                    if (EventQueue.isDispatchThread()) {
                        if (!AWTTask.waitFor(task2)) {
                            continue;
                        }
                    } else {
                        task2.waitFinished();
                    }
                }
                Object[] objectArray = this.waitFor;
                if (bl) {
                    this.err.fine("toWait: " + Arrays.toString(objectArray));
                }
                if (objectArray != null) {
                    for (int i = 0; i < objectArray.length; ++i) {
                        if (bl) {
                            this.err.fine("  wait[" + i + "]: " + objectArray[i]);
                        }
                        objectArray[i].waitFinished();
                    }
                }
                if (task == this.checkRecognizingStarted()) break;
            }
            if (!bl) break block11;
            this.err.fine("breaking the wait loop");
        }
    }

    public void run() {
        this.recreate();
        this.instanceFinished();
    }

    protected InstanceCookie acceptDataObject(DataObject dataObject) {
        DataObject.Container container;
        int n = -1;
        Object object = dataObject.getCookie(InstanceCookie.class);
        try {
            object = object == null ? null : this.acceptCookie((InstanceCookie)object);
            n = 1;
        }
        catch (IOException iOException) {
            this.err.log(Level.WARNING, null, iOException);
            this.revertProblematicFile(dataObject);
            object = null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.err.log(Level.INFO, null, classNotFoundException);
            this.revertProblematicFile(dataObject);
            object = null;
        }
        if (object == null && (container = dataObject.getCookie(DataFolder.class)) != null) {
            HoldInstance holdInstance = this.map.get(((DataObject)((Object)container)).getPrimaryFile());
            if (holdInstance != null && holdInstance.cookie != null) {
                object = holdInstance;
                n = 2;
            } else {
                object = this.acceptFolder((DataFolder)container);
                n = 3;
            }
        }
        if (object == null && (container = dataObject.getCookie(DataObject.Container.class)) != null) {
            object = this.acceptContainer(container);
            n = 4;
        }
        if (this.err.isLoggable(Level.FINE)) {
            this.err.fine("acceptDataObject: " + dataObject + " cookie: " + object + " acceptType: " + n);
        }
        return object;
    }

    private void revertProblematicFile(DataObject dataObject) {
        try {
            dataObject.getPrimaryFile().revert();
        }
        catch (IOException iOException) {
            this.err.log(Level.INFO, null, iOException);
        }
    }

    protected InstanceCookie acceptCookie(InstanceCookie instanceCookie) throws IOException, ClassNotFoundException {
        return instanceCookie;
    }

    protected InstanceCookie acceptFolder(DataFolder dataFolder) {
        return this.acceptContainer(dataFolder);
    }

    protected InstanceCookie acceptContainer(DataObject.Container container) {
        return null;
    }

    protected abstract Object createInstance(InstanceCookie[] var1) throws IOException, ClassNotFoundException;

    protected Object instanceForCookie(DataObject dataObject, InstanceCookie instanceCookie) throws IOException, ClassNotFoundException {
        return instanceCookie.instanceCreate();
    }

    public synchronized void recreate() {
        this.err.fine("recreate");
        this.recognizingTask = FolderInstance.computeChildrenList(this.container, this.listener);
        if (this.err.isLoggable(Level.FINE)) {
            this.err.fine("  recognizing task is now " + this.recognizingTask);
        }
        this.notifyRunning();
    }

    final void checkRecreate() {
        if (this.isFinished()) {
            this.recreate();
        }
    }

    private final synchronized Task checkRecognizingStarted() {
        if (this.recognizingTask == null) {
            this.recreate();
        }
        return this.recognizingTask;
    }

    private static void waitProcessingFinished(DataObject.Container container) {
        if (container instanceof FolderList) {
            ((FolderList)container).waitProcessingFinished();
        }
    }

    private static Task computeChildrenList(final DataObject.Container container, final FolderListListener folderListListener) {
        if (container instanceof FolderList) {
            FolderList folderList = (FolderList)container;
            return folderList.computeChildrenList(folderListListener);
        }
        return PROCESSOR.post(new Runnable(){

            @Override
            public void run() {
                DataObject[] dataObjectArray = container.getChildren();
                ArrayList<DataObject> arrayList = new ArrayList<DataObject>(dataObjectArray.length);
                for (int i = 0; i < dataObjectArray.length; ++i) {
                    folderListListener.process(dataObjectArray[i], arrayList);
                }
                folderListListener.finished(arrayList);
            }
        });
    }

    final void processObjects(final Collection<DataObject> collection) {
        class R
        extends Task {
            HoldInstance[] all;
            Object[] instances;
            int sequence;
            Task postCreationTask;
            RequestProcessor.Task instancesTask;

            R() {
            }

            public void init() {
                this.all = FolderInstance.this.defaultProcessObjects(collection);
            }

            public void instances() {
                this.instances = new Object[this.all.length];
                for (int i = 0; i < this.all.length; ++i) {
                    try {
                        this.instances[i] = this.all[i].instanceCreate();
                        if (this.instances[i] != null) {
                            continue;
                        }
                    }
                    catch (IOException iOException) {
                        FolderInstance.this.err().log(Level.INFO, "Cannot create " + this.all[i], iOException);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        FolderInstance.this.err().log(Level.INFO, "Cannot create " + this.all[i], classNotFoundException);
                    }
                    this.all[i] = new HoldInstance(null, this.all[i].cookie);
                }
            }

            public void run() {
                if (this.sequence != FolderInstance.this.creationSequence) {
                    return;
                }
                if (this.instancesTask != null && PROCESSOR.isRequestProcessorThread()) {
                    this.init();
                    this.instances();
                    this.postCreationTask = FolderInstance.this.postCreationTask((Runnable)((Object)this));
                    return;
                }
                if (this.all == null) {
                    this.init();
                }
                FolderInstance.this.defaultProcessObjectsFinal(this.all);
            }

            public void waitFinished() {
                if (this.instancesTask != null) {
                    this.instancesTask.waitFinished();
                }
                if (this.postCreationTask != null) {
                    this.postCreationTask.waitFinished();
                }
            }

            public boolean waitFinished(long l) throws InterruptedException {
                long l2 = System.currentTimeMillis() - l;
                if (this.instancesTask != null && !this.instancesTask.waitFinished(l)) {
                    return false;
                }
                if (this.postCreationTask != null) {
                    long l3 = l2 - System.currentTimeMillis();
                    if (l3 < 1L) {
                        l3 = 1L;
                    }
                    return this.postCreationTask.waitFinished(l3);
                }
                return true;
            }
        }
        R r = new R();
        r.sequence = ++this.creationSequence;
        if (this.precreateInstances) {
            r.instancesTask = PROCESSOR.create((Runnable)((Object)r));
            this.creationTask = r;
            r.instancesTask.schedule(0);
        } else {
            this.creationTask = this.postCreationTask((Runnable)((Object)r));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final HoldInstance[] defaultProcessObjects(Collection<DataObject> collection) {
        HashSet<FileObject> hashSet;
        this.err.fine("defaultProcessObjects");
        if (this.err.isLoggable(Level.FINEST)) {
            this.err.finest("  objects to process:" + Arrays.toString(collection.toArray()));
        }
        ArrayList<HoldInstance> arrayList = new ArrayList<HoldInstance>();
        HoldInstance[] holdInstanceArray = CURRENT;
        synchronized (holdInstanceArray) {
            hashSet = new HashSet<FileObject>(this.map.keySet());
        }
        for (DataObject dataObject : collection) {
            HoldInstance holdInstance;
            Object object;
            if (!dataObject.isValid()) continue;
            InstanceCookie instanceCookie = this.acceptDataObject(dataObject);
            if (instanceCookie != null) {
                object = dataObject.getPrimaryFile();
                boolean bl = true;
                holdInstance = null;
                if (hashSet.remove(object) && (holdInstance = this.map.get(object)) != null && (holdInstance.cookie == null || !holdInstance.cookie.equals(instanceCookie))) {
                    holdInstance = null;
                    bl = false;
                }
                if (holdInstance == null) {
                    HoldInstance holdInstance2 = instanceCookie instanceof HoldInstance ? (HoldInstance)instanceCookie : new HoldInstance(dataObject, instanceCookie);
                    ThreadLocal<Object> threadLocal = CURRENT;
                    synchronized (threadLocal) {
                        this.map.put((FileObject)object, holdInstance2);
                    }
                    if (bl) {
                        dataObject.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.listener, (Object)dataObject));
                    }
                    arrayList.add(holdInstance2);
                    continue;
                }
                arrayList.add(holdInstance);
                continue;
            }
            object = CURRENT;
            synchronized (object) {
                FileObject fileObject = dataObject.getPrimaryFile();
                hashSet.remove(fileObject);
                holdInstance = this.map.get(fileObject);
                if (holdInstance != null && holdInstance.cookie == null) {
                    continue;
                }
                holdInstance = new HoldInstance(dataObject, null);
                this.map.put(fileObject, holdInstance);
            }
            dataObject.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.listener, (Object)dataObject));
        }
        holdInstanceArray = CURRENT;
        synchronized (CURRENT) {
            this.map.keySet().removeAll(hashSet);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            holdInstanceArray = new HoldInstance[arrayList.size()];
            arrayList.toArray(holdInstanceArray);
            this.updateWaitFor(holdInstanceArray);
            return holdInstanceArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    final void defaultProcessObjectsFinal(HoldInstance[] holdInstanceArray) {
        Object object;
        block23: {
            object = null;
            object = this.createInstance((InstanceCookie[])holdInstanceArray);
            if (!this.err.isLoggable(Level.FINE)) break block23;
            this.err.fine("notifying finished");
            for (int i = 0; i < holdInstanceArray.length; ++i) {
                this.err.log(Level.FINE, "  #{0}: {1}", new Object[]{i, holdInstanceArray[i]});
            }
        }
        this.object = object;
        Object object2 = CURRENT.get();
        CURRENT.set(object);
        Object object3 = LAST_CURRENT.get();
        LAST_CURRENT.set((Object)this);
        try {
            this.notifyFinished();
        }
        finally {
            CURRENT.set(object2);
            LAST_CURRENT.set(object3);
        }
        catch (IOException iOException) {
            block24: {
                object = iOException;
                if (!this.err.isLoggable(Level.FINE)) break block24;
                this.err.fine("notifying finished");
                for (int i = 0; i < holdInstanceArray.length; ++i) {
                    this.err.log(Level.FINE, "  #{0}: {1}", new Object[]{i, holdInstanceArray[i]});
                }
            }
            this.object = object;
            Object object4 = CURRENT.get();
            CURRENT.set(object);
            Object object5 = LAST_CURRENT.get();
            LAST_CURRENT.set((Object)this);
            try {
                this.notifyFinished();
            }
            finally {
                CURRENT.set(object4);
                LAST_CURRENT.set(object5);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            block25: {
                object = classNotFoundException;
                if (!this.err.isLoggable(Level.FINE)) break block25;
                this.err.fine("notifying finished");
                for (int i = 0; i < holdInstanceArray.length; ++i) {
                    this.err.log(Level.FINE, "  #{0}: {1}", new Object[]{i, holdInstanceArray[i]});
                }
            }
            this.object = object;
            Object object6 = CURRENT.get();
            CURRENT.set(object);
            Object object7 = LAST_CURRENT.get();
            LAST_CURRENT.set((Object)this);
            try {
                this.notifyFinished();
            }
            finally {
                CURRENT.set(object6);
                LAST_CURRENT.set(object7);
            }
            {
                catch (Throwable throwable) {
                    if (this.err.isLoggable(Level.FINE)) {
                        this.err.fine("notifying finished");
                        for (int i = 0; i < holdInstanceArray.length; ++i) {
                            this.err.log(Level.FINE, "  #{0}: {1}", new Object[]{i, holdInstanceArray[i]});
                        }
                    }
                    this.object = object;
                    Object object8 = CURRENT.get();
                    CURRENT.set(object);
                    Object object9 = LAST_CURRENT.get();
                    LAST_CURRENT.set((Object)this);
                    try {
                        this.notifyFinished();
                    }
                    finally {
                        CURRENT.set(object8);
                        LAST_CURRENT.set(object9);
                    }
                    throw throwable;
                }
            }
        }
    }

    private void updateWaitFor(HoldInstance[] holdInstanceArray) {
        ArrayList<Task> arrayList = new ArrayList<Task>(holdInstanceArray.length);
        for (int i = 0; i < holdInstanceArray.length; ++i) {
            Task task = holdInstanceArray[i].getTask();
            if (task == null) continue;
            arrayList.add(task);
        }
        this.waitFor = arrayList.toArray(new Task[arrayList.size()]);
    }

    protected Task postCreationTask(Runnable runnable) {
        return PROCESSOR.post(runnable);
    }

    final Logger err() {
        return this.err;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + "@" + Integer.toHexString(System.identityHashCode((Object)this)) + "(" + this.container + ")";
    }

    private class HoldInstance
    implements InstanceCookie.Of,
    TaskListener {
        private final DataObject source;
        protected final InstanceCookie cookie;

        public HoldInstance(DataObject dataObject, InstanceCookie instanceCookie) {
            this.cookie = instanceCookie;
            this.source = dataObject;
            if (instanceCookie instanceof Task) {
                Task task = (Task)instanceCookie;
                task.addTaskListener((TaskListener)WeakListeners.create(TaskListener.class, (EventListener)((Object)this), (Object)task));
            }
        }

        public String instanceName() {
            return this.cookie.instanceName();
        }

        public boolean instanceOf(Class<?> clazz) {
            if (this.cookie instanceof InstanceCookie.Of) {
                InstanceCookie.Of of = (InstanceCookie.Of)this.cookie;
                return of.instanceOf(clazz);
            }
            try {
                Class clazz2 = this.cookie.instanceClass();
                return clazz.isAssignableFrom(clazz2);
            }
            catch (IOException iOException) {
                return false;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return false;
            }
        }

        public Class instanceClass() throws IOException, ClassNotFoundException {
            return this.cookie.instanceClass();
        }

        public Object instanceCreate() throws IOException, ClassNotFoundException {
            if (this.source == null) {
                return null;
            }
            return FolderInstance.this.instanceForCookie(this.source, this.cookie);
        }

        public void taskFinished(Task task) {
            FolderInstance.this.checkRecreate();
        }

        public Task getTask() {
            if (this.cookie instanceof Task) {
                return (Task)this.cookie;
            }
            return null;
        }

        public String toString() {
            return super.toString() + "[" + (this.source != null ? this.source.getPrimaryFile().getPath() : "null") + "]";
        }
    }

    private class Listener
    implements PropertyChangeListener,
    FolderListListener {
        Listener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getSource();
            if (object == FolderInstance.this.container) {
                if ("children".equals(propertyChangeEvent.getPropertyName())) {
                    FolderInstance.this.err.fine("PROP_CHILDREN");
                    FolderInstance.this.recreate();
                }
                return;
            }
            if ("name".equals(propertyChangeEvent.getPropertyName()) && object instanceof DataObject) {
                FolderInstance.this.err.fine("PROP_NAME");
                FolderInstance.this.recreate();
            }
            if ("cookie".equals(propertyChangeEvent.getPropertyName()) && object instanceof DataObject) {
                HoldInstance holdInstance;
                DataObject dataObject = (DataObject)object;
                if (FolderInstance.this.err.isLoggable(Level.FINE)) {
                    FolderInstance.this.err.fine("PROP_COOKIE: " + dataObject);
                }
                InstanceCookie instanceCookie = FolderInstance.this.acceptDataObject(dataObject);
                FileObject fileObject = dataObject.getPrimaryFile();
                ThreadLocal threadLocal = CURRENT;
                synchronized (threadLocal) {
                    holdInstance = (HoldInstance)FolderInstance.this.map.get(fileObject);
                }
                if (holdInstance != null) {
                    if (FolderInstance.this.err.isLoggable(Level.FINE)) {
                        FolderInstance.this.err.fine("previous instance: " + holdInstance + " new instance " + instanceCookie);
                    }
                    if (instanceCookie == null || instanceCookie != holdInstance && !instanceCookie.equals(holdInstance.cookie)) {
                        holdInstance = new HoldInstance(dataObject, instanceCookie);
                        threadLocal = CURRENT;
                        synchronized (threadLocal) {
                            FolderInstance.this.map.put(fileObject, holdInstance);
                        }
                        FolderInstance.this.recreate();
                    }
                }
            }
        }

        @Override
        public void finished(List<DataObject> list) {
            FolderInstance.this.processObjects(list);
        }

        @Override
        public void process(DataObject dataObject, List<DataObject> list) {
            list.add(dataObject);
        }
    }
}

