"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var OPERATION_KIND;
(function (OPERATION_KIND) {
    OPERATION_KIND[OPERATION_KIND["Remove"] = 0] = "Remove";
    OPERATION_KIND[OPERATION_KIND["Add"] = 1] = "Add";
    OPERATION_KIND[OPERATION_KIND["Replace"] = 2] = "Replace";
})(OPERATION_KIND = exports.OPERATION_KIND || (exports.OPERATION_KIND = {}));
class TransformOperation {
    constructor(kind, sourceFile, target) {
        this.kind = kind;
        this.sourceFile = sourceFile;
        this.target = target;
    }
}
exports.TransformOperation = TransformOperation;
class RemoveNodeOperation extends TransformOperation {
    constructor(sourceFile, target) {
        super(OPERATION_KIND.Remove, sourceFile, target);
    }
}
exports.RemoveNodeOperation = RemoveNodeOperation;
class AddNodeOperation extends TransformOperation {
    constructor(sourceFile, target, before, after) {
        super(OPERATION_KIND.Add, sourceFile, target);
        this.before = before;
        this.after = after;
    }
}
exports.AddNodeOperation = AddNodeOperation;
class ReplaceNodeOperation extends TransformOperation {
    constructor(sourceFile, target, replacement) {
        super(OPERATION_KIND.Replace, sourceFile, target);
        this.replacement = replacement;
    }
}
exports.ReplaceNodeOperation = ReplaceNodeOperation;
//# sourceMappingURL=data:application/json;base64,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