/*
 * Copyright (c) 2012, 2019, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class CurrencyNames_ga extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ATS = "ATS";
        final String metaValue_BEC = "BEC";
        final String metaValue_BEL = "BEL";
        final String metaValue_DDM = "DDM";
        final String metaValue_FRF = "FRF";
        final String metaValue_LUC = "LUC";
        final String metaValue_LVR = "LVR";
        final String metaValue_MXV = "MXV";
        final String metaValue_YUN = "YUN";
        final Object[][] data = new Object[][] {
            { "UGS", "UGS" },
            { "mwk", "Kwacha na Mal\u00e1ive" },
            { "FJD", "FJD" },
            { "LVL", "LVL" },
            { "SCR", "SCR" },
            { "CDF", "CDF" },
            { "MXP", "MXP" },
            { "bad", "D\u00ednear Bhoisnia-Heirseagaiv\u00e9in (1992\u20131994)" },
            { "BBD", "BBD" },
            { "HNL", "HNL" },
            { "UGX", "UGX" },
            { "LVR", metaValue_LVR },
            { "MXV", metaValue_MXV },
            { "fim", "Markka Fionnlannach" },
            { "dem", "Deutsche Mark" },
            { "bam", "Marg Inmhalartaithe na Boisnia-Heirseagaiv\u00e9ine" },
            { "egp", "Punt na h\u00c9igipte" },
            { "SDD", "SDD" },
            { "SDG", "SDG" },
            { "ZRN", "ZRN" },
            { "nzd", "Dollar na Nua-Sh\u00e9alainne" },
            { "IQD", "IQD" },
            { "SDP", "SDP" },
            { "GMD", "GMD" },
            { "ugs", "Scilling Uganda (1966\u20131987)" },
            { "fjd", "Dollar Fhids\u00ed" },
            { "mxn", "Peso Mheicsiceo" },
            { "ZRZ", "ZRZ" },
            { "lvl", "Lats na Laitvia" },
            { "scr", "R\u00faip\u00ed na S\u00e9is\u00e9al" },
            { "cdf", "Franc an Chong\u00f3" },
            { "mxp", "Peso Airgid Mheicsiceo (1861\u20131992)" },
            { "bbd", "Dollar Bharbad\u00f3s" },
            { "MYR", "MYR" },
            { "hnl", "Lempira Hond\u00faras" },
            { "ugx", "Scilling Uganda" },
            { "lvr", metaValue_LVR },
            { "mxv", metaValue_MXV },
            { "FKP", "FKP" },
            { "sdd", "Dinar na S\u00fad\u00e1ine (1992\u20132007)" },
            { "sdg", "Punt na S\u00fad\u00e1ine" },
            { "zrn", "Zaire Nua S\u00e1\u00edreach" },
            { "SEK", "SEK" },
            { "MZE", "MZE" },
            { "iqd", "Dinar na hIar\u00e1ice" },
            { "GNF", "GNF" },
            { "sdp", "Punt na S\u00fad\u00e1ine (1957\u20131998)" },
            { "gmd", "Dalasi na Gaimbia" },
            { "MZN", "MZN" },
            { "MZM", "MZM" },
            { "QAR", "QAR" },
            { "zrz", "Zaire S\u00e1\u00edreach" },
            { "myr", "Ringgit na Malaeisia" },
            { "IRR", "IRR" },
            { "fkp", "Punt Oile\u00e1in Fh\u00e1clainne" },
            { "GNS", "GNS" },
            { "XPD", "XPD" },
            { "xof", "Franc CFA Iarthar na hAfraice" },
            { "THB", "\u0e3f" },
            { "BDT", "BDT" },
            { "LYD", "LYD" },
            { "sek", "Cor\u00f3in na Sualainne" },
            { "KWD", "KWD" },
            { "mze", "Escudo M\u00f3saimb\u00edce" },
            { "XPT", "XPT" },
            { "gnf", "Franc na Guine" },
            { "ISK", "ISK" },
            { "mzn", "Metical Mh\u00f3saimb\u00edc" },
            { "BEC", metaValue_BEC },
            { "mzm", "Metical M\u00f3saimb\u00edce" },
            { "BEF", "BEF" },
            { "qar", "Riyal Chatar" },
            { "BEL", metaValue_BEL },
            { "irr", "Rial na hIar\u00e1ine" },
            { "gns", "Syli Guine" },
            { "xpd", "Pallaidiam" },
            { "thb", "Baht na T\u00e9alainne" },
            { "xpf", "Franc CFP" },
            { "PAB", "PAB" },
            { "SGD", "SGD" },
            { "bdt", "Taka na Banglaid\u00e9ise" },
            { "lyd", "Dinar na Libia" },
            { "kwd", "Dinar Chu\u00e1it" },
            { "HRD", "HRD" },
            { "xpt", "Platanam" },
            { "CHF", "CHF" },
            { "HRK", "HRK" },
            { "ITL", "ITL" },
            { "isk", "Kr\u00f3na na h\u00cdoslainne" },
            { "bec", metaValue_BEC },
            { "DJF", "DJF" },
            { "bef", "Franc Beilgeach" },
            { "bel", metaValue_BEL },
            { "XRE", "XRE" },
            { "ADP", "ADP" },
            { "pab", "Balboa Phanama" },
            { "sgd", "Dollar Shingeap\u00f3r" },
            { "KYD", "KYD" },
            { "VNN", "VNN" },
            { "GQE", "GQE" },
            { "SHP", "SHP" },
            { "hrd", "D\u00ednear na Cr\u00f3ite" },
            { "TJS", "TJS" },
            { "TJR", "TJR" },
            { "AED", "AED" },
            { "chf", "Franc na hEilv\u00e9ise" },
            { "hrk", "Kuna na Cr\u00f3ite" },
            { "itl", "Lira na hIod\u00e1ile" },
            { "djf", "Franc Djibouti" },
            { "DKK", "DKK" },
            { "BGL", "BGL" },
            { "ZWD", "ZWD" },
            { "BGN", "BGN" },
            { "YUD", "YUD" },
            { "BGO", "BGO" },
            { "adp", "Peseta And\u00f3ra" },
            { "vnd", "Dong V\u00edtneam" },
            { "YUM", "YUM" },
            { "YUN", metaValue_YUN },
            { "YUR", "YUR" },
            { "kyd", "Dollar Oile\u00e1in Cayman" },
            { "vnn", "Dong V\u00edtneam (1978\u20131985)" },
            { "GRD", "GRD" },
            { "HTG", "HTG" },
            { "gqe", "Ekwele Guineana na Guine Me\u00e1nchiorcla\u00ed" },
            { "shp", "Punt San H\u00e9ilin" },
            { "XSU", "XSU" },
            { "AFA", "AFA" },
            { "tjs", "Somoni na T\u00e1ids\u00edceast\u00e1ine" },
            { "tjr", "R\u00fabal na T\u00e1ids\u00edceast\u00e1ine" },
            { "BHD", "BHD" },
            { "SIT", "SIT" },
            { "aed", "Dirham Aontas na n\u00c9im\u00edr\u00edochta\u00ed Arabacha" },
            { "KZT", "KZT" },
            { "dkk", "Cor\u00f3in na Danmhairge" },
            { "bgl", "Lev Crua na Bulg\u00e1ire" },
            { "zwd", "Dollar Siomb\u00e1bach (1980\u20132008)" },
            { "bgn", "Lev na Bulg\u00e1ire" },
            { "AFN", "AFN" },
            { "yud", "D\u00ednear Crua I\u00fagslavach (1966\u20131990)" },
            { "bgo", "Lev na Bulg\u00e1ire (1879\u20131952)" },
            { "yum", "D\u00ednear Nua I\u00fagslavach (1994\u20132002)" },
            { "yun", metaValue_YUN },
            { "HUF", "HUF" },
            { "grd", "Drachma Gr\u00e9agach" },
            { "htg", "Gourde H\u00e1\u00edt\u00ed" },
            { "afa", "Afgain\u00ed (1927\u20132002)" },
            { "BIF", "BIF" },
            { "bhd", "Dinar Bhair\u00e9in" },
            { "sit", "Tolar na Sl\u00f3iv\u00e9ine" },
            { "kzt", "Tenge na Casacst\u00e1ine" },
            { "afn", "Afghani na hAfganast\u00e1ine" },
            { "NAD", "NAD" },
            { "SKK", "SKK" },
            { "PEI", "PEI" },
            { "TMM", "TMM" },
            { "PEN", "PEN" },
            { "huf", "Forint na hUng\u00e1ire" },
            { "WST", "WST" },
            { "TMT", "TMT" },
            { "FRF", metaValue_FRF },
            { "CLF", "CLF" },
            { "CLE", "CLE" },
            { "bif", "Franc na Bur\u00faine" },
            { "PES", "PES" },
            { "GTQ", "GTQ" },
            { "CLP", "CLP" },
            { "TND", "TND" },
            { "nad", "Dollar na Namaibe" },
            { "SLL", "SLL" },
            { "skk", "Koruna na Sl\u00f3vaice" },
            { "pei", "Inti Pheiri\u00fa" },
            { "tmm", "Manat na Tuircm\u00e9anast\u00e1ine (1993\u20132009)" },
            { "pen", "Sol Pheiri\u00fa" },
            { "wst", "Tala Sham\u00f3" },
            { "tmt", "Manat na Tuircm\u00e9anast\u00e1ine" },
            { "frf", metaValue_FRF },
            { "clf", "Unidades de Fomento na Sile" },
            { "cle", "Escudo na Sile" },
            { "pes", "Sol Pheiri\u00fa (1863\u20131965)" },
            { "DOP", "DOP" },
            { "gtq", "Quetzal Ghuatamala" },
            { "clp", "Peso na Sile" },
            { "tnd", "Dinar na T\u00fain\u00e9ise" },
            { "MAD", "MAD" },
            { "sll", "Leone Shiarra Leon" },
            { "MAF", "MAF" },
            { "TOP", "TOP" },
            { "PGK", "PGK" },
            { "ERN", "ERN" },
            { "dop", "Peso na Poblachta Doiminic\u00ed" },
            { "TPE", "TPE" },
            { "mad", "Dirham Mharac\u00f3" },
            { "ESA", "ESA" },
            { "maf", "Franc Mharac\u00f3" },
            { "GWE", "GWE" },
            { "top", "Pa\u02bbanga Thonga" },
            { "ESB", "ESB" },
            { "pgk", "Kina Nua-Ghuine Phapua" },
            { "BMD", "BMD" },
            { "PHP", "PHP" },
            { "XXX", "XXX" },
            { "cnh", "CNH" },
            { "ern", "Nakfa na hEiritr\u00e9" },
            { "GWP", "GWP" },
            { "ESP", "ESP" },
            { "COP", "COP" },
            { "USD", "$" },
            { "COU", "COU" },
            { "tpe", "Escudo T\u00edom\u00f3ir" },
            { "cny", "Yuan na S\u00edne" },
            { "USN", "USN" },
            { "ETB", "ETB" },
            { "USS", "USS" },
            { "gwe", "Escudo na Guine Portaing\u00e9ala\u00ed" },
            { "SOS", "SOS" },
            { "VUV", "VUV" },
            { "LAK", "LAK" },
            { "bmd", "Dollar Bheirmi\u00fada" },
            { "BND", "BND" },
            { "php", "Peso na nOile\u00e1n Filip\u00edneach" },
            { "xxx", "Airgeadra Anaithnid" },
            { "ALK", "ALK" },
            { "ALL", "ALL" },
            { "gwp", "Peso Guine-Bhissau" },
            { "esp", "Peseta na Sp\u00e1inne" },
            { "cop", "Peso na Col\u00f3ime" },
            { "usd", "Dollar S.A.M." },
            { "TRL", "TRL" },
            { "usn", "Dollar S.A.M. (an ch\u00e9ad l\u00e1 eile)" },
            { "etb", "Birr na hAet\u00f3ipe" },
            { "GYD", "GYD" },
            { "BOB", "BOB" },
            { "MDL", "MDL" },
            { "uss", "Dollar S.A.M. (an l\u00e1 c\u00e9anna)" },
            { "sos", "Scilling na Som\u00e1ile" },
            { "vuv", "Vatu Vanuat\u00fa" },
            { "lak", "Kip Laos" },
            { "AMD", "AMD" },
            { "bnd", "Dollar Bhr\u00fain\u00e9" },
            { "TRY", "TRY" },
            { "LBP", "LBP" },
            { "BOL", "BOL" },
            { "all", "Lek na hAlb\u00e1ine" },
            { "alk", "Lek na hAlb\u00e1ine (1946\u20131965)" },
            { "BOP", "BOP" },
            { "BOV", "BOV" },
            { "ROL", "ROL" },
            { "trl", "Lira na Tuirce (1922\u20132005)" },
            { "RON", "RON" },
            { "gyd", "Dollar na Gu\u00e1ine" },
            { "NGN", "NGN" },
            { "bob", "Boliviano" },
            { "mdl", "Leu na Mold\u00f3ive" },
            { "CRC", "CRC" },
            { "PKR", "PKR" },
            { "amd", "Dram na hAirm\u00e9ine" },
            { "ANG", "ANG" },
            { "try", "Lira na Tuirce" },
            { "lbp", "Punt na Liob\u00e1ine" },
            { "bop", "Peso na Bolaive" },
            { "eur", "Euro" },
            { "SRD", "SRD" },
            { "TTD", "TTD" },
            { "bov", "Mvdol na Bolaive" },
            { "SRG", "SRG" },
            { "rol", "Leu na R\u00f3m\u00e1ine (1952\u20132006)" },
            { "ron", "Leu na R\u00f3m\u00e1ine" },
            { "AOA", "AOA" },
            { "PLN", "PLN" },
            { "ngn", "Naira na Nig\u00e9ire" },
            { "CSD", "CSD" },
            { "crc", "Col\u00f3n Ch\u00f3sta R\u00edce" },
            { "pkr", "R\u00faip\u00ed na Pacast\u00e1ine" },
            { "CSK", "CSK" },
            { "ang", "Gildear Aintill\u00ed na h\u00cdsilt\u00edre" },
            { "AOK", "AOK" },
            { "PLZ", "PLZ" },
            { "AON", "AON" },
            { "AOR", "AOR" },
            { "srd", "Dollar Shuranam" },
            { "ttd", "Dollar Oile\u00e1n na Tr\u00edon\u00f3ide agus Tob\u00e1ga" },
            { "MGA", "MGA" },
            { "NIC", "NIC" },
            { "srg", "Gildear Shuranam" },
            { "MGF", "MGF" },
            { "SSP", "SSP" },
            { "BRC", "BRC" },
            { "aoa", "Kwanza Ang\u00f3la" },
            { "BRB", "BRB" },
            { "pln", "Zloty na Polainne" },
            { "BRE", "BRE" },
            { "NIO", "NIO" },
            { "csd", "Dinar na Seirbia (2002\u20132006)" },
            { "csk", "Koruna Crua na Seicsl\u00f3vaice" },
            { "aok", "Kwanza Ang\u00f3lach (1977\u20131990)" },
            { "BRN", "BRN" },
            { "plz", "Zloty Polannach (1950\u20131995)" },
            { "aon", "Kwanza Nua Ang\u00f3lach (1990\u20132000)" },
            { "STD", "STD" },
            { "BRR", "BRR" },
            { "ZAL", "ZAL" },
            { "aor", "Kwanza Reajustado Ang\u00f3lach (1995\u20131999)" },
            { "mga", "Ariary Mhadagascar" },
            { "nic", "C\u00f3rdoba Nicearagua (1988\u20131991)" },
            { "ZAR", "ZAR" },
            { "BRZ", "BRZ" },
            { "mgf", "Franc Madagascar" },
            { "CUC", "CUC" },
            { "ssp", "Punt na S\u00fad\u00e1ine Theas" },
            { "BSD", "BSD" },
            { "brc", "Cruzado na Brasa\u00edle (1986\u20131989)" },
            { "brb", "Cruzeiro Nua na Brasa\u00edle (1967\u20131986)" },
            { "bre", "Cruzeiro na Brasa\u00edle (1990\u20131993)" },
            { "nio", "C\u00f3rdoba Nicearagua" },
            { "brl", "Real na Brasa\u00edle" },
            { "CUP", "CUP" },
            { "brn", "Cruzado Nua na Brasa\u00edle (1989\u20131990)" },
            { "RSD", "RSD" },
            { "std", "Dobra S\u00e3o Tom\u00e9 agus Pr\u00edncipe (1977\u20132017)" },
            { "brr", "Cruzeiro na Brasa\u00edle (1993\u20131994)" },
            { "zal", "Rand na hAfraice Theas (airgead\u00fail)" },
            { "zar", "Rand na hAfraice Theas" },
            { "brz", "Cruzeiro na Brasa\u00edle (1942\u20131967)" },
            { "stn", "Dobra S\u00e3o Tom\u00e9 agus Pr\u00edncipe" },
            { "UYP", "UYP" },
            { "ARA", "ARA" },
            { "UYU", "UYU" },
            { "cuc", "Peso Inmhalartaithe Ch\u00faba" },
            { "SUR", "SUR" },
            { "bsd", "Dollar na mBah\u00e1ma\u00ed" },
            { "CVE", "CVE" },
            { "OMR", "OMR" },
            { "KES", "KES" },
            { "ARL", "ARL" },
            { "ARM", "ARM" },
            { "BTN", "BTN" },
            { "ARP", "ARP" },
            { "cup", "Peso Ch\u00faba" },
            { "twd", "Dollar Nua na T\u00e9av\u00e1ine" },
            { "SVC", "SVC" },
            { "ARS", "ARS" },
            { "rsd", "Dinar na Seirbia" },
            { "NLG", "NLG" },
            { "uyp", "Peso Uragua (1975\u20131993)" },
            { "UZS", "UZS" },
            { "uyu", "Peso Uragua" },
            { "ara", "Austral Airgint\u00edneach" },
            { "sur", "R\u00fabal an Aontais Sh\u00f3iv\u00e9adaigh" },
            { "cve", "Escudo Rinn Verde" },
            { "omr", "Rial \u00d3man" },
            { "kes", "Scilling na C\u00e9inia" },
            { "BUK", "BUK" },
            { "arm", "Peso na hAirgint\u00edne (1881\u20131970)" },
            { "btn", "Ngultrum na B\u00fat\u00e1ine" },
            { "RUB", "RUB" },
            { "arp", "Peso na hAirgint\u00edne (1983\u20131985)" },
            { "svc", "Col\u00f3n na Salvad\u00f3ire" },
            { "ars", "Peso na hAirgint\u00edne" },
            { "MKD", "MKD" },
            { "nlg", "Guilder \u00cdsilt\u00edreach" },
            { "RUR", "RUR" },
            { "DZD", "DZD" },
            { "uzs", "Sum na h\u00daisb\u00e9iceast\u00e1ine" },
            { "MKN", "MKN" },
            { "KGS", "KGS" },
            { "buk", "Kyat Bhurma" },
            { "rub", "R\u00fabal na R\u00faise" },
            { "XAG", "XAG" },
            { "ATS", metaValue_ATS },
            { "MLF", "MLF" },
            { "mkd", "Denar na Macad\u00f3ine" },
            { "TZS", "TZS" },
            { "XAU", "XAU" },
            { "rur", "R\u00fabal na R\u00faise (1991\u20131998)" },
            { "dzd", "Dinar na hAilg\u00e9ire" },
            { "KHR", "KHR" },
            { "IDR", "IDR" },
            { "XBA", "XBA" },
            { "kgs", "Som na Cirgeast\u00e1ine" },
            { "XBC", "XBC" },
            { "YDD", "YDD" },
            { "XBB", "XBB" },
            { "BWP", "BWP" },
            { "CYP", "CYP" },
            { "XBD", "XBD" },
            { "xaf", "Franc CFA na hAfraice L\u00e1ir" },
            { "xag", "Airgead" },
            { "RWF", "RWF" },
            { "ats", metaValue_ATS },
            { "mlf", "Franc Mhail\u00ed" },
            { "MMK", "MMK" },
            { "NOK", "NOK" },
            { "SYP", "SYP" },
            { "tzs", "Scilling na Tans\u00e1ine" },
            { "xau", "\u00d3r" },
            { "aud", "Dollar na hAstr\u00e1ile" },
            { "LKR", "LKR" },
            { "khr", "Riel na Camb\u00f3ide" },
            { "CZK", "CZK" },
            { "IEP", "IEP" },
            { "idr", "Rupiah na hIndin\u00e9ise" },
            { "xba", "Aonad Ilchodach Eorpach" },
            { "xbc", "Aonad Cuntais Eorpach (XBC)" },
            { "ydd", "D\u00ednear \u00c9imin" },
            { "xbb", "Aonad Airgeada\u00edochta Eorpach" },
            { "bwp", "Pula na Botsu\u00e1ine" },
            { "cyp", "Punt na Cipire" },
            { "xbd", "Aonad Cuntais Eorpach (XBD)" },
            { "PTE", "PTE" },
            { "rwf", "Franc Ruanda" },
            { "SZL", "SZL" },
            { "YER", "YER" },
            { "BYB", "BYB" },
            { "mmk", "Kyat Mhaenmar" },
            { "nok", "Cor\u00f3in na hIorua" },
            { "syp", "Punt na Siria" },
            { "AWG", "AWG" },
            { "NPR", "NPR" },
            { "MNT", "MNT" },
            { "lkr", "R\u00faip\u00ed Shr\u00ed Lanca" },
            { "czk", "Koruna Phoblacht na Seice" },
            { "iep", "Punt \u00c9ireannach" },
            { "BYN", "BYN" },
            { "xcd", "Dollar na Cairibe Thoir" },
            { "BYR", "BYR" },
            { "pte", "Escudo na Portaing\u00e9ile" },
            { "szl", "Lilangeni na Suasalainne" },
            { "XDR", "XDR" },
            { "yer", "Rial \u00c9imin" },
            { "byb", "R\u00fabal Nua na Bealar\u00faise (1994\u20131999)" },
            { "BZD", "BZD" },
            { "MOP", "MOP" },
            { "awg", "Fl\u00f3ir\u00edn Ar\u00faba" },
            { "npr", "R\u00faip\u00ed Neipeal" },
            { "mnt", "Tugrik na Mong\u00f3ile" },
            { "gbp", "Punt Steirling" },
            { "byn", "R\u00fabal na Bealar\u00faise" },
            { "byr", "R\u00fabal na Bealar\u00faise (2000\u20132016)" },
            { "xdr", "Cearta Speisialta Tarraingthe" },
            { "XEU", "XEU" },
            { "bzd", "Dollar na Beil\u00edse" },
            { "mop", "Pataca Mhacao" },
            { "XFO", "XFO" },
            { "KMF", "KMF" },
            { "XFU", "XFU" },
            { "xeu", "Aonad Airgeadra Eorpach" },
            { "GEK", "GEK" },
            { "GEL", "GEL" },
            { "AZM", "AZM" },
            { "AZN", "AZN" },
            { "UAH", "UAH" },
            { "UAK", "UAK" },
            { "xfo", "Franc \u00d3r Francach" },
            { "kmf", "Franc Oile\u00e1in Chom\u00f3ra" },
            { "xfu", "UIC-Franc Francach" },
            { "MRO", "MRO" },
            { "gek", "Kupon Larit na Gr\u00faise" },
            { "gel", "Lari na Seoirsia" },
            { "azn", "Manat na hAsarbaise\u00e1ine" },
            { "azm", "Manat na hAsarbaise\u00e1ine (1993\u20132006)" },
            { "uah", "Hryvnia na h\u00dacr\u00e1ine" },
            { "uak", "Karbovanets \u00dacr\u00e1nach" },
            { "PYG", "PYG" },
            { "JMD", "JMD" },
            { "mro", "Ouguiya na M\u00e1rat\u00e1ine (1973\u20132017)" },
            { "mru", "Ouguiya na M\u00e1rat\u00e1ine" },
            { "VEB", "VEB" },
            { "ECS", "ECS" },
            { "VEF", "VEF" },
            { "ECV", "ECV" },
            { "ZMK", "ZMK" },
            { "LRD", "LRD" },
            { "pyg", "Guaran\u00ed Pharagua" },
            { "jmd", "Dollar na hIam\u00e1ice" },
            { "GHC", "GHC" },
            { "MTL", "MTL" },
            { "ZMW", "ZMW" },
            { "MTP", "MTP" },
            { "ILP", "ILP" },
            { "veb", "Bol\u00edvar Veinis\u00e9ala (1871\u20132008)" },
            { "GHS", "GHS" },
            { "KPW", "KPW" },
            { "ecs", "Sucre Eacuad\u00f3ir" },
            { "vef", "Bol\u00edvar Veinis\u00e9ala" },
            { "ecv", "Unidad de Valor Constante (UVC) Eacuad\u00f3ir" },
            { "zmk", "Kwacha Saimbiach (1968\u20132012)" },
            { "JOD", "JOD" },
            { "lrd", "Dollar na Lib\u00e9ire" },
            { "ghc", "Cedi Gh\u00e1na (1979\u20132007)" },
            { "LSL", "LSL" },
            { "mtl", "Lira Mh\u00e1lta" },
            { "zmw", "Kwacha na Saimbia" },
            { "mtp", "Punt Mh\u00e1lta" },
            { "EEK", "EEK" },
            { "MUR", "MUR" },
            { "ilp", "Punt Iosraelach" },
            { "GIP", "GIP" },
            { "ils", "Seiceal Nua Iosrael" },
            { "ghs", "Cedi Gh\u00e1na" },
            { "kpw", "Won na C\u00f3ir\u00e9 Thuaidh" },
            { "jod", "Dinar na hIord\u00e1ine" },
            { "KRH", "KRH" },
            { "hkd", "Dollar Hong Cong" },
            { "lsl", "Loti Leos\u00f3ta" },
            { "LTL", "LTL" },
            { "SAR", "SAR" },
            { "MVP", "MVP" },
            { "cad", "Dollar Cheanada" },
            { "MVR", "MVR" },
            { "KRO", "KRO" },
            { "eek", "Kroon na hEast\u00f3ine" },
            { "mur", "R\u00faip\u00ed Oile\u00e1n Mhuir\u00eds" },
            { "DDM", metaValue_DDM },
            { "LTT", "LTT" },
            { "gip", "Punt Ghiobr\u00e1ltar" },
            { "JPY", "\u00a5" },
            { "SBD", "SBD" },
            { "LUC", metaValue_LUC },
            { "LUF", "LUF" },
            { "MWK", "MWK" },
            { "BAD", "BAD" },
            { "ltl", "Litas na Liotu\u00e1ine" },
            { "sar", "Riyal na hAraibe S\u00e1da\u00ed" },
            { "mvp", "R\u00faip\u00ed Oile\u00e1in Mhaild\u00edve" },
            { "mvr", "Rufiyaa Oile\u00e1in Mhaild\u00edve" },
            { "FIM", "FIM" },
            { "ddm", metaValue_DDM },
            { "inr", "R\u00faip\u00ed na hIndia" },
            { "DEM", "DEM" },
            { "ltt", "Talonas Liotu\u00e1nach" },
            { "BAM", "BAM" },
            { "BAN", "BAN" },
            { "EGP", "EGP" },
            { "krw", "Won na C\u00f3ir\u00e9 Theas" },
            { "jpy", "Yen na Seap\u00e1ine" },
            { "sbd", "Dollar Oile\u00e1in Sholom\u00f3n" },
            { "luc", metaValue_LUC },
            { "luf", "Franc Lucsamburg" },
        };
        return data;
    }
}
