%% This is file `tudabeamer.cls' version 1.11 (2019/09/25),
%% it is part of
%% TUDa-CI -- Corporate Design for TU Darmstadt
%% ----------------------------------------------------------------------------
%%
%%  Copyright (C) 2018--2019 by Marei Peischl <marei@peitex.de>
%%
%% ============================================================================
%% This work may be distributed and/or modified under the
%% conditions of the LaTeX Project Public License, either version 1.3
%% of this license or (at your option) any later version.
%% The latest version of this license is in
%% http://www.latex-project.org/lppl.txt
%% and version 1.3 or later is part of all distributions of LaTeX
%% version 2005/12/01 or later.
%%
%% This work has the LPPL maintenance status `maintained'.
%%
%% The Current Maintainers of this work are
%%   Marei Peischl <tuda-ci@peitex.de>
%%   Markus Lazanowski <latex@ce.tu-darmstadt.de>
%%
%% The development respository can be found at
%% https://github.com/tudace/tuda_latex_templates
%% Please use the issue tracker for feedback!
%%
%% ============================================================================
%%
\def\fileversion{1.11}
\def\filedate{2019/09/25}
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{tudabeamer}
 [\filedate\space\fileversion\space]
   
\RequirePackage{l3keys2e}
\RequirePackage{URspecialopts}

\Define@specialopt@Module[TUDa/beamer]
\PassOptionsToClass{10pt}{beamer}

\Module@DefineSpecialPassKey[TUDa/beamer]{color}<tudacolors>

\ExplSyntaxOn
\keys_define:nn {TUDa/beamer} {
	accentcolor .code:n = \PassOptionsToPackage{accentcolor=#1}{tudacolors},
	colortitle .code:n = \PassOptionsToPackage{accentcolor=#1}{beamercolorthemeTUDa},
	colorbacktitle .code:n = \PassOptionsToPackage{accentcolor=#1}{beamercolorthemeTUDa},
	colorframetitle .code:n = \PassOptionsToPackage{accentcolor=#1}{beamercolorthemeTUDa},
	colorback .code:n = \PassOptionsToPackage{accentcolor=#1}{beamercolorthemeTUDa},
	logo .code:n = \PassOptionsToPackage{logo=#1}{beamerouterthemeTUDa},
	pdfa .bool_gset:N = \g_TUDa@pdfa_bool,
	pdfa .initial:n = false,
	logofile .code:n = \PassOptionsToPackage{logofile=#1}{beamerouterthemeTUDa},
	serif .code:n = \PassOptionsToPackage{serif=#1}{beamerfontthemeTUDa},
	serif .default:n = true,
	sans-serif .code:n = \PassOptionsToPackage{sans-serif=#1}{beamerfontthemeTUDa},
	sans-serif .default:n = true,
}


\clist_map_inline:nn {colortitle, colorbacktitle, colorframetitle, colorback} {
	\Module@DeclarePassOption[TUDa/beamer]{#1}{beamercolorthemeTUDa}
}

\ExplSyntaxOff

\Module@DeclarePassOption[TUDa/beamer]{logo}{beamerouterthemeTUDa}

\PassOptionsToPackage{pdfpagelabels=false,plainpages=false}{hyperref}
\PassOptionsToClass{t}{beamer}

\Module@Process@SpecialOptions[TUDa/beamer]

\DeclareOption*{%
	\PassOptionsToClass{\CurrentOption}{beamer}
}

\ProcessKeysOptions{TUDa/beamer}
\ProcessOptions*

\ExplSyntaxOn
\bool_if:NT  \g_TUDa@pdfa_bool {\PassOptionsToPackage{RGB}{xcolor}}

\bool_if:NT  \g_TUDa@pdfa_bool {
\RequirePackage{scrlfile}
\PreventPackageFromLoading{hyperref}
\def\hypersetup#1{}
}
\ExplSyntaxOff

% Load the latex-beamer class
\LoadClass{beamer}

\ExplSyntaxOn
\bool_if:NT \g_TUDa@pdfa_bool {
	\UnPreventPackageFromLoading{hyperref}
	\PassOptionsToPackage{a-1b}{pdfx}
	\RequirePackage{pdfx}
}
\ExplSyntaxOff

\hypersetup{hidelinks, unicode}

% Load the TUD theme
\AtEndOfClass{%
  \usetheme{TUDa}%
  \@input{\jobname.len}%
  \@starttoc{len}%
  \let\accentfont\normalfont%
}


%\department command
\def\department{\@dblarg\TUDa@beamer@department}

\long\def\TUDa@beamer@department[#1]#2{%
	\def\beamer@temp{#2}%
	\ifx\beamer@temp\@empty
	\def\insertdepartment{}
	\else
	\def\insertdepartment{\def\inst{\beamer@instinst}\def\and{\qquad}#2}%
	\fi
	\def\beamer@shortdepartment{#1}}
\department{}

\newcommand\insertshortdepartment[1][]{%
	{%
		\let\thanks=\@gobble%
		\beamer@setupshort{#1}%
		\beamer@insertshort{\beamer@shortdepartment}%
}}
%end of \department command
%

\ExplSyntaxOn
\if_bool:N \g_TUDa@pdfa_bool
\iow_new:N \TUDa@xmpdata_stream
\iow_open:Nn \TUDa@xmpdata_stream {\jobname.xmpdata}
\tl_new:N \g_TUDa@xmp_title
\tl_new:N \g_TUDa@xmp_author

\cs_new:Nn \TUDa_pass_TitleData: {
	\begingroup
	\def\newline{}
	\def\\{}
	\let\thanks\use_none:n
	\cs_set:Npn \and {\exp_not:n {\exp_not:N \sep}}
	\bool_if:NTF \g_TUDa_pass_TitleData_bool {
		\tl_gset:Nx \g_TUDa@xmp_title {\insertshorttitle}
		\tl_gset:Nx \g_TUDa@xmp_author {\insertshortauthor}	
		\iow_now:Nx \TUDa@xmpdata_stream
		{
			\exp_not:N \Title{\tl_to_str:V \g_TUDa@xmp_title}
			^^J
			\exp_not:N \Author{\tl_to_str:V \g_TUDa@xmp_author}
			^^J
			\exp_not:N \Creator{LaTeX~ using~ the~ TUDa-CI~ Bundle}
		}
	}{
		\begingroup
		\use:c {pdfx@localcommands}
		\prop_if_in:NnF \g_TUDa_MetaData_prop {Creator} {\prop_gput:Nnn \g_TUDa_MetaData_prop {Creator} {LaTeX~ using~ the~ TUDa-CI~ Bundle}}
		\prop_map_function:NN \g_TUDa_MetaData_prop  \TUDa_write_xmp_line:nn
		\endgroup
	}
	\endgroup
}
\cs_new:Nn \TUDa_write_xmp_line:nn {		
	\cs_if_exist:cTF {\tl_mixed_case:n {#1}} {
		\iow_now:Nx \TUDa@xmpdata_stream {
			\c_backslash_str \tl_mixed_case:n {#1} {#2}\iow_newline:
		}
	}{
		\msg_error:nnn {TUDapub} {unknown-metadata} {#1}
	}
}

\bool_new:N \g_TUDa_pass_TitleData_bool
\bool_gset_true:N  \g_TUDa_pass_TitleData_bool
\prop_new:N \g_TUDa_MetaData_prop

\newcommand*{\Metadata}[1]{
	\bool_gset_false:N \g_TUDa_pass_TitleData_bool
	\prop_gset_from_keyval:Nn \g_TUDa_MetaData_prop {#1}
}

\msg_new:nnnn {TUDapub} {unknown-metadata} {
	You~ used~ the~ #1~ metadata~ entry.\\
	I~ don't~ know~ how~ to~ handle~ that.\\
	It~ will~ be~ ignored.
} {See~ TUDa-CI~ or~ pdfx~ documentation~ for~ details.}
\else:
\msg_new:nnn {tudapub} {no-pdfa}{The~ tudapub~ class~ won't~ create~ PDF/A-mode.}
\msg_info:nn {tudapub} {no-pdfa}
\fi:
\ExplSyntaxOff

\endinput