/*
 * Decompiled with CFR 0.152.
 */
package io.grpc;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.grpc.Attributes;
import io.grpc.EquivalentAddressGroup;
import io.grpc.ExperimentalApi;
import io.grpc.ProxyDetector;
import io.grpc.Status;
import io.grpc.SynchronizationContext;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1770")
public abstract class NameResolver {
    public abstract String getServiceAuthority();

    public abstract void start(Listener var1);

    public abstract void shutdown();

    public void refresh() {
    }

    public static abstract class Helper {
        public abstract int getDefaultPort();

        public abstract ProxyDetector getProxyDetector();

        public SynchronizationContext getSynchronizationContext() {
            throw new UnsupportedOperationException("Not implemented");
        }

        public ConfigOrError parseServiceConfig(Map<String, ?> rawServiceConfig) {
            throw new UnsupportedOperationException("should have been implemented");
        }

        public static final class ConfigOrError {
            public static final ConfigOrError UNKNOWN_CONFIG = ConfigOrError.fromConfig(new UnknownConfig());
            private final Status status;
            private final Object config;

            public static ConfigOrError fromConfig(Object config) {
                return new ConfigOrError(config);
            }

            public static ConfigOrError fromError(Status status) {
                return new ConfigOrError(status);
            }

            private ConfigOrError(Object config) {
                this.config = Preconditions.checkNotNull((Object)config, (Object)"config");
                this.status = null;
            }

            private ConfigOrError(Status status) {
                this.config = null;
                this.status = (Status)Preconditions.checkNotNull((Object)status, (Object)"status");
                Preconditions.checkArgument((!status.isOk() ? 1 : 0) != 0, (String)"cannot use OK status: %s", (Object)status);
            }

            @Nullable
            public Object getConfig() {
                return this.config;
            }

            @Nullable
            public Status getError() {
                return this.status;
            }

            public String toString() {
                if (this.config != null) {
                    return MoreObjects.toStringHelper((Object)this).add("config", this.config).toString();
                }
                assert (this.status != null);
                return MoreObjects.toStringHelper((Object)this).add("error", (Object)this.status).toString();
            }

            private static final class UnknownConfig {
                UnknownConfig() {
                }

                public String toString() {
                    return "service config is unused";
                }
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Documented
    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/4972")
    public static @interface ResolutionResultAttr {
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1770")
    @ThreadSafe
    public static interface Listener {
        public void onAddresses(List<EquivalentAddressGroup> var1, Attributes var2);

        public void onError(Status var1);
    }

    public static abstract class Factory {
        @Deprecated
        public static final Attributes.Key<Integer> PARAMS_DEFAULT_PORT = Attributes.Key.create("params-default-port");
        @Deprecated
        @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/5113")
        public static final Attributes.Key<ProxyDetector> PARAMS_PROXY_DETECTOR = Attributes.Key.create("params-proxy-detector");
        @Deprecated
        private static final Attributes.Key<SynchronizationContext> PARAMS_SYNC_CONTEXT = Attributes.Key.create("params-sync-context");

        @Nullable
        @Deprecated
        public NameResolver newNameResolver(URI targetUri, final Attributes params) {
            Helper helper = new Helper(){

                @Override
                public int getDefaultPort() {
                    return (Integer)Preconditions.checkNotNull((Object)params.get(PARAMS_DEFAULT_PORT), (Object)"default port not available");
                }

                @Override
                public ProxyDetector getProxyDetector() {
                    return (ProxyDetector)Preconditions.checkNotNull((Object)params.get(PARAMS_PROXY_DETECTOR), (Object)"proxy detector not available");
                }

                @Override
                public SynchronizationContext getSynchronizationContext() {
                    return (SynchronizationContext)Preconditions.checkNotNull(params.get(PARAMS_SYNC_CONTEXT), (Object)"sync context not available");
                }
            };
            return this.newNameResolver(targetUri, helper);
        }

        @Nullable
        public NameResolver newNameResolver(URI targetUri, Helper helper) {
            return this.newNameResolver(targetUri, Attributes.newBuilder().set(PARAMS_DEFAULT_PORT, helper.getDefaultPort()).set(PARAMS_PROXY_DETECTOR, helper.getProxyDetector()).set(PARAMS_SYNC_CONTEXT, helper.getSynchronizationContext()).build());
        }

        public abstract String getDefaultScheme();
    }
}

