/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

@BugPattern(name="UndefinedEquals", summary="This type is not guaranteed to implement a useful #equals method.", severity=BugPattern.SeverityLevel.WARNING, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public final class UndefinedEquals
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<MethodInvocationTree> ASSERT_THAT_EQUALS = Matchers.allOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onDescendantOf("com.google.common.truth.Subject").namedAnyOf(new String[]{"isEqualTo", "isNotEqualTo"}), Matchers.receiverOfInvocation((Matcher)Matchers.anyOf((Matcher[])new Matcher[]{Matchers.staticMethod().onClass("com.google.common.truth.Truth").named("assertThat"), MethodMatchers.instanceMethod().onDescendantOf("com.google.common.truth.StandardSubjectBuilder").named("that")}))});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        Tree argument;
        Tree receiver;
        List<? extends ExpressionTree> arguments = tree.getArguments();
        if (Matchers.staticEqualsInvocation().matches((Tree)tree, state) || Matchers.assertEqualsInvocation().matches((Tree)tree, state) || Matchers.assertNotEqualsInvocation().matches((Tree)tree, state)) {
            receiver = arguments.get(arguments.size() - 2);
            argument = (Tree)Iterables.getLast(arguments);
        } else if (Matchers.instanceEqualsInvocation().matches((Tree)tree, state)) {
            receiver = ASTHelpers.getReceiver((ExpressionTree)tree);
            argument = arguments.get(0);
        } else if (ASSERT_THAT_EQUALS.matches((Tree)tree, state)) {
            receiver = (Tree)Iterables.getOnlyElement(arguments);
            argument = (Tree)Iterables.getOnlyElement(((MethodInvocationTree)ASTHelpers.getReceiver((ExpressionTree)tree)).getArguments());
        } else {
            return Description.NO_MATCH;
        }
        return Arrays.stream(BadClass.values()).filter(b -> ((BadClass)b).matchesType(ASTHelpers.getType((Tree)receiver), state) || ((BadClass)b).matchesType(ASTHelpers.getType((Tree)argument), state)).findFirst().map(b -> this.buildDescription(tree).setMessage(((BadClass)b).shortName() + " does not have well-defined equals behavior.").addFix(b.generateFix(receiver, argument, state)).build()).orElse(Description.NO_MATCH);
    }

    private static enum BadClass {
        LONG_SPARSE_ARRAY("LongSparseArray", new String[]{"android.util.LongSparseArray", "android.support.v4.util.LongSparseArrayCompat", "androidx.collection.LongSparseArrayCompat"}){

            @Override
            Optional<SuggestedFix> generateFix(Tree receiver, Tree argument, VisitorState state) {
                return Optional.empty();
            }
        }
        ,
        SPARSE_ARRAY("SparseArray", new String[]{"android.util.SparseArray", "android.support.v4.util.SparseArrayCompat", "androidx.collection.SparseArrayCompat"}){

            @Override
            Optional<SuggestedFix> generateFix(Tree receiver, Tree argument, VisitorState state) {
                return Optional.empty();
            }
        }
        ,
        MULTIMAP("Multimap", new String[]{"com.google.common.collect.Multimap"}){

            @Override
            Optional<SuggestedFix> generateFix(Tree receiver, Tree argument, VisitorState state) {
                return Optional.empty();
            }
        }
        ,
        CHAR_SEQUENCE("CharSequence", new String[]{"java.lang.CharSequence"}){

            @Override
            Optional<SuggestedFix> generateFix(Tree receiver, Tree argument, VisitorState state) {
                Type charSequence = state.getTypeFromString((String)Iterables.getOnlyElement((Iterable)CHAR_SEQUENCE.typeNames));
                if (ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)receiver), (Type)charSequence, (VisitorState)state) && ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)argument), (Type)state.getSymtab().stringType, (VisitorState)state)) {
                    return Optional.of(SuggestedFix.postfixWith((Tree)receiver, (String)".toString()"));
                }
                if (ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)argument), (Type)charSequence, (VisitorState)state) && ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)receiver), (Type)state.getSymtab().stringType, (VisitorState)state)) {
                    return Optional.of(SuggestedFix.postfixWith((Tree)argument, (String)".toString()"));
                }
                return Optional.empty();
            }
        }
        ,
        ITERABLE("Iterable", new String[]{"java.lang.Iterable"}){

            @Override
            Optional<SuggestedFix> generateFix(Tree receiver, Tree argument, VisitorState state) {
                return Optional.empty();
            }
        }
        ,
        COLLECTION("Collection", new String[]{"java.util.Collection"}){

            @Override
            Optional<SuggestedFix> generateFix(Tree receiver, Tree argument, VisitorState state) {
                return Optional.empty();
            }
        }
        ,
        QUEUE("Queue", new String[]{"java.util.Queue"}){

            @Override
            Optional<SuggestedFix> generateFix(Tree receiver, Tree argument, VisitorState state) {
                return Optional.empty();
            }
        };

        private final String shortName;
        private final ImmutableSet<String> typeNames;

        private BadClass(String shortName, String ... typeNames) {
            this.shortName = shortName;
            this.typeNames = ImmutableSet.copyOf((Object[])typeNames);
        }

        abstract Optional<SuggestedFix> generateFix(Tree var1, Tree var2, VisitorState var3);

        private boolean matchesType(Type type, VisitorState state) {
            return this.typeNames.stream().anyMatch(typeName -> ASTHelpers.isSameType((Type)type, (Type)state.getTypeFromString(typeName), (VisitorState)state));
        }

        private String shortName() {
            return this.shortName;
        }
    }
}

