/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.Hashtable;
import org.mozilla.javascript.Invoker;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class ClassCache {
    private static final Object AKEY = new Object();
    private volatile boolean cachingIsEnabled = true;
    Hashtable classTable = new Hashtable();
    boolean invokerOptimization = true;
    Invoker invokerMaster;
    Hashtable javaAdapterGeneratedClasses = new Hashtable();
    Hashtable javaAdapterIFGlueMasters = new Hashtable();
    private int generatedClassSerial;

    public static ClassCache get(Scriptable scope) {
        Scriptable obj = scope = ScriptableObject.getTopLevelScope(scope);
        do {
            ScriptableObject so;
            ClassCache lc;
            if (!(obj instanceof ScriptableObject) || (lc = (ClassCache)(so = (ScriptableObject)obj).getAssociatedValue(AKEY)) == null) continue;
            return lc;
        } while ((obj = obj.getPrototype()) != null);
        return new ClassCache();
    }

    public boolean associate(ScriptableObject topScope) {
        if (topScope.getParentScope() != null) {
            throw new IllegalArgumentException();
        }
        return this != topScope.associateValue(AKEY, this);
    }

    public synchronized void clearCaches() {
        this.classTable = new Hashtable();
        this.javaAdapterGeneratedClasses = new Hashtable();
        this.javaAdapterIFGlueMasters = new Hashtable();
        Invoker im = this.invokerMaster;
        if (im != null) {
            im.clearMasterCaches();
        }
    }

    public final boolean isCachingEnabled() {
        return this.cachingIsEnabled;
    }

    public synchronized void setCachingEnabled(boolean enabled) {
        if (enabled == this.cachingIsEnabled) {
            return;
        }
        if (!enabled) {
            this.clearCaches();
        }
        this.cachingIsEnabled = enabled;
    }

    public synchronized void setInvokerOptimizationEnabled(boolean enabled) {
        if (this.invokerOptimization == enabled) {
            return;
        }
        if (!enabled) {
            this.invokerMaster = null;
        }
        this.invokerOptimization = enabled;
    }

    public final synchronized int newClassSerialNumber() {
        return ++this.generatedClassSerial;
    }
}

