/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.android;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.util.TreePath;

@BugPattern(name="BinderIdentityRestoredDangerously", tags={"FragileCode"}, summary="A call to Binder.clearCallingIdentity() should be followed by Binder.restoreCallingIdentity() in a finally block. Otherwise the wrong Binder identity may be used by subsequent code.", severity=BugPattern.SeverityLevel.WARNING, providesFix=BugPattern.ProvidesFix.NO_FIX)
public class BinderIdentityRestoredDangerously
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final String BINDER_CLASS_NAME = "android.os.Binder";
    private static final Matcher<ExpressionTree> RESTORE_IDENTITY_METHOD = MethodMatchers.staticMethod().onClass("android.os.Binder").named("restoreCallingIdentity");

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!RESTORE_IDENTITY_METHOD.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        TryTree enclosingTry = (TryTree)ASTHelpers.findEnclosingNode((TreePath)state.getPath(), TryTree.class);
        if (enclosingTry == null) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }
}

