/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AssertThrowsUtils;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import java.util.List;
import java.util.Optional;

@BugPattern(name="TryFailRefactoring", summary="Prefer assertThrows to try/fail", severity=BugPattern.SeverityLevel.SUGGESTION, tags={"Refactoring"}, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class TryFailRefactoring
extends BugChecker
implements BugChecker.TryTreeMatcher {
    private static final Matcher<StatementTree> FAIL_METHOD = Matchers.expressionStatement((Matcher)MethodMatchers.staticMethod().anyClass().named("fail"));

    public Description matchTry(TryTree tree, VisitorState state) {
        List<? extends StatementTree> body = tree.getBlock().getStatements();
        if (body.isEmpty() || tree.getFinallyBlock() != null || tree.getCatches().size() != 1) {
            return Description.NO_MATCH;
        }
        CatchTree catchTree = (CatchTree)Iterables.getOnlyElement(tree.getCatches());
        if (catchTree.getParameter().getType().getKind() == Tree.Kind.UNION_TYPE) {
            return Description.NO_MATCH;
        }
        if (!FAIL_METHOD.matches((Tree)Iterables.getLast(body), state)) {
            return Description.NO_MATCH;
        }
        List<? extends StatementTree> throwingStatements = tree.getBlock().getStatements().subList(0, tree.getBlock().getStatements().size() - 1);
        Optional<Fix> fix = AssertThrowsUtils.tryFailToAssertThrows(tree, throwingStatements, state);
        return fix.isPresent() ? this.describeMatch(tree, fix) : Description.NO_MATCH;
    }
}

