#ifndef _EFL_UI_SCROLLABLE_EO_H_
#define _EFL_UI_SCROLLABLE_EO_H_

#ifndef _EFL_UI_SCROLLABLE_EO_CLASS_TYPE
#define _EFL_UI_SCROLLABLE_EO_CLASS_TYPE

typedef Eo Efl_Ui_Scrollable;

#endif

#ifndef _EFL_UI_SCROLLABLE_EO_TYPES
#define _EFL_UI_SCROLLABLE_EO_TYPES


#endif
/** Efl UI scrollable interface
 *
 * @ingroup Efl_Ui_Scrollable
 */
#define EFL_UI_SCROLLABLE_INTERFACE efl_ui_scrollable_interface_get()

EWAPI const Efl_Class *efl_ui_scrollable_interface_get(void);

/**
 * @brief The content position
 *
 * @param[in] obj The object.
 * @param[in] pos The position is virtual value, (0, 0) starting at the
 * top-left.
 *
 * @ingroup Efl_Ui_Scrollable
 */
EOAPI void efl_ui_scrollable_content_pos_set(Eo *obj, Eina_Position2D pos);

/**
 * @brief The content position
 *
 * @param[in] obj The object.
 *
 * @return The position is virtual value, (0, 0) starting at the top-left.
 *
 * @ingroup Efl_Ui_Scrollable
 */
EOAPI Eina_Position2D efl_ui_scrollable_content_pos_get(const Eo *obj);

/**
 * @brief The content size
 *
 * @param[in] obj The object.
 *
 * @return The content size in pixels.
 *
 * @ingroup Efl_Ui_Scrollable
 */
EOAPI Eina_Size2D efl_ui_scrollable_content_size_get(const Eo *obj);

/**
 * @brief The viewport geometry
 *
 * @param[in] obj The object.
 *
 * @return It is absolute geometry.
 *
 * @ingroup Efl_Ui_Scrollable
 */
EOAPI Eina_Rect efl_ui_scrollable_viewport_geometry_get(const Eo *obj);

/**
 * @brief Bouncing behavior
 *
 * When scrolling, the scroller may "bounce" when reaching the edge of the
 * content object. This is a visual way to indicate the end has been reached.
 * This is enabled by default for both axes. This API will determine if it's
 * enabled for the given axis with the boolean parameters for each one.
 *
 * @param[in] obj The object.
 * @param[in] horiz Horizontal bounce policy.
 * @param[in] vert Vertical bounce policy.
 *
 * @ingroup Efl_Ui_Scrollable
 */
EOAPI void efl_ui_scrollable_bounce_enabled_set(Eo *obj, Eina_Bool horiz, Eina_Bool vert);

/**
 * @brief Bouncing behavior
 *
 * When scrolling, the scroller may "bounce" when reaching the edge of the
 * content object. This is a visual way to indicate the end has been reached.
 * This is enabled by default for both axes. This API will determine if it's
 * enabled for the given axis with the boolean parameters for each one.
 *
 * @param[in] obj The object.
 * @param[out] horiz Horizontal bounce policy.
 * @param[out] vert Vertical bounce policy.
 *
 * @ingroup Efl_Ui_Scrollable
 */
EOAPI void efl_ui_scrollable_bounce_enabled_get(const Eo *obj, Eina_Bool *horiz, Eina_Bool *vert);

/**
 * @brief Freeze property This function will freeze scrolling movement (by
 * input of a user). Unlike @ref efl_ui_scrollable_movement_block_get, this
 * function freezes bidirectionally. If you want to freeze in only one
 * direction, see @ref efl_ui_scrollable_movement_block_set.
 *
 * @param[in] obj The object.
 * @param[in] freeze @c true if freeze, @c false otherwise
 *
 * @ingroup Efl_Ui_Scrollable
 */
EOAPI void efl_ui_scrollable_scroll_freeze_set(Eo *obj, Eina_Bool freeze);

/**
 * @brief Freeze property This function will freeze scrolling movement (by
 * input of a user). Unlike @ref efl_ui_scrollable_movement_block_get, this
 * function freezes bidirectionally. If you want to freeze in only one
 * direction, see @ref efl_ui_scrollable_movement_block_set.
 *
 * @param[in] obj The object.
 *
 * @return @c true if freeze, @c false otherwise
 *
 * @ingroup Efl_Ui_Scrollable
 */
EOAPI Eina_Bool efl_ui_scrollable_scroll_freeze_get(const Eo *obj);

/**
 * @brief Hold property When hold turns on, it only scrolls by holding action.
 *
 * @param[in] obj The object.
 * @param[in] hold @c true if hold, @c false otherwise
 *
 * @ingroup Efl_Ui_Scrollable
 */
EOAPI void efl_ui_scrollable_scroll_hold_set(Eo *obj, Eina_Bool hold);

/**
 * @brief Hold property When hold turns on, it only scrolls by holding action.
 *
 * @param[in] obj The object.
 *
 * @return @c true if hold, @c false otherwise
 *
 * @ingroup Efl_Ui_Scrollable
 */
EOAPI Eina_Bool efl_ui_scrollable_scroll_hold_get(const Eo *obj);

/**
 * @brief Controls an infinite loop for a scroller.
 *
 * @param[in] obj The object.
 * @param[in] loop_h The scrolling horizontal loop
 * @param[in] loop_v The Scrolling vertical loop
 *
 * @ingroup Efl_Ui_Scrollable
 */
EOAPI void efl_ui_scrollable_looping_set(Eo *obj, Eina_Bool loop_h, Eina_Bool loop_v);

/**
 * @brief Controls an infinite loop for a scroller.
 *
 * @param[in] obj The object.
 * @param[out] loop_h The scrolling horizontal loop
 * @param[out] loop_v The Scrolling vertical loop
 *
 * @ingroup Efl_Ui_Scrollable
 */
EOAPI void efl_ui_scrollable_looping_get(const Eo *obj, Eina_Bool *loop_h, Eina_Bool *loop_v);

/**
 * @brief Blocking of scrolling (per axis).
 *
 * This function will block scrolling movement (by input of a user) in a given
 * direction. You can disable movements in the X axis, the Y axis or both. The
 * default value is @ref EFL_UI_LAYOUT_ORIENTATION_DEFAULT meaning that
 * movements are allowed in both directions.
 *
 * @param[in] obj The object.
 * @param[in] block Which axis (or axes) to block
 *
 * @ingroup Efl_Ui_Scrollable
 */
EOAPI void efl_ui_scrollable_movement_block_set(Eo *obj, Efl_Ui_Layout_Orientation block);

/**
 * @brief Blocking of scrolling (per axis).
 *
 * This function will block scrolling movement (by input of a user) in a given
 * direction. You can disable movements in the X axis, the Y axis or both. The
 * default value is @ref EFL_UI_LAYOUT_ORIENTATION_DEFAULT meaning that
 * movements are allowed in both directions.
 *
 * @param[in] obj The object.
 *
 * @return Which axis (or axes) to block
 *
 * @ingroup Efl_Ui_Scrollable
 */
EOAPI Efl_Ui_Layout_Orientation efl_ui_scrollable_movement_block_get(const Eo *obj);

/**
 * @brief Control scrolling gravity on the scrollable
 *
 * The gravity defines how the scroller will adjust its view when the size of
 * the scroller contents increases.
 *
 * The scroller will adjust the view to glue itself as follows:
 * <tt>x=0.0</tt> to stay where it is relative to the left edge of the content.
 * <tt>x=1.0</tt> to stay where it is relative to the right edge of the
 * content. <tt>y=0.0</tt> to stay where it is relative to the top edge of
 * the content. <tt>y=1.0</tt> to stay where it is relative to the bottom
 * edge of the content.
 *
 * @param[in] obj The object.
 * @param[in] x Horizontal scrolling gravity.
 * @param[in] y Vertical scrolling gravity.
 *
 * @ingroup Efl_Ui_Scrollable
 */
EOAPI void efl_ui_scrollable_gravity_set(Eo *obj, double x, double y);

/**
 * @brief Control scrolling gravity on the scrollable
 *
 * The gravity defines how the scroller will adjust its view when the size of
 * the scroller contents increases.
 *
 * The scroller will adjust the view to glue itself as follows:
 * <tt>x=0.0</tt> to stay where it is relative to the left edge of the content.
 * <tt>x=1.0</tt> to stay where it is relative to the right edge of the
 * content. <tt>y=0.0</tt> to stay where it is relative to the top edge of
 * the content. <tt>y=1.0</tt> to stay where it is relative to the bottom
 * edge of the content.
 *
 * @param[in] obj The object.
 * @param[out] x Horizontal scrolling gravity.
 * @param[out] y Vertical scrolling gravity.
 *
 * @ingroup Efl_Ui_Scrollable
 */
EOAPI void efl_ui_scrollable_gravity_get(const Eo *obj, double *x, double *y);

/**
 * @brief Prevent the scrollable from being smaller than the minimum size of
 * the content.
 *
 * By default the scroller will be as small as its design allows, irrespective
 * of its content. This will make the scroller minimum size the right size
 * horizontally and/or vertically to perfectly fit its content in that
 * direction.
 *
 * @param[in] obj The object.
 * @param[in] w Whether to limit the minimum horizontal size
 * @param[in] h Whether to limit the minimum vertical size
 *
 * @ingroup Efl_Ui_Scrollable
 */
EOAPI void efl_ui_scrollable_match_content_set(Eo *obj, Eina_Bool w, Eina_Bool h);

/**
 * @brief Control the step size
 *
 * Use this call to set step size. This value is used when scroller scroll by
 * arrow key event.
 *
 * @param[in] obj The object.
 * @param[in] step The step size in pixels
 *
 * @ingroup Efl_Ui_Scrollable
 */
EOAPI void efl_ui_scrollable_step_size_set(Eo *obj, Eina_Position2D step);

/**
 * @brief Control the step size
 *
 * Use this call to set step size. This value is used when scroller scroll by
 * arrow key event.
 *
 * @param[in] obj The object.
 *
 * @return The step size in pixels
 *
 * @ingroup Efl_Ui_Scrollable
 */
EOAPI Eina_Position2D efl_ui_scrollable_step_size_get(const Eo *obj);

/**
 * @brief Show a specific virtual region within the scroller content object.
 *
 * This will ensure all (or part if it does not fit) of the designated region
 * in the virtual content object (0, 0 starting at the top-left of the virtual
 * content object) is shown within the scroller. This allows the scroller to
 * "smoothly slide" to this location (if configuration in general calls for
 * transitions). It may not jump immediately to the new location and make take
 * a while and show other content along the way.
 *
 * @param[in] obj The object.
 * @param[in] rect The position where to scroll. and The size user want to see
 * @param[in] animation Whether to scroll with animation or not
 *
 * @ingroup Efl_Ui_Scrollable
 */
EOAPI void efl_ui_scrollable_scroll(Eo *obj, Eina_Rect rect, Eina_Bool animation);

EWAPI extern const Efl_Event_Description _EFL_UI_EVENT_SCROLL_STARTED;

/** Called when scroll operation starts
 *
 * @ingroup Efl_Ui_Scrollable
 */
#define EFL_UI_EVENT_SCROLL_STARTED (&(_EFL_UI_EVENT_SCROLL_STARTED))

EWAPI extern const Efl_Event_Description _EFL_UI_EVENT_SCROLL_CHANGED;

/** Called when scrolling
 *
 * @ingroup Efl_Ui_Scrollable
 */
#define EFL_UI_EVENT_SCROLL_CHANGED (&(_EFL_UI_EVENT_SCROLL_CHANGED))

EWAPI extern const Efl_Event_Description _EFL_UI_EVENT_SCROLL_FINISHED;

/** Called when scroll operation finishes
 *
 * @ingroup Efl_Ui_Scrollable
 */
#define EFL_UI_EVENT_SCROLL_FINISHED (&(_EFL_UI_EVENT_SCROLL_FINISHED))

EWAPI extern const Efl_Event_Description _EFL_UI_EVENT_SCROLL_UP;

/** Called when scrolling upwards
 *
 * @ingroup Efl_Ui_Scrollable
 */
#define EFL_UI_EVENT_SCROLL_UP (&(_EFL_UI_EVENT_SCROLL_UP))

EWAPI extern const Efl_Event_Description _EFL_UI_EVENT_SCROLL_DOWN;

/** Called when scrolling downwards
 *
 * @ingroup Efl_Ui_Scrollable
 */
#define EFL_UI_EVENT_SCROLL_DOWN (&(_EFL_UI_EVENT_SCROLL_DOWN))

EWAPI extern const Efl_Event_Description _EFL_UI_EVENT_SCROLL_LEFT;

/** Called when scrolling left
 *
 * @ingroup Efl_Ui_Scrollable
 */
#define EFL_UI_EVENT_SCROLL_LEFT (&(_EFL_UI_EVENT_SCROLL_LEFT))

EWAPI extern const Efl_Event_Description _EFL_UI_EVENT_SCROLL_RIGHT;

/** Called when scrolling right
 *
 * @ingroup Efl_Ui_Scrollable
 */
#define EFL_UI_EVENT_SCROLL_RIGHT (&(_EFL_UI_EVENT_SCROLL_RIGHT))

EWAPI extern const Efl_Event_Description _EFL_UI_EVENT_EDGE_UP;

/** Called when hitting the top edge
 *
 * @ingroup Efl_Ui_Scrollable
 */
#define EFL_UI_EVENT_EDGE_UP (&(_EFL_UI_EVENT_EDGE_UP))

EWAPI extern const Efl_Event_Description _EFL_UI_EVENT_EDGE_DOWN;

/** Called when hitting the bottom edge
 *
 * @ingroup Efl_Ui_Scrollable
 */
#define EFL_UI_EVENT_EDGE_DOWN (&(_EFL_UI_EVENT_EDGE_DOWN))

EWAPI extern const Efl_Event_Description _EFL_UI_EVENT_EDGE_LEFT;

/** Called when hitting the left edge
 *
 * @ingroup Efl_Ui_Scrollable
 */
#define EFL_UI_EVENT_EDGE_LEFT (&(_EFL_UI_EVENT_EDGE_LEFT))

EWAPI extern const Efl_Event_Description _EFL_UI_EVENT_EDGE_RIGHT;

/** Called when hitting the right edge
 *
 * @ingroup Efl_Ui_Scrollable
 */
#define EFL_UI_EVENT_EDGE_RIGHT (&(_EFL_UI_EVENT_EDGE_RIGHT))

EWAPI extern const Efl_Event_Description _EFL_UI_EVENT_SCROLL_ANIM_STARTED;

/** Called when scroll animation starts
 *
 * @ingroup Efl_Ui_Scrollable
 */
#define EFL_UI_EVENT_SCROLL_ANIM_STARTED (&(_EFL_UI_EVENT_SCROLL_ANIM_STARTED))

EWAPI extern const Efl_Event_Description _EFL_UI_EVENT_SCROLL_ANIM_FINISHED;

/** Called when scroll animation finishes
 *
 * @ingroup Efl_Ui_Scrollable
 */
#define EFL_UI_EVENT_SCROLL_ANIM_FINISHED (&(_EFL_UI_EVENT_SCROLL_ANIM_FINISHED))

EWAPI extern const Efl_Event_Description _EFL_UI_EVENT_SCROLL_DRAG_STARTED;

/** Called when scroll drag starts
 *
 * @ingroup Efl_Ui_Scrollable
 */
#define EFL_UI_EVENT_SCROLL_DRAG_STARTED (&(_EFL_UI_EVENT_SCROLL_DRAG_STARTED))

EWAPI extern const Efl_Event_Description _EFL_UI_EVENT_SCROLL_DRAG_FINISHED;

/** Called when scroll drag finishes
 *
 * @ingroup Efl_Ui_Scrollable
 */
#define EFL_UI_EVENT_SCROLL_DRAG_FINISHED (&(_EFL_UI_EVENT_SCROLL_DRAG_FINISHED))

#endif
