#ifndef _EFL_INTERPOLATOR_EO_H_
#define _EFL_INTERPOLATOR_EO_H_

#ifndef _EFL_INTERPOLATOR_EO_CLASS_TYPE
#define _EFL_INTERPOLATOR_EO_CLASS_TYPE

typedef Eo Efl_Interpolator;

#endif

#ifndef _EFL_INTERPOLATOR_EO_TYPES
#define _EFL_INTERPOLATOR_EO_TYPES


#endif
#ifdef EFL_BETA_API_SUPPORT
/** Efl interpolator interface
 *
 * @ingroup Efl_Interpolator
 */
#define EFL_INTERPOLATOR_INTERFACE efl_interpolator_interface_get()

EWAPI const Efl_Class *efl_interpolator_interface_get(void);

/**
 * @brief Interpolate the given value.
 *
 * @param[in] obj The object.
 * @param[in] progress Input value mapped from 0.0 to 1.0.
 *
 * @return Output value calculated by interpolating the input value.
 *
 * @ingroup Efl_Interpolator
 */
EOAPI double efl_interpolator_interpolate(Eo *obj, double progress);
#endif /* EFL_BETA_API_SUPPORT */

#endif
