/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.results;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.RowFilter;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.ui.swing.FilterUtils;
import org.netbeans.lib.profiler.ui.swing.ProfilerTable;
import org.netbeans.lib.profiler.ui.swing.ProfilerTreeTable;
import org.netbeans.lib.profiler.ui.swing.SearchUtils;
import org.openide.util.Lookup;

public abstract class DataView
extends JPanel {
    private JComponent bottomPanel;
    private JComponent filterPanel;
    private JComponent searchPanel;

    protected DataView() {
        super(new BorderLayout());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SearchUtils.enableSearchActions(DataView.this.getResultsComponent());
            }
        });
    }

    protected abstract ProfilerTable getResultsComponent();

    public final JMenuItem createCopyMenuItem() {
        return this.getResultsComponent().createCopyMenuItem();
    }

    public final JMenuItem[] createCustomMenuItems(JComponent jComponent, Object object, ClientUtils.SourceCodeSelection sourceCodeSelection) {
        Collection collection = Lookup.getDefault().lookupAll(PopupCustomizer.class);
        if (collection.isEmpty()) {
            return null;
        }
        ArrayList arrayList = new ArrayList(collection.size());
        for (PopupCustomizer popupCustomizer : collection) {
            JMenuItem[] jMenuItemArray = popupCustomizer.getMenuItems(jComponent, this, object, sourceCodeSelection);
            if (jMenuItemArray == null) continue;
            Collections.addAll(arrayList, jMenuItemArray);
        }
        return arrayList.isEmpty() ? null : arrayList.toArray(new JMenuItem[0]);
    }

    public void notifyOnFocus(final Runnable runnable) {
        this.getResultsComponent().addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                runnable.run();
            }
        });
    }

    protected void installDefaultAction() {
        this.getResultsComponent().setDefaultAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = DataView.this.getResultsComponent().getSelectedRow();
                ClientUtils.SourceCodeSelection sourceCodeSelection = DataView.this.getUserValueForRow(n);
                if (sourceCodeSelection != null) {
                    DataView.this.performDefaultAction(sourceCodeSelection);
                }
            }
        });
    }

    protected void performDefaultAction(ClientUtils.SourceCodeSelection sourceCodeSelection) {
    }

    protected ClientUtils.SourceCodeSelection getUserValueForRow(int n) {
        return null;
    }

    protected RowFilter getExcludesFilter() {
        return null;
    }

    protected Component[] getFilterOptions() {
        return null;
    }

    protected void enableFilter() {
        Object object;
        if (this.filterPanel != null && (object = this.filterPanel.getClientProperty("SET_FILTER_CHANGED")) instanceof Action) {
            ((Action)object).actionPerformed(null);
        }
    }

    public void activateFilter() {
        JComponent jComponent = this.getBottomPanel();
        if (this.filterPanel == null) {
            this.filterPanel = FilterUtils.createFilterPanel(this.getResultsComponent(), this.getExcludesFilter(), this.getFilterOptions());
            jComponent.add(this.filterPanel);
            Container container = jComponent.getParent();
            container.invalidate();
            container.revalidate();
            container.repaint();
        }
        jComponent.setVisible(true);
        this.filterPanel.setVisible(true);
        this.filterPanel.requestFocusInWindow();
    }

    protected SearchUtils.TreeHelper getSearchHelper() {
        return null;
    }

    protected Component[] getSearchOptions() {
        return null;
    }

    public void activateSearch() {
        JComponent jComponent = this.getBottomPanel();
        if (this.searchPanel == null) {
            SearchUtils.TreeHelper treeHelper = this.getSearchHelper();
            this.searchPanel = treeHelper == null ? SearchUtils.createSearchPanel(this.getResultsComponent(), this.getSearchOptions()) : SearchUtils.createSearchPanel((ProfilerTreeTable)this.getResultsComponent(), treeHelper, this.getSearchOptions());
            jComponent.add(this.searchPanel);
            Container container = jComponent.getParent();
            container.invalidate();
            container.revalidate();
            container.repaint();
        }
        jComponent.setVisible(true);
        this.searchPanel.setVisible(true);
        this.searchPanel.requestFocusInWindow();
    }

    protected boolean hasBottomFilterFindMargin() {
        return false;
    }

    protected void addFilterFindPanel(JComponent jComponent) {
        this.add((Component)jComponent, "South");
    }

    private JComponent getBottomPanel() {
        if (this.bottomPanel == null) {
            this.bottomPanel = new JPanel(new FilterFindLayout());
            this.bottomPanel.setOpaque(true);
            this.bottomPanel.setBackground(UIManager.getColor("controlShadow"));
            this.addFilterFindPanel(this.bottomPanel);
        }
        return this.bottomPanel;
    }

    public static abstract class PopupCustomizer {
        public abstract JMenuItem[] getMenuItems(JComponent var1, DataView var2, Object var3, ClientUtils.SourceCodeSelection var4);
    }

    private final class FilterFindLayout
    implements LayoutManager {
        private FilterFindLayout() {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            JComponent jComponent;
            JComponent jComponent2 = DataView.this.filterPanel;
            if (jComponent2 != null && !jComponent2.isVisible()) {
                jComponent2 = null;
            }
            if ((jComponent = DataView.this.searchPanel) != null && !jComponent.isVisible()) {
                jComponent = null;
            }
            Dimension dimension = new Dimension();
            if (jComponent2 != null && jComponent != null) {
                Dimension dimension2 = jComponent2.getPreferredSize();
                Dimension dimension3 = jComponent.getPreferredSize();
                dimension.width = dimension2.width + dimension3.width + 1;
                dimension.height = Math.max(dimension2.height, dimension3.height);
            } else if (jComponent2 != null) {
                dimension = jComponent2.getPreferredSize();
            } else if (jComponent != null) {
                dimension = jComponent.getPreferredSize();
            }
            if ((jComponent2 != null || jComponent != null) && DataView.this.hasBottomFilterFindMargin()) {
                ++dimension.height;
            }
            return dimension;
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            JComponent jComponent;
            JComponent jComponent2 = DataView.this.filterPanel;
            if (jComponent2 != null && !jComponent2.isVisible()) {
                jComponent2 = null;
            }
            if ((jComponent = DataView.this.searchPanel) != null && !jComponent.isVisible()) {
                jComponent = null;
            }
            Dimension dimension = new Dimension();
            if (jComponent2 != null && jComponent != null) {
                Dimension dimension2 = jComponent2.getMinimumSize();
                Dimension dimension3 = jComponent.getMinimumSize();
                dimension.width = dimension2.width + dimension3.width + 1;
                dimension.height = Math.max(dimension2.height, dimension3.height);
            } else if (jComponent2 != null) {
                dimension = jComponent2.getMinimumSize();
            } else if (jComponent != null) {
                dimension = jComponent.getMinimumSize();
            }
            if ((jComponent2 != null || jComponent != null) && DataView.this.hasBottomFilterFindMargin()) {
                ++dimension.height;
            }
            return dimension;
        }

        @Override
        public void layoutContainer(Container container) {
            int n;
            JComponent jComponent;
            JComponent jComponent2 = DataView.this.filterPanel;
            if (jComponent2 != null && !jComponent2.isVisible()) {
                jComponent2 = null;
            }
            if ((jComponent = DataView.this.searchPanel) != null && !jComponent.isVisible()) {
                jComponent = null;
            }
            int n2 = n = DataView.this.hasBottomFilterFindMargin() ? 1 : 0;
            if (jComponent2 != null && jComponent != null) {
                Dimension dimension = container.getSize();
                int n3 = (dimension.width - 1) / 2;
                jComponent2.setBounds(0, 0, n3, dimension.height - n);
                jComponent.setBounds(n3 + 1, 0, dimension.width - n3 - 1, dimension.height - n);
            } else if (jComponent2 != null) {
                Dimension dimension = container.getSize();
                jComponent2.setBounds(0, 0, dimension.width, dimension.height - n);
            } else if (jComponent != null) {
                Dimension dimension = container.getSize();
                jComponent.setBounds(0, 0, dimension.width, dimension.height - n);
            }
        }
    }
}

