/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.adapter;

import com.sun.star.io.BufferSizeExceededException;
import com.sun.star.io.IOException;
import com.sun.star.io.NotConnectedException;
import com.sun.star.io.XOutputStream;
import com.sun.star.lib.uno.helper.ComponentBase;

public final class XOutputStreamToByteArrayAdapter
extends ComponentBase
implements XOutputStream {
    private static final int initialSize = 100240;
    private int size = 0;
    private int position = 0;
    private boolean externalBuffer = false;
    private byte[] buffer;

    public XOutputStreamToByteArrayAdapter() {
        this(null);
    }

    public XOutputStreamToByteArrayAdapter(byte[] aBuffer) {
        if (aBuffer != null) {
            this.externalBuffer = true;
            this.buffer = aBuffer;
            this.size = this.buffer.length;
        } else {
            this.size = 100240;
            this.buffer = new byte[this.size];
        }
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public void closeOutput() throws NotConnectedException, BufferSizeExceededException, IOException {
        if (this.buffer.length > this.position && !this.externalBuffer) {
            byte[] newBuffer = new byte[this.position];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.position);
            this.buffer = newBuffer;
        }
    }

    public void flush() throws NotConnectedException, BufferSizeExceededException, IOException {
    }

    public void writeBytes(byte[] values) throws NotConnectedException, BufferSizeExceededException, IOException {
        if (values.length > this.size - this.position) {
            if (this.externalBuffer) {
                throw new BufferSizeExceededException("out of buffer space, cannot grow external buffer");
            }
            while (values.length > this.size - this.position) {
                this.size *= 2;
            }
            byte[] newBuffer = new byte[this.size];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.position);
            this.buffer = newBuffer;
        }
        System.arraycopy(values, 0, this.buffer, this.position, values.length);
        this.position += values.length;
    }
}

