#ifndef _EFL_CANVAS_GESTURE_RECOGNIZER_EO_H_
#define _EFL_CANVAS_GESTURE_RECOGNIZER_EO_H_

#ifndef _EFL_CANVAS_GESTURE_RECOGNIZER_EO_CLASS_TYPE
#define _EFL_CANVAS_GESTURE_RECOGNIZER_EO_CLASS_TYPE

typedef Eo Efl_Canvas_Gesture_Recognizer;

#endif

#ifndef _EFL_CANVAS_GESTURE_RECOGNIZER_EO_TYPES
#define _EFL_CANVAS_GESTURE_RECOGNIZER_EO_TYPES


#endif
#ifdef EFL_BETA_API_SUPPORT
/**
 * @brief Base abstract class for Gesture Recognizers. For internal use only.
 *
 * Gesture recognizers listen to events that occur on a target object to see if
 * a particular gesture has occurred.
 *
 * Recognizer-specific configuration values can be modified through
 * @ref efl_gesture_recognizer_config_get. Default configuration values are
 * taken from the system's configuration.
 *
 * @ingroup Efl_Canvas_Gesture_Recognizer
 */
#define EFL_CANVAS_GESTURE_RECOGNIZER_CLASS efl_canvas_gesture_recognizer_class_get()

EWAPI const Efl_Class *efl_canvas_gesture_recognizer_class_get(void);

/**
 * @brief This function is called to create a new @ref Efl_Canvas_Gesture
 * object for the given target.
 *
 * @param[in] obj The object.
 * @param[in] target The target canvas object.
 *
 * @return Returns the gesture object that will be used to track this gesture.
 *
 * @ingroup Efl_Canvas_Gesture_Recognizer
 */
EOAPI Efl_Canvas_Gesture *efl_gesture_recognizer_add(Eo *obj, Efl_Object *target);

/**
 * @brief Analyzes the given @c event and the current state of the @c gesture
 * object to see if the state has to be modified. For example, to signal a
 * complete gesture detection.
 *
 * Updates the state of the gesture object as required, and returns a suitable
 * result for the current recognition step.
 *
 * @param[in] obj The object.
 * @param[in] gesture The gesture object.
 * @param[in] watched The target canvas object.
 * @param[in] event The pointer event being analyzed.
 *
 * @return Returns the result of the analysis.
 *
 * @ingroup Efl_Canvas_Gesture_Recognizer
 */
EOAPI Efl_Canvas_Gesture_Recognizer_Result efl_gesture_recognizer_recognize(Eo *obj, Efl_Canvas_Gesture *gesture, Efl_Object *watched, Efl_Canvas_Gesture_Touch *event);

/**
 * @brief This function is called by the framework to reset a given gesture.
 *
 * @param[in] obj The object.
 * @param[in] gesture The gesture object.
 *
 * @ingroup Efl_Canvas_Gesture_Recognizer
 */
EOAPI void efl_gesture_recognizer_reset(Eo *obj, Efl_Canvas_Gesture *gesture);

/**
 * @brief This property holds configuration values for the recognizer.
 *
 * @param[in] obj The object.
 * @param[in] name Property name.
 *
 * @return Value of the property.
 *
 * @ingroup Efl_Canvas_Gesture_Recognizer
 */
EOAPI Eina_Value *efl_gesture_recognizer_config_get(const Eo *obj, const char *name);
#endif /* EFL_BETA_API_SUPPORT */

#endif
