
/*
 * Copyright (C) 2010-2016 Oracle Corporation
 *
 * This file is part of the VirtualBox SDK, as available from
 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * IGuestProcessRegisteredEvent.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_6_0;

import org.virtualbox_6_0.jaxws.*;
import javax.xml.ws.*;
import java.util.List;


/**
Notification when a guest process was registered or unregistered.

Interface ID: <tt>{1D89E2B3-C6EA-45B6-9D43-DC6F70CC9F02}</tt>
*/
public class IGuestProcessRegisteredEvent extends IGuestProcessEvent
{

    public IGuestProcessRegisteredEvent(String wrapped, ObjectRefManager objMgr, VboxPortType port)
    {
        super(wrapped, objMgr, port);
    }

/**
If  true, the guest process was registered, otherwise it was
unregistered.
@return Boolean
*/
    public Boolean getRegistered()
    {
        try
        {
            Boolean retVal = port.iGuestProcessRegisteredEventGetRegistered(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }
    public static IGuestProcessRegisteredEvent queryInterface(IUnknown obj)
    {
        return obj == null ?  null : new IGuestProcessRegisteredEvent(obj.getWrapped(), obj.getObjMgr(), obj.getRemoteWSPort());
    }
}
