
/*
 * Copyright (C) 2010-2016 Oracle Corporation
 *
 * This file is part of the VirtualBox SDK, as available from
 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * IGuestProcessIOEvent.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_6_0;

import org.virtualbox_6_0.jaxws.*;
import javax.xml.ws.*;
import java.util.List;


/**
Base abstract interface for all guest process input/output (IO) events.

Interface ID: <tt>{9EA9227C-E9BB-49B3-BFC7-C5171E93EF38}</tt>
*/
public class IGuestProcessIOEvent extends IGuestProcessEvent
{

    public IGuestProcessIOEvent(String wrapped, ObjectRefManager objMgr, VboxPortType port)
    {
        super(wrapped, objMgr, port);
    }

/**
Input/output (IO) handle involved in this event. Usually 0 is stdin,
1 is stdout and 2 is stderr.
@return Long
*/
    public Long getHandle()
    {
        try
        {
            Long retVal = port.iGuestProcessIOEventGetHandle(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Processed input or output (in bytes).
@return Long
*/
    public Long getProcessed()
    {
        try
        {
            Long retVal = port.iGuestProcessIOEventGetProcessed(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }
    public static IGuestProcessIOEvent queryInterface(IUnknown obj)
    {
        return obj == null ?  null : new IGuestProcessIOEvent(obj.getWrapped(), obj.getObjMgr(), obj.getRemoteWSPort());
    }
}
