/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcsUtil;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.IgnoredFileContentProvider;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.history.ShortVcsRevisionNumber;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.PersistentFSConstants;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThrowableConvertor;
import com.intellij.vcsUtil.VcsRunnable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsUtil {
    protected static final char[] ourCharsToBeChopped = new char[]{'/', '\\'};
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.vcsUtil.VcsUtil");
    public static final String MAX_VCS_LOADED_SIZE_KB = "idea.max.vcs.loaded.size.kb";
    private static final int ourMaxLoadedFileSize = VcsUtil.computeLoadedFileSize();
    @NotNull
    private static final VcsRoot FICTIVE_ROOT = new VcsRoot(null, null);
    private static final int MAX_COMMIT_MESSAGE_LENGTH = 50000;
    private static final int MAX_COMMIT_MESSAGE_LINES = 3000;
    private static final String ANNO_ASPECT = "show.vcs.annotation.aspect.";

    public static int getMaxVcsLoadedFileSize() {
        return ourMaxLoadedFileSize;
    }

    private static int computeLoadedFileSize() {
        int result = (int)PersistentFSConstants.FILE_LENGTH_TO_CACHE_THRESHOLD;
        String userLimitKb = System.getProperty(MAX_VCS_LOADED_SIZE_KB);
        try {
            return userLimitKb != null ? Integer.parseInt(userLimitKb) * 1024 : result;
        }
        catch (NumberFormatException ignored) {
            return result;
        }
    }

    @Deprecated
    public static void markFileAsDirty(Project project, VirtualFile file) {
        VcsDirtyScopeManager.getInstance(project).fileDirty(file);
    }

    @Deprecated
    public static void markFileAsDirty(Project project, FilePath path2) {
        VcsDirtyScopeManager.getInstance(project).fileDirty(path2);
    }

    public static void markFileAsDirty(Project project, String path2) {
        FilePath filePath2 = VcsContextFactory.SERVICE.getInstance().createFilePathOn(new File(path2));
        VcsDirtyScopeManager.getInstance(project).fileDirty(filePath2);
    }

    @Deprecated
    public static void refreshFiles(Project project, HashSet<? extends FilePath> paths) {
        for (FilePath filePath2 : paths) {
            VirtualFile vFile = filePath2.getVirtualFile();
            if (vFile == null) continue;
            if (vFile.isDirectory()) {
                VcsUtil.markFileAsDirty(project, vFile);
                continue;
            }
            vFile.refresh(true, vFile.isDirectory());
        }
    }

    public static boolean isFileUnderVcs(Project project, String file) {
        return VcsUtil.getVcsFor(project, VcsUtil.getFilePath(file)) != null;
    }

    public static boolean isFileUnderVcs(Project project, FilePath file) {
        return VcsUtil.getVcsFor(project, file) != null;
    }

    public static boolean isFileForVcs(@NotNull VirtualFile file, Project project, AbstractVcs host) {
        if (file == null) {
            VcsUtil.$$$reportNull$$$0(0);
        }
        return VcsUtil.getVcsFor(project, file) == host;
    }

    public static boolean isFileForVcs(FilePath path2, Project project, AbstractVcs host) {
        return VcsUtil.getVcsFor(project, path2) == host;
    }

    public static boolean isFileForVcs(String path2, Project project, AbstractVcs host) {
        return VcsUtil.getVcsFor(project, VcsUtil.getFilePath(path2)) == host;
    }

    @Nullable
    public static AbstractVcs getVcsFor(@NotNull Project project, FilePath filePath2) {
        if (project == null) {
            VcsUtil.$$$reportNull$$$0(1);
        }
        return (AbstractVcs)VcsUtil.computeValue(project, manager -> manager.getVcsFor(filePath2));
    }

    @Nullable
    public static AbstractVcs getVcsFor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            VcsUtil.$$$reportNull$$$0(2);
        }
        if (file == null) {
            VcsUtil.$$$reportNull$$$0(3);
        }
        return (AbstractVcs)VcsUtil.computeValue(project, manager -> manager.getVcsFor(file));
    }

    @Nullable
    public static AbstractVcs findVcsByKey(@NotNull Project project, @NotNull VcsKey key) {
        if (project == null) {
            VcsUtil.$$$reportNull$$$0(4);
        }
        if (key == null) {
            VcsUtil.$$$reportNull$$$0(5);
        }
        return ProjectLevelVcsManager.getInstance(project).findVcsByName(key.getName());
    }

    @Nullable
    public static AbstractVcs findVcs(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            VcsUtil.$$$reportNull$$$0(6);
        }
        if ((project = e.getProject()) == null) {
            return null;
        }
        VcsKey key = e.getData(VcsDataKeys.VCS);
        if (key == null) {
            return null;
        }
        return VcsUtil.findVcsByKey(project, key);
    }

    @Nullable
    public static VirtualFile getVcsRootFor(@NotNull Project project, FilePath filePath2) {
        if (project == null) {
            VcsUtil.$$$reportNull$$$0(7);
        }
        return (VirtualFile)VcsUtil.computeValue(project, manager -> manager.getVcsRootFor(filePath2));
    }

    @Nullable
    public static VirtualFile getVcsRootFor(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            VcsUtil.$$$reportNull$$$0(8);
        }
        return (VirtualFile)VcsUtil.computeValue(project, manager -> manager.getVcsRootFor(file));
    }

    @Nullable
    private static <T> T computeValue(@NotNull Project project, @NotNull Function<? super ProjectLevelVcsManager, ? extends T> provider) {
        if (project == null) {
            VcsUtil.$$$reportNull$$$0(9);
        }
        if (provider == null) {
            VcsUtil.$$$reportNull$$$0(10);
        }
        return ReadAction.compute(() -> {
            Object result = null;
            if (!project.isDisposed()) {
                ProjectLevelVcsManager manager = ProjectLevelVcsManager.getInstance(project);
                result = manager != null ? provider.fun((Object)manager) : null;
            }
            return result;
        });
    }

    @Nullable
    public static VirtualFile getVirtualFile(@NotNull String path2) {
        if (path2 == null) {
            VcsUtil.$$$reportNull$$$0(11);
        }
        return (VirtualFile)ReadAction.compute(() -> LocalFileSystem.getInstance().findFileByPath(path2.replace(File.separatorChar, '/')));
    }

    @Nullable
    public static VirtualFile getVirtualFile(@NotNull File file) {
        if (file == null) {
            VcsUtil.$$$reportNull$$$0(12);
        }
        return (VirtualFile)ReadAction.compute(() -> LocalFileSystem.getInstance().findFileByIoFile(file));
    }

    @Nullable
    public static VirtualFile getVirtualFileWithRefresh(File file) {
        if (file == null) {
            return null;
        }
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        VirtualFile result = lfs.findFileByIoFile(file);
        if (result == null) {
            result = lfs.refreshAndFindFileByIoFile(file);
        }
        return result;
    }

    public static String getFileContent(@NotNull String path2) {
        if (path2 == null) {
            VcsUtil.$$$reportNull$$$0(13);
        }
        return (String)ReadAction.compute(() -> {
            VirtualFile vFile = VcsUtil.getVirtualFile(path2);
            assert (vFile != null);
            return FileDocumentManager.getInstance().getDocument(vFile).getText();
        });
    }

    @Nullable
    public static byte[] getFileByteContent(@NotNull File file) {
        if (file == null) {
            VcsUtil.$$$reportNull$$$0(14);
        }
        try {
            return FileUtil.loadFileBytes((File)file);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            return null;
        }
    }

    public static FilePath getFilePath(String path2) {
        return VcsUtil.getFilePath(new File(path2));
    }

    public static FilePath getFilePath(@NotNull VirtualFile file) {
        if (file == null) {
            VcsUtil.$$$reportNull$$$0(15);
        }
        return VcsContextFactory.SERVICE.getInstance().createFilePathOn(file);
    }

    public static FilePath getFilePath(@NotNull File file) {
        if (file == null) {
            VcsUtil.$$$reportNull$$$0(16);
        }
        return VcsContextFactory.SERVICE.getInstance().createFilePathOn(file);
    }

    public static FilePath getFilePath(@NotNull String path2, boolean isDirectory) {
        if (path2 == null) {
            VcsUtil.$$$reportNull$$$0(17);
        }
        return VcsContextFactory.SERVICE.getInstance().createFilePath(path2, isDirectory);
    }

    public static FilePath getFilePathOnNonLocal(String path2, boolean isDirectory) {
        return VcsContextFactory.SERVICE.getInstance().createFilePathOnNonLocal(path2, isDirectory);
    }

    public static FilePath getFilePath(@NotNull File file, boolean isDirectory) {
        if (file == null) {
            VcsUtil.$$$reportNull$$$0(18);
        }
        return VcsContextFactory.SERVICE.getInstance().createFilePathOn(file, isDirectory);
    }

    @Deprecated
    public static FilePath getFilePathForDeletedFile(@NotNull String path2, boolean isDirectory) {
        if (path2 == null) {
            VcsUtil.$$$reportNull$$$0(19);
        }
        return VcsContextFactory.SERVICE.getInstance().createFilePathOn(new File(path2), isDirectory);
    }

    @NotNull
    public static FilePath getFilePath(@NotNull VirtualFile parent, @NotNull String name) {
        if (parent == null) {
            VcsUtil.$$$reportNull$$$0(20);
        }
        if (name == null) {
            VcsUtil.$$$reportNull$$$0(21);
        }
        FilePath filePath2 = VcsContextFactory.SERVICE.getInstance().createFilePathOn(parent, name);
        if (filePath2 == null) {
            VcsUtil.$$$reportNull$$$0(22);
        }
        return filePath2;
    }

    @NotNull
    public static FilePath getFilePath(@NotNull VirtualFile parent, @NotNull String fileName, boolean isDirectory) {
        if (parent == null) {
            VcsUtil.$$$reportNull$$$0(23);
        }
        if (fileName == null) {
            VcsUtil.$$$reportNull$$$0(24);
        }
        FilePath filePath2 = VcsContextFactory.SERVICE.getInstance().createFilePath(parent, fileName, isDirectory);
        if (filePath2 == null) {
            VcsUtil.$$$reportNull$$$0(25);
        }
        return filePath2;
    }

    @Deprecated
    public static void showStatusMessage(@NotNull Project project, @Nullable String message) {
        if (project == null) {
            VcsUtil.$$$reportNull$$$0(26);
        }
        SwingUtilities.invokeLater(() -> {
            if (project.isOpen()) {
                StatusBar.Info.set(message, project);
            }
        });
    }

    public static boolean isRenameChange(Change change) {
        boolean isRenamed = false;
        ContentRevision before = change.getBeforeRevision();
        ContentRevision after = change.getAfterRevision();
        if (before != null && after != null) {
            String newFile;
            String prevFile = VcsUtil.getCanonicalLocalPath(before.getFile().getPath());
            isRenamed = !prevFile.equals(newFile = VcsUtil.getCanonicalLocalPath(after.getFile().getPath()));
        }
        return isRenamed;
    }

    public static boolean isChangeForNew(Change change) {
        return change.getBeforeRevision() == null && change.getAfterRevision() != null;
    }

    public static boolean isChangeForDeleted(Change change) {
        return change.getBeforeRevision() != null && change.getAfterRevision() == null;
    }

    public static boolean isChangeForFolder(Change change) {
        ContentRevision revB = change.getBeforeRevision();
        ContentRevision revA = change.getAfterRevision();
        return revA != null && revA.getFile().isDirectory() || revB != null && revB.getFile().isDirectory();
    }

    public static FilePath[] sortPathsFromOutermost(FilePath[] files) {
        return VcsUtil.sortPaths(files, 1);
    }

    private static FilePath[] sortPaths(FilePath[] files, int sign) {
        Arrays.sort(files, (file1, file2) -> sign * file1.getPath().compareTo(file2.getPath()));
        return files;
    }

    @Nullable
    public static VirtualFile getOneVirtualFile(@NotNull AnActionEvent e) {
        VirtualFile[] files;
        if (e == null) {
            VcsUtil.$$$reportNull$$$0(27);
        }
        return (files = VcsUtil.getVirtualFiles(e)).length != 1 ? null : files[0];
    }

    @NotNull
    public static VirtualFile[] getVirtualFiles(@NotNull AnActionEvent e) {
        VirtualFile[] files;
        if (e == null) {
            VcsUtil.$$$reportNull$$$0(28);
        }
        VirtualFile[] virtualFileArray = (files = e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY)) == null ? VirtualFile.EMPTY_ARRAY : files;
        if (virtualFileArray == null) {
            VcsUtil.$$$reportNull$$$0(29);
        }
        return virtualFileArray;
    }

    public static void collectFiles(final VirtualFile dir, final List<? super VirtualFile> files, final boolean recursive, final boolean addDirectories) {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException(VcsBundle.message("exception.text.file.should.be.directory", dir.getPresentableUrl()));
        }
        final FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        VfsUtilCore.visitChildrenRecursively(dir, new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            @Override
            public boolean visitFile(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (file.isDirectory()) {
                    if (addDirectories) {
                        files.add(file);
                    }
                    if (!recursive && !Comparing.equal((Object)file, (Object)dir)) {
                        return false;
                    }
                } else if (fileTypeManager == null || file.getFileType() != FileTypes.UNKNOWN) {
                    files.add(file);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/vcsUtil/VcsUtil$1", "visitFile"));
            }
        });
    }

    @Deprecated
    public static boolean runVcsProcessWithProgress(@NotNull VcsRunnable runnable, @NotNull String progressTitle, boolean canBeCanceled, @Nullable Project project) throws VcsException {
        if (runnable == null) {
            VcsUtil.$$$reportNull$$$0(30);
        }
        if (progressTitle == null) {
            VcsUtil.$$$reportNull$$$0(31);
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            Ref ex = new Ref();
            boolean result = ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                try {
                    runnable.run();
                }
                catch (VcsException e) {
                    ex.set((Object)e);
                }
            }, progressTitle, canBeCanceled, project);
            if (!ex.isNull()) {
                throw (VcsException)ex.get();
            }
            return result;
        }
        runnable.run();
        return true;
    }

    public static <T> T computeWithModalProgress(@Nullable Project project, @NotNull String title, boolean canBeCancelled, final @NotNull ThrowableConvertor<? super ProgressIndicator, T, ? extends VcsException> computable) throws VcsException {
        if (title == null) {
            VcsUtil.$$$reportNull$$$0(32);
        }
        if (computable == null) {
            VcsUtil.$$$reportNull$$$0(33);
        }
        return ProgressManager.getInstance().run(new Task.WithResult<T, VcsException>(project, title, canBeCancelled){

            @Override
            protected T compute(@NotNull ProgressIndicator indicator) throws VcsException {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                return computable.convert((Object)indicator);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/vcsUtil/VcsUtil$2", "compute"));
            }
        });
    }

    @Deprecated
    @Nullable
    public static VirtualFile waitForTheFile(@NotNull String path2) {
        if (path2 == null) {
            VcsUtil.$$$reportNull$$$0(34);
        }
        return LocalFileSystem.getInstance().refreshAndFindFileByPath(path2);
    }

    public static String getCanonicalLocalPath(String localPath) {
        if ((localPath = VcsUtil.chopTrailingChars(localPath.trim().replace('\\', '/'), ourCharsToBeChopped)).length() == 2 && localPath.charAt(1) == ':') {
            localPath = localPath + '/';
        }
        return localPath;
    }

    public static String getCanonicalPath(String path2) {
        String canonPath;
        try {
            canonPath = new File(path2).getCanonicalPath();
        }
        catch (IOException e) {
            canonPath = path2;
        }
        return canonPath;
    }

    public static String getCanonicalPath(File file) {
        String canonPath;
        try {
            canonPath = file.getCanonicalPath();
        }
        catch (IOException e) {
            canonPath = file.getAbsolutePath();
        }
        return canonPath;
    }

    public static String chopTrailingChars(String source, char[] chars) {
        boolean atLeastOneCharWasChopped;
        StringBuilder sb = new StringBuilder(source);
        do {
            atLeastOneCharWasChopped = false;
            for (int i = 0; i < chars.length && sb.length() > 0; ++i) {
                if (sb.charAt(sb.length() - 1) != chars[i]) continue;
                sb.deleteCharAt(sb.length() - 1);
                atLeastOneCharWasChopped = true;
            }
        } while (atLeastOneCharWasChopped);
        return sb.toString();
    }

    public static String getShortRevisionString(@NotNull VcsRevisionNumber revision) {
        if (revision == null) {
            VcsUtil.$$$reportNull$$$0(35);
        }
        return revision instanceof ShortVcsRevisionNumber ? ((ShortVcsRevisionNumber)revision).toShortString() : revision.asString();
    }

    public static VirtualFile[] paths2VFiles(String[] paths) {
        VirtualFile[] files = new VirtualFile[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            files[i] = VcsUtil.getVirtualFile(paths[i]);
        }
        return files;
    }

    public static boolean isAspectAvailableByDefault(String id) {
        return VcsUtil.isAspectAvailableByDefault(id, true);
    }

    public static boolean isAspectAvailableByDefault(@Nullable String id, boolean defaultValue) {
        if (id == null) {
            return false;
        }
        return PropertiesComponent.getInstance().getBoolean(ANNO_ASPECT + id, defaultValue);
    }

    public static void setAspectAvailability(String aspectID, boolean showByDefault) {
        PropertiesComponent.getInstance().setValue(ANNO_ASPECT + aspectID, String.valueOf(showByDefault));
    }

    public static boolean isPathRemote(String path2) {
        int idx = path2.indexOf("://");
        if (idx == -1) {
            int idx2 = path2.indexOf(":\\\\");
            if (idx2 == -1) {
                return false;
            }
            return idx2 > 0;
        }
        return idx > 0;
    }

    public static String getPathForProgressPresentation(@NotNull File file) {
        if (file == null) {
            VcsUtil.$$$reportNull$$$0(36);
        }
        return file.getName() + " (" + file.getParent() + ")";
    }

    @NotNull
    public static <T> Map<VcsRoot, List<T>> groupByRoots(@NotNull Project project, @NotNull Collection<? extends T> items, @NotNull Function<? super T, ? extends FilePath> filePathMapper) {
        if (project == null) {
            VcsUtil.$$$reportNull$$$0(37);
        }
        if (items == null) {
            VcsUtil.$$$reportNull$$$0(38);
        }
        if (filePathMapper == null) {
            VcsUtil.$$$reportNull$$$0(39);
        }
        ProjectLevelVcsManager manager = ProjectLevelVcsManager.getInstance(project);
        Map<VcsRoot, List<T>> map = items.stream().collect(Collectors.groupingBy(item -> (VcsRoot)ObjectUtils.notNull((Object)manager.getVcsRootObjectFor((FilePath)filePathMapper.fun(item)), (Object)FICTIVE_ROOT)));
        if (map == null) {
            VcsUtil.$$$reportNull$$$0(40);
        }
        return map;
    }

    @NotNull
    public static List<VcsDirectoryMapping> addMapping(@NotNull List<? extends VcsDirectoryMapping> existingMappings, @NotNull String path2, @NotNull String vcs) {
        if (existingMappings == null) {
            VcsUtil.$$$reportNull$$$0(41);
        }
        if (path2 == null) {
            VcsUtil.$$$reportNull$$$0(42);
        }
        if (vcs == null) {
            VcsUtil.$$$reportNull$$$0(43);
        }
        ArrayList<VcsDirectoryMapping> mappings = new ArrayList<VcsDirectoryMapping>(existingMappings);
        Iterator iterator = mappings.iterator();
        while (iterator.hasNext()) {
            VcsDirectoryMapping mapping = (VcsDirectoryMapping)iterator.next();
            if (mapping.isDefaultMapping() && StringUtil.isEmptyOrSpaces((String)mapping.getVcs())) {
                LOG.debug("Removing <Project> -> <None> mapping");
                iterator.remove();
                continue;
            }
            if (!FileUtil.pathsEqual((String)mapping.getDirectory(), (String)path2)) continue;
            if (!StringUtil.isEmptyOrSpaces((String)mapping.getVcs())) {
                LOG.warn("Substituting existing mapping [" + path2 + "] -> [" + mapping.getVcs() + "] with [" + vcs + "]");
            } else {
                LOG.debug("Removing [" + path2 + "] -> <None> mapping");
            }
            iterator.remove();
        }
        mappings.add(new VcsDirectoryMapping(path2, vcs));
        ArrayList<VcsDirectoryMapping> arrayList = mappings;
        if (arrayList == null) {
            VcsUtil.$$$reportNull$$$0(44);
        }
        return arrayList;
    }

    @NotNull
    public static FilePath getLastCommitPath(@NotNull Project project, @NotNull FilePath path2) {
        if (project == null) {
            VcsUtil.$$$reportNull$$$0(45);
        }
        if (path2 == null) {
            VcsUtil.$$$reportNull$$$0(46);
        }
        if (project.isDefault()) {
            FilePath filePath2 = path2;
            if (filePath2 == null) {
                VcsUtil.$$$reportNull$$$0(47);
            }
            return filePath2;
        }
        Change change = ChangeListManager.getInstance(project).getChange(path2);
        if (change == null || change.getType() != Change.Type.MOVED || change.getBeforeRevision() == null) {
            FilePath filePath3 = path2;
            if (filePath3 == null) {
                VcsUtil.$$$reportNull$$$0(48);
            }
            return filePath3;
        }
        FilePath filePath4 = change.getBeforeRevision().getFile();
        if (filePath4 == null) {
            VcsUtil.$$$reportNull$$$0(49);
        }
        return filePath4;
    }

    @NotNull
    public static Set<String> getVcsIgnoreFileNames(@NotNull Project project) {
        if (project == null) {
            VcsUtil.$$$reportNull$$$0(50);
        }
        Set<String> set = IgnoredFileContentProvider.IGNORE_FILE_CONTENT_PROVIDER.extensions((AreaInstance)project).map(IgnoredFileContentProvider::getFileName).collect(Collectors.toSet());
        if (set == null) {
            VcsUtil.$$$reportNull$$$0(51);
        }
        return set;
    }

    @NotNull
    public static String trimCommitMessageToSaneSize(@NotNull String message) {
        int nthLine;
        if (message == null) {
            VcsUtil.$$$reportNull$$$0(52);
        }
        if ((nthLine = VcsUtil.nthIndexOf(message, '\n', 3000)) != -1 && nthLine < 50000) {
            String string = VcsUtil.trimCommitMessageAt(message, nthLine);
            if (string == null) {
                VcsUtil.$$$reportNull$$$0(53);
            }
            return string;
        }
        if (message.length() > 50050) {
            String string = VcsUtil.trimCommitMessageAt(message, 50000);
            if (string == null) {
                VcsUtil.$$$reportNull$$$0(54);
            }
            return string;
        }
        String string = message;
        if (string == null) {
            VcsUtil.$$$reportNull$$$0(55);
        }
        return string;
    }

    private static String trimCommitMessageAt(@NotNull String message, int index) {
        if (message == null) {
            VcsUtil.$$$reportNull$$$0(56);
        }
        return String.format("%s\n\n... Commit message is too long and was truncated by %s ...", message.substring(0, index), ApplicationNamesInfo.getInstance().getProductName());
    }

    private static int nthIndexOf(@NotNull String text, char c, int n) {
        if (text == null) {
            VcsUtil.$$$reportNull$$$0(57);
        }
        assert (n > 0);
        int length = text.length();
        int count = 0;
        for (int i = 0; i < length; ++i) {
            if (text.charAt(i) != c || ++count != n) continue;
            return i;
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 22: 
            case 25: 
            case 29: 
            case 40: 
            case 44: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 53: 
            case 54: 
            case 55: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 22: 
            case 25: 
            case 29: 
            case 40: 
            case 44: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 53: 
            case 54: 
            case 55: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 26: 
            case 37: 
            case 45: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 6: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 11: 
            case 13: 
            case 17: 
            case 19: 
            case 34: 
            case 42: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 22: 
            case 25: 
            case 29: 
            case 40: 
            case 44: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 53: 
            case 54: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcsUtil/VcsUtil";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressTitle";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePathMapper";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingMappings";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 52: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcsUtil/VcsUtil";
                break;
            }
            case 22: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePath";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFiles";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "groupByRoots";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "addMapping";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastCommitPath";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcsIgnoreFileNames";
                break;
            }
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "trimCommitMessageToSaneSize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isFileForVcs";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getVcsFor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findVcsByKey";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findVcs";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getVcsRootFor";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "computeValue";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFile";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getFileContent";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFileByteContent";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getFilePath";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getFilePathForDeletedFile";
                break;
            }
            case 22: 
            case 25: 
            case 29: 
            case 40: 
            case 44: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 53: 
            case 54: 
            case 55: {
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "showStatusMessage";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getOneVirtualFile";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFiles";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "runVcsProcessWithProgress";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "computeWithModalProgress";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "waitForTheFile";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getShortRevisionString";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getPathForProgressPresentation";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "groupByRoots";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "addMapping";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getLastCommitPath";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getVcsIgnoreFileNames";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "trimCommitMessageToSaneSize";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "trimCommitMessageAt";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "nthIndexOf";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 22: 
            case 25: 
            case 29: 
            case 40: 
            case 44: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 53: 
            case 54: 
            case 55: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

