/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import java.awt.Component;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.plaf.FontUIResource;

public final class RelativeFont
implements PropertyChangeListener {
    private static final float MULTIPLIER = 1.09f;
    public static final RelativeFont NORMAL = new RelativeFont(null, null, null);
    public static final RelativeFont PLAIN = NORMAL.style(0);
    public static final RelativeFont BOLD = NORMAL.style(1);
    public static final RelativeFont ITALIC = NORMAL.style(2);
    public static final RelativeFont LARGE = NORMAL.large();
    public static final RelativeFont SMALL = NORMAL.small();
    public static final RelativeFont HUGE = LARGE.large();
    public static final RelativeFont TINY = SMALL.small();
    private static final String PROPERTY = "font";
    private final String myFamily;
    private final Integer myStyle;
    private final Float mySize;

    private RelativeFont(String family, Integer style, Float size) {
        this.myFamily = family;
        this.myStyle = style;
        this.mySize = size;
    }

    public RelativeFont family(String family) {
        return family.equals(this.myFamily) ? this : new RelativeFont(family, this.myStyle, this.mySize);
    }

    public RelativeFont style(int style) {
        return null != this.myStyle && this.myStyle == style ? this : new RelativeFont(this.myFamily, style, this.mySize);
    }

    public RelativeFont large() {
        float size = this.mySize == null ? 1.0f : this.mySize.floatValue();
        return new RelativeFont(this.myFamily, this.myStyle, Float.valueOf(size * 1.09f));
    }

    public RelativeFont small() {
        float size = this.mySize == null ? 1.0f : this.mySize.floatValue();
        return new RelativeFont(this.myFamily, this.myStyle, Float.valueOf(size / 1.09f));
    }

    public <T extends Component> T install(T component) {
        Font font = this.derive(component.getFont());
        if (font != null) {
            component.setFont(new MyFont(font));
        }
        RelativeFont.uninstallFrom(component);
        component.addPropertyChangeListener(PROPERTY, this);
        return component;
    }

    public static <T extends Component> T uninstallFrom(T component) {
        for (PropertyChangeListener listener2 : component.getPropertyChangeListeners(PROPERTY)) {
            if (!(listener2 instanceof RelativeFont)) continue;
            component.removePropertyChangeListener(PROPERTY, listener2);
        }
        return component;
    }

    public Font derive(Font font) {
        if (font != null) {
            if (null != this.myFamily && !this.myFamily.equals(font.getFamily(Locale.ENGLISH))) {
                int style = null != this.myStyle ? this.myStyle.intValue() : font.getStyle();
                font = new Font(this.myFamily, style, font.getSize());
            } else if (null != this.myStyle && this.myStyle.intValue() != font.getStyle()) {
                return this.mySize != null ? font.deriveFont((int)this.myStyle, this.mySize.floatValue() * font.getSize2D()) : font.deriveFont(this.myStyle);
            }
            if (this.mySize != null) {
                return font.deriveFont(this.mySize.floatValue() * font.getSize2D());
            }
        }
        return font;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (!(event.getNewValue() instanceof MyFont) && event.getSource() instanceof Component && PROPERTY.equals(event.getPropertyName())) {
            Component component = (Component)event.getSource();
            Font font = this.derive(event.getNewValue() instanceof Font ? (Font)event.getNewValue() : component.getFont());
            if (font != null) {
                component.setFont(new MyFont(font));
            }
        }
    }

    private static final class MyFont
    extends FontUIResource {
        private MyFont(Font font) {
            super(font);
        }
    }
}

