/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.arrangement.ArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementUtil;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementSectionRule;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.util.Consumer;
import com.intellij.util.containers.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrangementSectionDetector {
    private final Document myDocument;
    private final ArrangementSettings mySettings;
    private final Consumer<? super ArrangementSectionEntryTemplate> mySectionEntryProducer;
    private final Stack<ArrangementSectionRule> myOpenedSections;

    public ArrangementSectionDetector(@Nullable Document document, @NotNull ArrangementSettings settings, @NotNull Consumer<? super ArrangementSectionEntryTemplate> producer) {
        if (settings == null) {
            ArrangementSectionDetector.$$$reportNull$$$0(0);
        }
        if (producer == null) {
            ArrangementSectionDetector.$$$reportNull$$$0(1);
        }
        this.myOpenedSections = new Stack();
        this.myDocument = document;
        this.mySettings = settings;
        this.mySectionEntryProducer = producer;
    }

    public boolean processComment(@NotNull PsiComment comment) {
        ArrangementSectionRule lastSection;
        if (comment == null) {
            ArrangementSectionDetector.$$$reportNull$$$0(2);
        }
        TextRange range = comment.getTextRange();
        TextRange expandedRange = this.myDocument == null ? range : ArrangementUtil.expandToLineIfPossible(range, this.myDocument);
        TextRange sectionTextRange = new TextRange(expandedRange.getStartOffset(), expandedRange.getEndOffset());
        String commentText = comment.getText().trim();
        ArrangementSectionRule openSectionRule = ArrangementSectionDetector.isSectionStartComment(this.mySettings, commentText);
        if (openSectionRule != null) {
            this.mySectionEntryProducer.consume((Object)new ArrangementSectionEntryTemplate(comment, StdArrangementTokens.Section.START_SECTION, sectionTextRange, commentText));
            this.myOpenedSections.push((Object)openSectionRule);
            return true;
        }
        if (!this.myOpenedSections.isEmpty() && (lastSection = (ArrangementSectionRule)this.myOpenedSections.peek()).getEndComment() != null && StringUtil.equals((CharSequence)commentText, (CharSequence)lastSection.getEndComment())) {
            this.mySectionEntryProducer.consume((Object)new ArrangementSectionEntryTemplate(comment, StdArrangementTokens.Section.END_SECTION, sectionTextRange, commentText));
            this.myOpenedSections.pop();
            return true;
        }
        return false;
    }

    @Nullable
    public static ArrangementSectionRule isSectionStartComment(@NotNull ArrangementSettings settings, @NotNull String comment) {
        if (settings == null) {
            ArrangementSectionDetector.$$$reportNull$$$0(3);
        }
        if (comment == null) {
            ArrangementSectionDetector.$$$reportNull$$$0(4);
        }
        for (ArrangementSectionRule rule : settings.getSections()) {
            if (rule.getStartComment() == null || !StringUtil.equals((CharSequence)comment, (CharSequence)rule.getStartComment())) continue;
            return rule;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producer";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/codeStyle/arrangement/ArrangementSectionDetector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processComment";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isSectionStartComment";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class ArrangementSectionEntryTemplate {
        private final PsiElement myElement;
        private final ArrangementSettingsToken myToken;
        private final TextRange myTextRange;
        private final String myText;

        public ArrangementSectionEntryTemplate(@NotNull PsiElement element, @NotNull ArrangementSettingsToken token, @NotNull TextRange range, @NotNull String text) {
            if (element == null) {
                ArrangementSectionEntryTemplate.$$$reportNull$$$0(0);
            }
            if (token == null) {
                ArrangementSectionEntryTemplate.$$$reportNull$$$0(1);
            }
            if (range == null) {
                ArrangementSectionEntryTemplate.$$$reportNull$$$0(2);
            }
            if (text == null) {
                ArrangementSectionEntryTemplate.$$$reportNull$$$0(3);
            }
            this.myElement = element;
            this.myToken = token;
            this.myTextRange = range;
            this.myText = text;
        }

        @NotNull
        public PsiElement getElement() {
            PsiElement psiElement = this.myElement;
            if (psiElement == null) {
                ArrangementSectionEntryTemplate.$$$reportNull$$$0(4);
            }
            return psiElement;
        }

        @NotNull
        public ArrangementSettingsToken getToken() {
            ArrangementSettingsToken arrangementSettingsToken = this.myToken;
            if (arrangementSettingsToken == null) {
                ArrangementSectionEntryTemplate.$$$reportNull$$$0(5);
            }
            return arrangementSettingsToken;
        }

        @NotNull
        public TextRange getTextRange() {
            TextRange textRange = this.myTextRange;
            if (textRange == null) {
                ArrangementSectionEntryTemplate.$$$reportNull$$$0(6);
            }
            return textRange;
        }

        @NotNull
        public String getText() {
            String string = this.myText;
            if (string == null) {
                ArrangementSectionEntryTemplate.$$$reportNull$$$0(7);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "token";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/codeStyle/arrangement/ArrangementSectionDetector$ArrangementSectionEntryTemplate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/codeStyle/arrangement/ArrangementSectionDetector$ArrangementSectionEntryTemplate";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElement";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getToken";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextRange";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

