/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIterator;
import java.util.AbstractSet;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class CompactVirtualFileSet
extends AbstractSet<VirtualFile> {
    private final Set<VirtualFile> weirdFiles;
    private TIntHashSet idSet;
    private BitSet fileIds;
    private boolean frozen;

    public CompactVirtualFileSet() {
        this.weirdFiles = new THashSet();
    }

    public CompactVirtualFileSet(@NotNull Collection<? extends VirtualFile> files) {
        if (files == null) {
            CompactVirtualFileSet.$$$reportNull$$$0(0);
        }
        this.weirdFiles = new THashSet();
        this.addAll(files);
    }

    @Override
    public boolean contains(Object file) {
        if (file instanceof VirtualFileWithId) {
            BitSet ids = this.fileIds;
            int id = ((VirtualFileWithId)file).getId();
            if (ids != null) {
                return ids.get(id);
            }
            TIntHashSet idSet = this.idSet;
            if (idSet != null) {
                return idSet.contains(id);
            }
        }
        return this.weirdFiles.contains(file);
    }

    @Override
    public boolean add(@NotNull VirtualFile file) {
        boolean added;
        if (file == null) {
            CompactVirtualFileSet.$$$reportNull$$$0(1);
        }
        if (this.frozen) {
            throw new UnsupportedOperationException();
        }
        if (file instanceof VirtualFileWithId) {
            int id = ((VirtualFileWithId)((Object)file)).getId();
            BitSet ids = this.fileIds;
            TIntHashSet idSet = this.idSet;
            if (ids != null) {
                added = !ids.get(id);
                ids.set(id);
            } else if (idSet != null) {
                added = idSet.add(id);
                if (idSet.size() > 1000) {
                    this.fileIds = new BitSet();
                    idSet.forEach(i -> {
                        this.fileIds.set(i);
                        return true;
                    });
                    this.idSet = null;
                }
            } else {
                added = this.weirdFiles.add(file);
                if (this.weirdFiles.size() > 10) {
                    this.idSet = idSet = new TIntHashSet(this.weirdFiles.size());
                    Iterator<VirtualFile> iterator = this.weirdFiles.iterator();
                    while (iterator.hasNext()) {
                        VirtualFile wf = iterator.next();
                        if (!(wf instanceof VirtualFileWithId)) continue;
                        int i2 = ((VirtualFileWithId)((Object)wf)).getId();
                        idSet.add(i2);
                        iterator.remove();
                    }
                }
            }
        } else {
            added = this.weirdFiles.add(file);
        }
        return added;
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public void freeze() {
        this.frozen = true;
    }

    public boolean process(@NotNull Processor<? super VirtualFile> processor) {
        TIntHashSet idSet;
        if (processor == null) {
            CompactVirtualFileSet.$$$reportNull$$$0(2);
        }
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        BitSet ids = this.fileIds;
        if (ids != null) {
            int id2 = ids.nextSetBit(0);
            while (id2 < ids.size() && id2 >= 0) {
                VirtualFile file = virtualFileManager.findFileById(id2);
                if (file != null && !processor.process((Object)file)) {
                    return false;
                }
                id2 = ids.nextSetBit(id2 + 1);
            }
        }
        if ((idSet = this.idSet) != null && !idSet.forEach(id -> {
            VirtualFile file = virtualFileManager.findFileById(id);
            return file == null || processor.process((Object)file);
        })) {
            return false;
        }
        return ContainerUtil.process(this.weirdFiles, processor);
    }

    @Override
    public int size() {
        BitSet ids = this.fileIds;
        TIntHashSet idSet = this.idSet;
        return (ids == null ? 0 : ids.cardinality()) + (idSet == null ? 0 : idSet.size()) + this.weirdFiles.size();
    }

    @Override
    @NotNull
    public Iterator<VirtualFile> iterator() {
        BitSet ids = this.fileIds;
        TIntHashSet idSet = this.idSet;
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        Iterator idsIterator = ids == null ? Collections.emptyIterator() : ContainerUtil.mapIterator((Iterator)ids.stream().iterator(), id -> virtualFileManager.findFileById((int)id));
        Iterator idSetIterator = idSet == null ? Collections.emptyIterator() : ContainerUtil.mapIterator((TIntIterator)idSet.iterator(), id -> virtualFileManager.findFileById(id));
        Iterator<VirtualFile> weirdFileIterator = this.weirdFiles.iterator();
        Iterator iterator = ContainerUtil.filterIterator((Iterator)ContainerUtil.concatIterators((Iterator[])new Iterator[]{idsIterator, idSetIterator, weirdFileIterator}), Objects::nonNull);
        if (iterator == null) {
            CompactVirtualFileSet.$$$reportNull$$$0(3);
        }
        return iterator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/CompactVirtualFileSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/CompactVirtualFileSet";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "iterator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

