/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree.nodes;

import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValuePresentationUtil;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueTextRendererBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XValueTextRendererImpl
extends XValueTextRendererBase {
    private final ColoredTextContainer myText;

    public XValueTextRendererImpl(@NotNull ColoredTextContainer text2) {
        if (text2 == null) {
            XValueTextRendererImpl.$$$reportNull$$$0(0);
        }
        this.myText = text2;
    }

    public void renderValue(@NotNull String value) {
        if (value == null) {
            XValueTextRendererImpl.$$$reportNull$$$0(1);
        }
        XValuePresentationUtil.renderValue(value, this.myText, SimpleTextAttributes.REGULAR_ATTRIBUTES, -1, null);
    }

    @Override
    protected void renderRawValue(@NotNull String value, @NotNull TextAttributesKey key) {
        if (value == null) {
            XValueTextRendererImpl.$$$reportNull$$$0(2);
        }
        if (key == null) {
            XValueTextRendererImpl.$$$reportNull$$$0(3);
        }
        TextAttributes textAttributes = DebuggerUIUtil.getColorScheme().getAttributes(key);
        SimpleTextAttributes attributes = SimpleTextAttributes.fromTextAttributes((TextAttributes)textAttributes);
        this.myText.append(value, attributes);
    }

    public void renderStringValue(@NotNull String value, @Nullable String additionalSpecialCharsToHighlight, int maxLength) {
        if (value == null) {
            XValueTextRendererImpl.$$$reportNull$$$0(4);
        }
        TextAttributes textAttributes = DebuggerUIUtil.getColorScheme().getAttributes(DefaultLanguageHighlighterColors.STRING);
        SimpleTextAttributes attributes = SimpleTextAttributes.fromTextAttributes((TextAttributes)textAttributes);
        this.myText.append("\"", attributes);
        XValuePresentationUtil.renderValue(value, this.myText, attributes, maxLength, additionalSpecialCharsToHighlight);
        this.myText.append("\"", attributes);
    }

    public void renderComment(@NotNull String comment) {
        if (comment == null) {
            XValueTextRendererImpl.$$$reportNull$$$0(5);
        }
        this.myText.append(comment, SimpleTextAttributes.GRAY_ATTRIBUTES);
    }

    public void renderError(@NotNull String error) {
        if (error == null) {
            XValueTextRendererImpl.$$$reportNull$$$0(6);
        }
        this.myText.append(error, SimpleTextAttributes.ERROR_ATTRIBUTES);
    }

    public void renderSpecialSymbol(@NotNull String symbol) {
        if (symbol == null) {
            XValueTextRendererImpl.$$$reportNull$$$0(7);
        }
        this.myText.append(symbol, SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xdebugger/impl/ui/tree/nodes/XValueTextRendererImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "renderValue";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "renderRawValue";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "renderStringValue";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "renderComment";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "renderError";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "renderSpecialSymbol";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

