/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.table;

import com.intellij.openapi.util.Iconable;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.PopupMenuListenerAdapter;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.util.ListWithSelection;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class ComboBoxTableCellEditor
extends DefaultCellEditor {
    public static final ComboBoxTableCellEditor INSTANCE = new ComboBoxTableCellEditor();
    private final JComboBox comboBox = (JComboBox)this.getComponent();

    public ComboBoxTableCellEditor() {
        super(new JComboBox(new CollectionComboBoxModel(Collections.emptyList())));
        this.comboBox.addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(){

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                ComboBoxTableCellEditor.this.cancelCellEditing();
            }

            public void popupMenuCanceled(PopupMenuEvent e) {
                ComboBoxTableCellEditor.this.cancelCellEditing();
            }
        });
        this.comboBox.setRenderer(SimpleListCellRenderer.create((label2, value, index) -> {
            label2.setIcon(value instanceof Iconable ? ((Iconable)value).getIcon(1) : null);
            label2.setText(value == null ? "" : value.toString());
        }));
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (value instanceof ListWithSelection) {
            ListWithSelection options = (ListWithSelection)value;
            this.comboBox.setModel(new CollectionComboBoxModel((List)options));
            if (options.getSelection() == null) {
                options.selectFirst();
            }
            this.comboBox.setSelectedItem(options.getSelection());
        } else {
            Enum enumValue = (Enum)value;
            Class enumClass = enumValue.getDeclaringClass();
            ComboBoxModel model2 = this.comboBox.getModel();
            if (!(model2 instanceof EnumComboBoxModel) || model2.getSize() <= 0 || ((Enum)model2.getElementAt(0)).getDeclaringClass() != enumClass) {
                this.comboBox.setModel(new EnumComboBoxModel(enumClass));
            }
            this.comboBox.setSelectedItem(value);
        }
        return this.comboBox;
    }
}

