/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.scope.NonProjectFilesScope;
import com.intellij.psi.search.scope.TestsScope;
import com.intellij.psi.search.scope.impl.CustomScopesAggregator;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetBase;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.tabs.FileColorConfiguration;
import com.intellij.ui.tabs.FileColorManagerImpl;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileColorsModel
implements Cloneable {
    public static final String FILE_COLOR = "fileColor";
    private final List<FileColorConfiguration> myApplicationLevelConfigurations;
    private final List<FileColorConfiguration> myProjectLevelConfigurations;
    private final Map<String, String> myPredefinedScopeNameToPropertyKey;
    private final Map<String, String> myPredefinedScopeNameToColor;
    @NotNull
    private final Project myProject;

    FileColorsModel(@NotNull Project project) {
        if (project == null) {
            FileColorsModel.$$$reportNull$$$0(0);
        }
        this.myApplicationLevelConfigurations = new ArrayList<FileColorConfiguration>();
        this.myProjectLevelConfigurations = new ArrayList<FileColorConfiguration>();
        this.myPredefinedScopeNameToPropertyKey = new THashMap();
        this.myPredefinedScopeNameToColor = new THashMap();
        this.myProject = project;
        this.initPredefinedAndGlobalScopes();
    }

    private FileColorsModel(@NotNull Project project, @NotNull List<? extends FileColorConfiguration> applicationLevel, @NotNull List<? extends FileColorConfiguration> projectLevel) {
        if (project == null) {
            FileColorsModel.$$$reportNull$$$0(1);
        }
        if (applicationLevel == null) {
            FileColorsModel.$$$reportNull$$$0(2);
        }
        if (projectLevel == null) {
            FileColorsModel.$$$reportNull$$$0(3);
        }
        this.myApplicationLevelConfigurations = new ArrayList<FileColorConfiguration>();
        this.myProjectLevelConfigurations = new ArrayList<FileColorConfiguration>();
        this.myPredefinedScopeNameToPropertyKey = new THashMap();
        this.myPredefinedScopeNameToColor = new THashMap();
        this.myProject = project;
        this.myApplicationLevelConfigurations.addAll(applicationLevel);
        this.myProjectLevelConfigurations.addAll(projectLevel);
        this.initPredefinedAndGlobalScopes();
    }

    private void initPredefinedAndGlobalScopes() {
        String colorName;
        for (NamedScope scope : CustomScopesAggregator.getAllCustomScopes(this.myProject)) {
            String scopeName = scope.getName();
            colorName = scope.getDefaultColorName();
            if (StringUtil.isEmpty((String)colorName)) continue;
            this.myPredefinedScopeNameToColor.put(scopeName, colorName);
            String propertyKey = NonProjectFilesScope.NAME.equals(scopeName) ? "file.colors.enable.non.project" : (TestsScope.NAME.equals(scopeName) ? "file.colors.enable.tests" : "file.colors.enable.custom." + scopeName);
            this.myPredefinedScopeNameToPropertyKey.put(scopeName, propertyKey);
        }
        PropertiesComponent propertyComponent = PropertiesComponent.getInstance();
        for (String scopeName : this.myPredefinedScopeNameToPropertyKey.keySet()) {
            if (this.findConfiguration(scopeName, false) != null || (colorName = this.getColorNameForScope(propertyComponent, scopeName, this.myPredefinedScopeNameToPropertyKey)).isEmpty()) continue;
            Color color = ColorUtil.fromHex((String)colorName, null);
            String name = color == null ? null : FileColorManagerImpl.getColorName(color);
            this.myApplicationLevelConfigurations.add(new FileColorConfiguration(scopeName, name == null ? colorName : name));
        }
    }

    private String getColorNameForScope(PropertiesComponent propertyComponent, String scopeName, Map<String, String> scopeNameMap) {
        String colorName = propertyComponent.getValue(scopeNameMap.get(scopeName));
        if (colorName == null && (colorName = propertyComponent.getValue(scopeName)) == null) {
            colorName = this.myPredefinedScopeNameToColor.get(scopeName);
        }
        return colorName;
    }

    public void save(@NotNull Element e, boolean isProjectLevel) {
        if (e == null) {
            FileColorsModel.$$$reportNull$$$0(4);
        }
        List<FileColorConfiguration> configurations = isProjectLevel ? this.myProjectLevelConfigurations : this.myApplicationLevelConfigurations;
        for (FileColorConfiguration configuration : configurations) {
            String propertyKey;
            String scopeName = configuration.getScopeName();
            String string = propertyKey = isProjectLevel ? null : this.myPredefinedScopeNameToPropertyKey.get(scopeName);
            if (propertyKey == null) {
                configuration.save(e);
                continue;
            }
            PropertiesComponent propertyComponent = PropertiesComponent.getInstance();
            propertyComponent.setValue(propertyKey, configuration.getColorName(), this.myPredefinedScopeNameToColor.get(scopeName));
            PropertiesComponent.getInstance().setValue(scopeName, null);
        }
    }

    public void load(@NotNull Element e, boolean isProjectLevel) {
        if (e == null) {
            FileColorsModel.$$$reportNull$$$0(5);
        }
        List<FileColorConfiguration> configurations = isProjectLevel ? this.myProjectLevelConfigurations : this.myApplicationLevelConfigurations;
        configurations.clear();
        THashMap predefinedScopeNameToPropertyKey = new THashMap(this.myPredefinedScopeNameToPropertyKey);
        for (Element child2 : e.getChildren(FILE_COLOR)) {
            FileColorConfiguration configuration = FileColorConfiguration.load(child2);
            if (configuration == null) continue;
            if (!isProjectLevel) {
                predefinedScopeNameToPropertyKey.remove(configuration.getScopeName());
            }
            configurations.add(configuration);
        }
        if (!isProjectLevel) {
            PropertiesComponent properties = PropertiesComponent.getInstance();
            for (String scopeName : predefinedScopeNameToPropertyKey.keySet()) {
                String colorName = this.getColorNameForScope(properties, scopeName, (Map<String, String>)predefinedScopeNameToPropertyKey);
                if (StringUtil.isEmpty((String)colorName)) continue;
                configurations.add(new FileColorConfiguration(scopeName, colorName));
            }
        }
    }

    public FileColorsModel clone() throws CloneNotSupportedException {
        ArrayList<FileColorConfiguration> applicationLevel = new ArrayList<FileColorConfiguration>();
        for (FileColorConfiguration configuration : this.myApplicationLevelConfigurations) {
            applicationLevel.add(configuration.clone());
        }
        ArrayList<FileColorConfiguration> projectLevel = new ArrayList<FileColorConfiguration>();
        for (FileColorConfiguration configuration : this.myProjectLevelConfigurations) {
            projectLevel.add(configuration.clone());
        }
        return new FileColorsModel(this.myProject, applicationLevel, projectLevel);
    }

    public void add(@NotNull FileColorConfiguration configuration, boolean isProjectLevel) {
        List<FileColorConfiguration> configurations;
        if (configuration == null) {
            FileColorsModel.$$$reportNull$$$0(6);
        }
        List<FileColorConfiguration> list2 = configurations = isProjectLevel ? this.myProjectLevelConfigurations : this.myApplicationLevelConfigurations;
        if (!configurations.contains(configuration)) {
            configurations.add(configuration);
        }
    }

    public void add(@NotNull String scopeName, @NotNull String colorName, boolean isProjectLevel) {
        if (scopeName == null) {
            FileColorsModel.$$$reportNull$$$0(7);
        }
        if (colorName == null) {
            FileColorsModel.$$$reportNull$$$0(8);
        }
        this.add(new FileColorConfiguration(scopeName, colorName), isProjectLevel);
    }

    @Nullable
    private FileColorConfiguration findConfiguration(@NotNull String scopeName, boolean isProjectLevel) {
        if (scopeName == null) {
            FileColorsModel.$$$reportNull$$$0(9);
        }
        List<FileColorConfiguration> configurations = isProjectLevel ? this.myProjectLevelConfigurations : this.myApplicationLevelConfigurations;
        for (FileColorConfiguration configuration : configurations) {
            if (!scopeName.equals(configuration.getScopeName())) continue;
            return configuration;
        }
        return null;
    }

    public boolean isProjectLevel(@NotNull String scopeName) {
        if (scopeName == null) {
            FileColorsModel.$$$reportNull$$$0(10);
        }
        return this.findConfiguration(scopeName, true) != null;
    }

    @Nullable
    public String getColor(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            FileColorsModel.$$$reportNull$$$0(11);
        }
        if (!psiFile.isValid()) {
            return null;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        return virtualFile == null ? null : this.getColor(virtualFile, psiFile.getProject());
    }

    @Nullable
    public String getColor(@NotNull VirtualFile file2, Project project) {
        if (file2 == null) {
            FileColorsModel.$$$reportNull$$$0(12);
        }
        if (!file2.isValid()) {
            return null;
        }
        FileColorConfiguration configuration = this.findConfiguration(file2);
        if (configuration != null && configuration.isValid(project)) {
            return configuration.getColorName();
        }
        return null;
    }

    @Nullable
    public String getScopeColor(@NotNull String scopeName, Project project) {
        if (scopeName == null) {
            FileColorsModel.$$$reportNull$$$0(13);
        }
        FileColorConfiguration configuration = null;
        for (FileColorConfiguration each : this.getConfigurations()) {
            if (!scopeName.equals(each.getScopeName())) continue;
            configuration = each;
            break;
        }
        if (configuration != null && configuration.isValid(project)) {
            return configuration.getColorName();
        }
        return null;
    }

    @Nullable
    private FileColorConfiguration findConfiguration(@NotNull VirtualFile colored) {
        if (colored == null) {
            FileColorsModel.$$$reportNull$$$0(14);
        }
        for (FileColorConfiguration configuration : this.getConfigurations()) {
            NamedScope scope = NamedScopesHolder.getScope((Project)this.myProject, (String)configuration.getScopeName());
            if (scope == null) continue;
            NamedScopesHolder namedScopesHolder = NamedScopesHolder.getHolder((Project)this.myProject, (String)configuration.getScopeName(), null);
            PackageSet packageSet = scope.getValue();
            if (!(packageSet instanceof PackageSetBase) || namedScopesHolder == null || !((PackageSetBase)packageSet).contains(colored, this.myProject, namedScopesHolder)) continue;
            return configuration;
        }
        return null;
    }

    @NotNull
    private List<FileColorConfiguration> getConfigurations() {
        List list2 = ContainerUtil.concat(this.myApplicationLevelConfigurations, this.myProjectLevelConfigurations);
        if (list2 == null) {
            FileColorsModel.$$$reportNull$$$0(15);
        }
        return list2;
    }

    public boolean isProjectLevel(@NotNull FileColorConfiguration configuration) {
        if (configuration == null) {
            FileColorsModel.$$$reportNull$$$0(16);
        }
        return this.myProjectLevelConfigurations.contains(configuration);
    }

    public void setConfigurations(@NotNull List<? extends FileColorConfiguration> configurations, boolean isProjectLevel) {
        if (configurations == null) {
            FileColorsModel.$$$reportNull$$$0(17);
        }
        if (isProjectLevel) {
            this.myProjectLevelConfigurations.clear();
            this.myProjectLevelConfigurations.addAll(configurations);
        } else {
            this.myApplicationLevelConfigurations.clear();
            THashMap predefinedScopeNameToPropertyKey = new THashMap(this.myPredefinedScopeNameToPropertyKey);
            PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
            for (FileColorConfiguration fileColorConfiguration : configurations) {
                this.myApplicationLevelConfigurations.add(fileColorConfiguration);
                String propertyKey = (String)predefinedScopeNameToPropertyKey.remove(fileColorConfiguration.getScopeName());
                if (propertyKey == null) continue;
                propertiesComponent.setValue(propertyKey, fileColorConfiguration.getColorName());
            }
            for (String string : predefinedScopeNameToPropertyKey.keySet()) {
                propertiesComponent.setValue((String)predefinedScopeNameToPropertyKey.get(string), "");
                propertiesComponent.setValue(string, null);
            }
        }
    }

    public boolean isColored(@NotNull String scopeName, boolean isProjectLevel) {
        if (scopeName == null) {
            FileColorsModel.$$$reportNull$$$0(18);
        }
        return this.findConfiguration(scopeName, isProjectLevel) != null;
    }

    public List<FileColorConfiguration> getLocalConfigurations() {
        return this.myApplicationLevelConfigurations;
    }

    @NotNull
    public List<FileColorConfiguration> getProjectLevelConfigurations() {
        List<FileColorConfiguration> list2 = this.myProjectLevelConfigurations;
        if (list2 == null) {
            FileColorsModel.$$$reportNull$$$0(19);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationLevel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectLevel";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 6: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colored";
                break;
            }
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/tabs/FileColorsModel";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/tabs/FileColorsModel";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurations";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectLevelConfigurations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 9: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findConfiguration";
                break;
            }
            case 10: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isProjectLevel";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getColor";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getScopeColor";
                break;
            }
            case 15: 
            case 19: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setConfigurations";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isColored";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

