/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.actions;

import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.internal.statistic.connect.StatisticsResult;
import com.intellij.internal.statistic.eventLog.EventLogExternalSettingsService;
import com.intellij.internal.statistic.eventLog.EventLogResultDecorator;
import com.intellij.internal.statistic.eventLog.EventLogSettingsService;
import com.intellij.internal.statistic.eventLog.EventLogStatisticsService;
import com.intellij.internal.statistic.eventLog.LogEventFilter;
import com.intellij.internal.statistic.eventLog.LogEventRecordRequest;
import com.intellij.internal.statistic.eventLog.LogEventSerializer;
import com.intellij.internal.statistic.eventLog.LogEventWhitelistFilter;
import com.intellij.internal.statistic.service.fus.FUSWhitelist;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SendEventLogAction
extends AnAction {
    private static final String FUS_RECORDER = "FUS";

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            SendEventLogAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "Send Feature Usage Event Log", false){

            public void run(@NotNull ProgressIndicator indicator) {
                boolean succeed;
                StatisticsResult result2;
                StatisticsResult.ResultCode code;
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (((code = (result2 = EventLogStatisticsService.send(SendEventLogAction.FUS_RECORDER, new EventLogTestSettingsService(), new EventLogTestResultDecorator())).getCode()) == StatisticsResult.ResultCode.SENT_WITH_ERRORS || code == StatisticsResult.ResultCode.SEND) && (succeed = SendEventLogAction.tryToOpenInScratch(project, result2.getDescription()))) {
                    return;
                }
                ApplicationManager.getApplication().invokeLater(() -> Messages.showMultilineInputDialog((Project)project, (String)("Result: " + (Object)((Object)code)), (String)"Statistics Result", (String)StringUtil.replace((String)result2.getDescription(), (String)";", (String)"\n"), null, null), ModalityState.NON_MODAL, project.getDisposed());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/internal/statistic/actions/SendEventLogAction$1", "run"));
            }
        });
    }

    private static boolean tryToOpenInScratch(@NotNull Project project, @NotNull String request) {
        if (project == null) {
            SendEventLogAction.$$$reportNull$$$0(1);
        }
        if (request == null) {
            SendEventLogAction.$$$reportNull$$$0(2);
        }
        String fileName2 = PathUtil.makeFileName((String)"fus-event-log", (String)"json");
        try {
            ThrowableComputable computable = () -> {
                Document document;
                ScratchFileService fileService = ScratchFileService.getInstance();
                VirtualFile file2 = fileService.findFile(RootType.findById((String)"scratches"), fileName2, ScratchFileService.Option.create_new_always);
                fileService.getScratchesMapping().setMapping(file2, (Object)Language.findLanguageByID((String)"JSON"));
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file2);
                Document document2 = document = psiFile != null ? PsiDocumentManager.getInstance((Project)project).getDocument(psiFile) : null;
                if (document == null) {
                    return null;
                }
                document.insertString(document.getTextLength(), (CharSequence)request);
                PsiDocumentManager.getInstance((Project)project).commitDocument(document);
                return psiFile;
            };
            NavigatablePsiElement psiElement = (NavigatablePsiElement)WriteCommandAction.writeCommandAction((Project)project).withName("Creating JSON for event log upload results").withGlobalUndo().shouldRecordActionForActiveDocument(false).withUndoConfirmationPolicy(UndoConfirmationPolicy.REQUEST_CONFIRMATION).compute(computable);
            if (psiElement != null) {
                AppUIUtil.invokeOnEdt(() -> psiElement.navigate(true), project.getDisposed());
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
        }
        objectArray2[1] = "com/intellij/internal/statistic/actions/SendEventLogAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "tryToOpenInScratch";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class EventLogTestResultDecorator
    implements EventLogResultDecorator {
        private final List<LogEventRecordRequest> mySucceed = new ArrayList<LogEventRecordRequest>();
        private final List<LogEventRecordRequest> myFailed = new ArrayList<LogEventRecordRequest>();

        private EventLogTestResultDecorator() {
        }

        @Override
        public void succeed(@NotNull LogEventRecordRequest request) {
            if (request == null) {
                EventLogTestResultDecorator.$$$reportNull$$$0(0);
            }
            this.mySucceed.add(request);
        }

        @Override
        public void failed(@Nullable LogEventRecordRequest request) {
            if (request != null) {
                this.myFailed.add(request);
            } else {
                this.myFailed.add(new LogEventRecordRequest("INVALID", "INVALID", "INVALID", ContainerUtil.emptyList(), true));
            }
        }

        @Override
        @NotNull
        public StatisticsResult toResult() {
            int total = this.mySucceed.size() + this.myFailed.size();
            if (this.mySucceed.isEmpty() && this.myFailed.isEmpty()) {
                StatisticsResult statisticsResult = new StatisticsResult(StatisticsResult.ResultCode.NOTHING_TO_SEND, "No files to upload.");
                if (statisticsResult == null) {
                    EventLogTestResultDecorator.$$$reportNull$$$0(1);
                }
                return statisticsResult;
            }
            if (!this.myFailed.isEmpty()) {
                StringBuilder out = new StringBuilder("{\"total\":");
                out.append(total).append(", \"uploaded\":").append(this.mySucceed.size()).append(",");
                out.append("\"failed\":[");
                EventLogTestResultDecorator.append(out, this.myFailed);
                out.append("],\"succeed\":[");
                EventLogTestResultDecorator.append(out, this.mySucceed);
                out.append("]}");
                StatisticsResult statisticsResult = new StatisticsResult(StatisticsResult.ResultCode.SENT_WITH_ERRORS, out.toString());
                if (statisticsResult == null) {
                    EventLogTestResultDecorator.$$$reportNull$$$0(2);
                }
                return statisticsResult;
            }
            StringBuilder out = new StringBuilder("{\"total\":");
            out.append(total).append(", \"uploaded\":").append(this.mySucceed.size()).append(",");
            out.append("\"succeed\":[");
            EventLogTestResultDecorator.append(out, this.mySucceed);
            out.append("]}");
            StatisticsResult statisticsResult = new StatisticsResult(StatisticsResult.ResultCode.SEND, out.toString());
            if (statisticsResult == null) {
                EventLogTestResultDecorator.$$$reportNull$$$0(3);
            }
            return statisticsResult;
        }

        private static void append(@NotNull StringBuilder out, @NotNull List<LogEventRecordRequest> requests) {
            if (out == null) {
                EventLogTestResultDecorator.$$$reportNull$$$0(4);
            }
            if (requests == null) {
                EventLogTestResultDecorator.$$$reportNull$$$0(5);
            }
            for (LogEventRecordRequest request : requests) {
                out.append(LogEventSerializer.INSTANCE.toString(request)).append(",");
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/statistic/actions/SendEventLogAction$EventLogTestResultDecorator";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "requests";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/statistic/actions/SendEventLogAction$EventLogTestResultDecorator";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "succeed";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "append";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class EventLogTestSettingsService
    extends EventLogExternalSettingsService
    implements EventLogSettingsService {
        private EventLogTestSettingsService() {
            super(SendEventLogAction.FUS_RECORDER, true);
        }

        @Override
        public int getPermittedTraffic() {
            return 100;
        }

        @Override
        @NotNull
        public LogEventFilter getEventFilter() {
            FUSWhitelist whitelist = this.getWhitelistedGroups();
            LogEventWhitelistFilter logEventWhitelistFilter = new LogEventWhitelistFilter(whitelist != null ? whitelist : FUSWhitelist.empty());
            if (logEventWhitelistFilter == null) {
                EventLogTestSettingsService.$$$reportNull$$$0(0);
            }
            return logEventWhitelistFilter;
        }

        @Override
        public boolean isInternal() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/actions/SendEventLogAction$EventLogTestSettingsService", "getEventFilter"));
        }
    }
}

