/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.Patches;
import com.intellij.concurrency.IdeaForkJoinWorkerThreadFactory;
import com.intellij.concurrency.SameThreadExecutorService;
import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.ParallelActivity;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ide.CliResult;
import com.intellij.ide.IdeRepaintManager;
import com.intellij.ide.customize.AbstractCustomizeWizardStep;
import com.intellij.ide.customize.CustomizeIDEWizardDialog;
import com.intellij.ide.customize.CustomizeIDEWizardStepsProvider;
import com.intellij.ide.gdpr.EndUserAgreement;
import com.intellij.ide.plugins.MainRunner;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.startup.StartupActionScriptManager;
import com.intellij.ide.ui.laf.IntelliJLaf;
import com.intellij.idea.LoggerFactory;
import com.intellij.idea.Main;
import com.intellij.idea.SocketLock;
import com.intellij.idea.SplashManager;
import com.intellij.jna.JnaLoader;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ConfigImportHelper;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.win32.IdeaWin32;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.impl.X11UiUtil;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.IconManager;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JOptionPane;
import javax.swing.RepaintManager;
import javax.swing.UIManager;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.PatternLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.BuiltInServer;

public class StartupUtil {
    public static final String FORCE_PLUGIN_UPDATES = "idea.force.plugin.updates";
    public static final String IDEA_CLASS_BEFORE_APPLICATION_PROPERTY = "idea.class.before.app";
    private static final String MAGIC_MAC_PATH = "/AppTranslocation/";
    private static SocketLock ourSocketLock;
    private static final AtomicBoolean ourSystemPatched;
    private static final Thread.UncaughtExceptionHandler HANDLER;

    private StartupUtil() {
    }

    public static synchronized void addExternalInstanceListener(@Nullable SocketLock.CliRequestProcessor processor2) {
        if (ourSocketLock != null) {
            ourSocketLock.setExternalInstanceListener(processor2);
        }
    }

    @Nullable
    public static synchronized BuiltInServer getServer() {
        return ourSocketLock == null ? null : ourSocketLock.getServer();
    }

    public static void installExceptionHandler() {
        Thread.currentThread().setUncaughtExceptionHandler(HANDLER);
    }

    private static void runPreAppClass(Logger log2) {
        String classBeforeAppProperty = System.getProperty(IDEA_CLASS_BEFORE_APPLICATION_PROPERTY);
        if (classBeforeAppProperty != null) {
            try {
                Class<?> clazz = Class.forName(classBeforeAppProperty);
                Method invokeMethod = clazz.getDeclaredMethod("invoke", new Class[0]);
                invokeMethod.invoke(null, new Object[0]);
            }
            catch (Exception ex) {
                log2.error("Failed pre-app class init for class " + classBeforeAppProperty, (Throwable)ex);
            }
        }
    }

    static void prepareAndStart(@NotNull String[] args, @NotNull AppStarter appStarter) throws InvocationTargetException, InterruptedException, ExecutionException {
        if (args == null) {
            StartupUtil.$$$reportNull$$$0(0);
        }
        if (appStarter == null) {
            StartupUtil.$$$reportNull$$$0(1);
        }
        IdeaForkJoinWorkerThreadFactory.setupForkJoinCommonPool((boolean)Main.isHeadless((String[])args));
        CompletableFuture<Void> initLafTask = CompletableFuture.runAsync(() -> {
            StartupUtil.checkHiDPISettings();
            System.setProperty("sun.awt.noerasebackground", "true");
            try {
                StartupUiUtil.initDefaultLaF();
                if (!Main.isHeadless()) {
                    SplashManager.show(args);
                }
                StartupUiUtil.configureHtmlKitStylesheet();
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        }, runnable2 -> {
            StartupUtil.installExceptionHandler();
            EventQueue.invokeLater(runnable2);
        });
        StartupUtil.configureLogging();
        if (!StartupUtil.checkJdkVersion()) {
            System.exit(4);
        }
        boolean newConfigFolder = !Main.isHeadless() && !new File(PathManager.getConfigPath()).exists();
        final Logger log2 = StartupUtil.lockDirsAndConfigureLogger(args);
        boolean isParallelExecution = SystemProperties.getBooleanProperty((String)"idea.prepare.app.start.parallel", (boolean)true);
        SmartList futures = new SmartList();
        ExecutorService executorService = isParallelExecution ? AppExecutorUtil.getAppExecutorService() : new SameThreadExecutorService();
        futures.add(executorService.submit(() -> {
            Activity activity = ParallelActivity.PREPARE_APP_INIT.start("setup system libs");
            StartupUtil.setupSystemLibraries();
            activity = activity.endAndStart("fix process env");
            StartupUtil.fixProcessEnvironment(log2);
            activity.end();
        }));
        StartupUtil.addInitUiTasks(futures, executorService, log2, initLafTask);
        if (!newConfigFolder) {
            StartupUtil.installPluginUpdates();
            StartupUtil.runPreAppClass(log2);
        }
        if (isParallelExecution) {
            executorService.submit(() -> StartupUtil.loadSystemLibraries(log2));
            Activity activity = StartUpMeasurer.start((String)"wait tasks");
            for (Future future2 : futures) {
                future2.get();
            }
            activity.end();
            futures.clear();
        }
        if (!Main.isHeadless()) {
            if (newConfigFolder) {
                appStarter.beforeImportConfigs();
                Path newConfigDir = Paths.get(PathManager.getConfigPath(), new String[0]);
                StartupUtil.runInEdtAndWait(log2, () -> ConfigImportHelper.importConfigsTo(newConfigDir, log2));
                appStarter.importFinished(newConfigDir);
            }
            StartupUtil.showUserAgreementAndConsentsIfNeeded(log2);
            if (newConfigFolder && !ConfigImportHelper.isConfigImported()) {
                EventQueue.invokeAndWait(() -> StartupUtil.runStartupWizard(appStarter));
            }
        }
        EdtInvocationManager.executeWithCustomManager((EdtInvocationManager)new EdtInvocationManager.SwingEdtInvocationManager(){

            public void invokeAndWait(@NotNull Runnable task2) {
                if (task2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                StartupUtil.runInEdtAndWait(log2, task2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/idea/StartupUtil$1", "invokeAndWait"));
            }
        }, () -> appStarter.start());
    }

    @NotNull
    private static Logger lockDirsAndConfigureLogger(@NotNull String[] args) {
        if (args == null) {
            StartupUtil.$$$reportNull$$$0(2);
        }
        Activity activity = StartUpMeasurer.start((String)"check system dirs");
        if (!StartupUtil.checkSystemFolders()) {
            System.exit(5);
        }
        activity = activity.endAndStart("lock system dirs");
        SocketLock.ActivateStatusAndResponse result2 = StartupUtil.lockSystemFolders(args);
        if (result2.getActivateStatus() == SocketLock.ActivateStatus.ACTIVATED) {
            CliResult cliOutput = Objects.requireNonNull(result2.getResponse(), "guaranteed by SocketLock.mapResponseToCliResult");
            if (cliOutput.getMessage() != null) {
                System.out.println(cliOutput.getMessage());
            }
            System.exit(cliOutput.getReturnCode());
        }
        if (result2.getActivateStatus() == SocketLock.ActivateStatus.CANNOT_ACTIVATE) {
            System.exit(6);
        }
        activity = activity.endAndStart("configure file logger");
        Logger.setFactory((Logger.Factory)new LoggerFactory());
        Logger log2 = Logger.getInstance(Main.class);
        activity = activity.endAndStart("start logging");
        StartupUtil.startLogging(log2);
        activity.end();
        Logger logger = log2;
        if (logger == null) {
            StartupUtil.$$$reportNull$$$0(3);
        }
        return logger;
    }

    private static void addInitUiTasks(@NotNull List<? super Future<?>> futures, @NotNull ExecutorService executorService, @NotNull Logger log2, @NotNull Future<?> initLafTask) {
        if (futures == null) {
            StartupUtil.$$$reportNull$$$0(4);
        }
        if (executorService == null) {
            StartupUtil.$$$reportNull$$$0(5);
        }
        if (log2 == null) {
            StartupUtil.$$$reportNull$$$0(6);
        }
        if (initLafTask == null) {
            StartupUtil.$$$reportNull$$$0(7);
        }
        futures.add(executorService.submit(() -> {
            try {
                try {
                    initLafTask.get();
                }
                catch (Exception e) {
                    log2.error("Cannot initialize default LaF", (Throwable)e);
                }
                Activity activity = ParallelActivity.PREPARE_APP_INIT.start("init system font data");
                JBUIScale.getSystemFontData();
                activity.end();
            }
            catch (Exception e) {
                log2.error("Cannot initialize system font data", (Throwable)e);
            }
            if (!Main.isHeadless()) {
                if (!PluginManagerCore.isRunningFromSources() && !AppUIUtil.isWindowIconAlreadyExternallySet()) {
                    executorService.execute(() -> {
                        Activity activity = ParallelActivity.PREPARE_APP_INIT.start("update window icon");
                        AppUIUtil.updateWindowIcon(JOptionPane.getRootFrame());
                        activity.end();
                    });
                }
                if (System.getProperty("com.jetbrains.suppressWindowRaise") == null) {
                    System.setProperty("com.jetbrains.suppressWindowRaise", "true");
                }
                AppUIUtil.updateFrameClass(Toolkit.getDefaultToolkit());
            }
        }));
    }

    private static void configureLogging() {
        Activity activity = StartUpMeasurer.start((String)"configure logging");
        System.setProperty("log4j.defaultInitOverride", "true");
        try {
            org.apache.log4j.Logger root = org.apache.log4j.Logger.getRootLogger();
            if (!root.getAllAppenders().hasMoreElements()) {
                root.setLevel(Level.WARN);
                root.addAppender((Appender)new ConsoleAppender((Layout)new PatternLayout("%m%n")));
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        activity.end();
    }

    private static boolean checkJdkVersion() {
        if ("true".equals(System.getProperty("idea.jre.check"))) {
            try {
                Class.forName("com.sun.jdi.Field", false, StartupUtil.class.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                String message = "JDK classes seem to be not on " + ApplicationNamesInfo.getInstance().getProductName() + " classpath.\nPlease ensure you run the IDE on JDK rather than JRE.";
                Main.showMessage((String)"JDK Required", (String)message, (boolean)true);
                return false;
            }
            catch (LinkageError e) {
                String message = "Cannot load a JDK class: " + e.getMessage() + "\nPlease ensure you run the IDE on JDK rather than JRE.";
                Main.showMessage((String)"JDK Required", (String)message, (boolean)true);
                return false;
            }
        }
        if ("true".equals(System.getProperty("idea.64bit.check")) && PlatformUtils.isCidr() && !SystemInfo.is64Bit) {
            String message = "32-bit JVM is not supported. Please use 64-bit version.";
            Main.showMessage((String)"Unsupported JVM", (String)message, (boolean)true);
            return false;
        }
        return true;
    }

    public static void test_checkHiDPISettings() {
        StartupUtil.checkHiDPISettings();
    }

    private static void checkHiDPISettings() {
        if (!SystemProperties.getBooleanProperty((String)"hidpi", (boolean)true)) {
            System.setProperty("sun.java2d.uiScale.enabled", "false");
        }
    }

    private static synchronized boolean checkSystemFolders() {
        String configPath = PathManager.getConfigPath();
        PathManager.ensureConfigFolderExists();
        if (!StartupUtil.checkDirectory(configPath, "Config", "idea.config.path", true, true, false)) {
            return false;
        }
        String systemPath = PathManager.getSystemPath();
        if (!StartupUtil.checkDirectory(systemPath, "System", "idea.system.path", true, true, false)) {
            return false;
        }
        if (FileUtil.pathsEqual((String)configPath, (String)systemPath)) {
            String message = "Config and system paths seem to be equal.\n\nIf you have modified 'idea.config.path' or 'idea.system.path' properties,\nplease make sure they point to different directories, otherwise please re-install the IDE.";
            Main.showMessage((String)"Invalid Config or System Path", (String)message, (boolean)true);
            return false;
        }
        String logPath = PathManager.getLogPath();
        String tempPath = PathManager.getTempPath();
        return StartupUtil.checkDirectory(logPath, "Log", "idea.log.path", !FileUtil.isAncestor((String)systemPath, (String)logPath, (boolean)true), false, false) && StartupUtil.checkDirectory(tempPath, "Temp", "idea.system.path", !FileUtil.isAncestor((String)systemPath, (String)tempPath, (boolean)true), false, SystemInfo.isXWindow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static boolean checkDirectory(String path, String kind, String property, boolean checkWrite, boolean checkLock, boolean checkExec) {
        boolean options222;
        Path tempFile;
        String reason;
        String problem;
        block42: {
            block41: {
                problem = null;
                reason = null;
                tempFile = null;
                problem = "cannot create the directory";
                reason = "path is incorrect";
                Path directory = Paths.get(path, new String[0]);
                if (!Files.isDirectory(directory, new LinkOption[0])) {
                    problem = "cannot create the directory";
                    reason = "parent directory is read-only or the user lacks necessary permissions";
                    Files.createDirectories(directory, new FileAttribute[0]);
                }
                if (checkWrite || checkLock || checkExec) {
                    problem = "cannot create a temporary file in the directory";
                    reason = "the directory is read-only or the user lacks necessary permissions";
                    tempFile = directory.resolve("ij" + new Random().nextInt(Integer.MAX_VALUE) + ".tmp");
                    OpenOption[] options222 = new OpenOption[]{StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE};
                    Files.write(tempFile, "#!/bin/sh\nexit 0".getBytes(StandardCharsets.UTF_8), options222);
                    if (checkLock) {
                        problem = "cannot create a lock file in the directory";
                        reason = "the directory is located on a network disk";
                        try (FileChannel channel = FileChannel.open(tempFile, StandardOpenOption.WRITE);
                             FileLock lock = channel.tryLock();){
                            if (lock == null) {
                                throw new IOException("File is locked");
                            }
                            break block41;
                        }
                    }
                    if (checkExec) {
                        problem = "cannot execute a test script in the directory";
                        reason = "the partition is mounted with 'no exec' option";
                        Files.getFileAttributeView(tempFile, PosixFileAttributeView.class, new LinkOption[0]).setPermissions(EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE));
                        int ec = new ProcessBuilder(tempFile.toAbsolutePath().toString()).start().waitFor();
                        if (ec != 0) {
                            throw new IOException("Unexpected exit value: " + ec);
                        }
                    }
                }
            }
            options222 = true;
            if (tempFile == null) break block42;
            try {
                Files.deleteIfExists(tempFile);
            }
            catch (Exception ec) {
                // empty catch block
            }
        }
        return options222;
        catch (Exception e) {
            boolean bl;
            block43: {
                try {
                    String title = "Invalid " + kind + " Directory";
                    String advice = SystemInfo.isMac && PathManager.getSystemPath().contains(MAGIC_MAC_PATH) ? "The application seems to be trans-located by macOS and cannot be used in this state.\nPlease use Finder to move it to another location." : "If you have modified the '" + property + "' property, please make sure it is correct,\notherwise please re-install the IDE.";
                    String message = "The IDE " + problem + ".\nPossible reason: " + reason + ".\n\n" + advice + "\n\n-----\nLocation: " + path + "\n" + e.getClass().getName() + ": " + e.getMessage();
                    Main.showMessage((String)title, (String)message, (boolean)true);
                    bl = false;
                    if (tempFile == null) break block43;
                }
                catch (Throwable throwable) {
                    if (tempFile != null) {
                        try {
                            Files.deleteIfExists(tempFile);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                try {
                    Files.deleteIfExists(tempFile);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return bl;
        }
    }

    @NotNull
    private static synchronized SocketLock.ActivateStatusAndResponse lockSystemFolders(@NotNull String[] args) {
        SocketLock.ActivateStatusAndResponse status;
        if (args == null) {
            StartupUtil.$$$reportNull$$$0(8);
        }
        if (ourSocketLock != null) {
            throw new AssertionError();
        }
        ourSocketLock = new SocketLock(PathManager.getConfigPath(), PathManager.getSystemPath());
        try {
            status = ourSocketLock.lock(args);
        }
        catch (Exception e) {
            Main.showMessage((String)"Cannot Lock System Folders", (Throwable)e);
            SocketLock.ActivateStatusAndResponse activateStatusAndResponse = SocketLock.ActivateStatusAndResponse.emptyResponse(SocketLock.ActivateStatus.CANNOT_ACTIVATE);
            if (activateStatusAndResponse == null) {
                StartupUtil.$$$reportNull$$$0(9);
            }
            return activateStatusAndResponse;
        }
        switch (status.getActivateStatus()) {
            case NO_INSTANCE: {
                ShutDownTracker.getInstance().registerShutdownTask(() -> {
                    Class<StartupUtil> clazz = StartupUtil.class;
                    synchronized (StartupUtil.class) {
                        ourSocketLock.dispose();
                        ourSocketLock = null;
                        // ** MonitorExit[var0] (shouldn't be in output)
                        return;
                    }
                });
                break;
            }
            case ACTIVATED: {
                System.out.println("Already running");
                break;
            }
            case CANNOT_ACTIVATE: {
                String message = "Only one instance of " + ApplicationNamesInfo.getInstance().getProductName() + " can be run at a time.";
                Main.showMessage((String)"Too Many Instances", (String)message, (boolean)true);
            }
        }
        SocketLock.ActivateStatusAndResponse activateStatusAndResponse = status;
        if (activateStatusAndResponse == null) {
            StartupUtil.$$$reportNull$$$0(10);
        }
        return activateStatusAndResponse;
    }

    private static void fixProcessEnvironment(Logger log2) {
        boolean envReady;
        if (!Main.isCommandLine()) {
            System.setProperty("__idea.mac.env.lock", "unlocked");
        }
        if (!(envReady = EnvironmentUtil.isEnvironmentReady())) {
            log2.info("initializing environment");
        }
    }

    private static void setupSystemLibraries() {
        String ideTempPath = PathManager.getTempPath();
        if (System.getProperty("jna.tmpdir") == null) {
            System.setProperty("jna.tmpdir", ideTempPath);
        }
        if (System.getProperty("jna.nosys") == null) {
            System.setProperty("jna.nosys", "true");
        }
        if (SystemInfo.isWindows && System.getProperty("winp.folder.preferred") == null) {
            System.setProperty("winp.folder.preferred", ideTempPath);
        }
        if (System.getProperty("pty4j.tmpdir") == null) {
            System.setProperty("pty4j.tmpdir", ideTempPath);
        }
        if (System.getProperty("pty4j.preferred.native.folder") == null) {
            System.setProperty("pty4j.preferred.native.folder", new File(PathManager.getLibPath(), "pty4j-native").getAbsolutePath());
        }
    }

    private static void loadSystemLibraries(Logger log2) {
        Activity activity = ParallelActivity.PREPARE_APP_INIT.start("load system libs");
        JnaLoader.load((Logger)log2);
        IdeaWin32.isAvailable();
        activity.end();
    }

    private static void startLogging(@NotNull Logger log2) {
        if (log2 == null) {
            StartupUtil.$$$reportNull$$$0(11);
        }
        log2.info("------------------------------------------------------ IDE STARTED ------------------------------------------------------");
        AppExecutorUtil.getAppExecutorService().submit(() -> StartupUtil.startLoggingAsync(log2));
    }

    private static void startLoggingAsync(@NotNull Logger log2) {
        String extDirs;
        if (log2 == null) {
            StartupUtil.$$$reportNull$$$0(12);
        }
        ShutDownTracker.getInstance().registerShutdownTask(() -> log2.info("------------------------------------------------------ IDE SHUTDOWN ------------------------------------------------------"));
        ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
        ApplicationNamesInfo namesInfo = ApplicationNamesInfo.getInstance();
        String buildDate = new SimpleDateFormat("dd MMM yyyy HH:mm", Locale.US).format(appInfo.getBuildDate().getTime());
        log2.info("IDE: " + namesInfo.getFullProductName() + " (build #" + appInfo.getBuild().asString() + ", " + buildDate + ")");
        log2.info("OS: " + SystemInfo.OS_NAME + " (" + SystemInfo.OS_VERSION + ", " + SystemInfo.OS_ARCH + ")");
        log2.info("JRE: " + System.getProperty("java.runtime.version", "-") + " (" + System.getProperty("java.vendor", "-") + ")");
        log2.info("JVM: " + System.getProperty("java.vm.version", "-") + " (" + System.getProperty("java.vm.name", "-") + ")");
        List<String> arguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
        if (arguments != null) {
            log2.info("JVM Args: " + StringUtil.join(arguments, (String)" "));
        }
        if ((extDirs = System.getProperty("java.ext.dirs")) != null) {
            for (String dir : StringUtil.split((String)extDirs, (String)File.pathSeparator)) {
                Object[] content2 = new File(dir).list();
                if (content2 == null || content2.length <= 0) continue;
                log2.info("ext: " + dir + ": " + Arrays.toString(content2));
            }
        }
        log2.info("charsets: JNU=" + System.getProperty("sun.jnu.encoding") + " file=" + System.getProperty("file.encoding"));
    }

    private static void installPluginUpdates() {
        if (!Main.isCommandLine() || Boolean.getBoolean(FORCE_PLUGIN_UPDATES)) {
            try {
                StartupActionScriptManager.executeActionScript();
            }
            catch (IOException e) {
                String message = "The IDE failed to install some plugins.\n\nMost probably, this happened because of a change in a serialization format.\nPlease try again, and if the problem persists, please report it\nto http://jb.gg/ide/critical-startup-errors\n\nThe cause: " + e.getMessage();
                Main.showMessage((String)"Plugin Installation Error", (String)message, (boolean)false);
            }
        }
    }

    private static void runStartupWizard(@NotNull AppStarter appStarter) {
        CustomizeIDEWizardStepsProvider provider;
        String stepsProviderName;
        if (appStarter == null) {
            StartupUtil.$$$reportNull$$$0(13);
        }
        if ((stepsProviderName = ApplicationInfoImpl.getShadowInstance().getCustomizeIDEWizardStepsProvider()) == null) {
            return;
        }
        try {
            Class<?> providerClass = Class.forName(stepsProviderName);
            provider = (CustomizeIDEWizardStepsProvider)providerClass.newInstance();
        }
        catch (Throwable e) {
            Main.showMessage((String)"Configuration Wizard Failed", (Throwable)e);
            return;
        }
        appStarter.beforeStartupWizard();
        new CustomizeIDEWizardDialog(provider, appStarter).show();
        PluginManagerCore.invalidatePlugins();
        appStarter.startupWizardFinished();
    }

    public static boolean patchSystem(@NotNull Logger log2) {
        if (log2 == null) {
            StartupUtil.$$$reportNull$$$0(14);
        }
        if (!ourSystemPatched.compareAndSet(false, true)) {
            return false;
        }
        Activity patchActivity = StartUpMeasurer.start((String)"patch system");
        ApplicationImpl.patchSystem();
        if (!Main.isHeadless()) {
            StartupUtil.patchSystemForUi(log2);
        }
        patchActivity.end();
        return true;
    }

    private static void patchSystemForUi(@NotNull Logger log2) {
        if (log2 == null) {
            StartupUtil.$$$reportNull$$$0(15);
        }
        if (Patches.REPAINT_MANAGER_LEAK) {
            RepaintManager.setCurrentManager(new IdeRepaintManager());
        }
        if (SystemInfo.isXWindow) {
            String wmName = X11UiUtil.getWmName();
            log2.info("WM detected: " + wmName);
            if (wmName != null) {
                X11UiUtil.patchDetectedWm(wmName);
            }
        }
        IconManager.activate();
    }

    private static void showUserAgreementAndConsentsIfNeeded(@NotNull Logger log2) {
        if (log2 == null) {
            StartupUtil.$$$reportNull$$$0(16);
        }
        if (!ApplicationInfoImpl.getShadowInstance().isVendorJetBrains()) {
            return;
        }
        EndUserAgreement.updateCachedContentToLatestBundledVersion();
        EndUserAgreement.Document agreement = EndUserAgreement.getLatestDocument();
        if (!agreement.isAccepted()) {
            StartupUtil.runInEdtAndWait(log2, () -> AppUIUtil.showEndUserAgreementText(agreement.getText(), agreement.isPrivacyPolicy()));
            EndUserAgreement.setAccepted(agreement);
        }
        AppUIUtil.showConsentsAgreementIfNeeded(command -> StartupUtil.runInEdtAndWait(log2, command));
    }

    private static void runInEdtAndWait(@NotNull Logger log2, @NotNull Runnable runnable2) {
        if (log2 == null) {
            StartupUtil.$$$reportNull$$$0(17);
        }
        if (runnable2 == null) {
            StartupUtil.$$$reportNull$$$0(18);
        }
        try {
            if (!ourSystemPatched.get()) {
                EventQueue.invokeAndWait(() -> {
                    if (!StartupUtil.patchSystem(log2)) {
                        return;
                    }
                    try {
                        UIManager.setLookAndFeel(IntelliJLaf.class.getName());
                        IconManager.activate();
                        IconLoader.activate();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
            }
            EventQueue.invokeAndWait(runnable2);
        }
        catch (InterruptedException | InvocationTargetException e) {
            log2.warn((Throwable)e);
        }
    }

    static {
        ourSystemPatched = new AtomicBoolean();
        HANDLER = (t, e) -> MainRunner.processException(e);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 1: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appStarter";
                break;
            }
            case 3: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/idea/StartupUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "futures";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorService";
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "log";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initLafTask";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/idea/StartupUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "lockDirsAndConfigureLogger";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "lockSystemFolders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "prepareAndStart";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "lockDirsAndConfigureLogger";
                break;
            }
            case 3: 
            case 9: 
            case 10: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addInitUiTasks";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lockSystemFolders";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "startLogging";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "startLoggingAsync";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "runStartupWizard";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "patchSystem";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "patchSystemForUi";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "showUserAgreementAndConsentsIfNeeded";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "runInEdtAndWait";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    public static interface AppStarter {
        public void start();

        default public void beforeImportConfigs() {
        }

        default public void beforeStartupWizard() {
        }

        default public void startupWizardFinished() {
        }

        default public void importFinished(@NotNull Path newConfigDir) {
            if (newConfigDir == null) {
                AppStarter.$$$reportNull$$$0(0);
            }
        }

        default public int customizeIdeWizardDialog(@NotNull List<AbstractCustomizeWizardStep> steps) {
            if (steps == null) {
                AppStarter.$$$reportNull$$$0(1);
            }
            return -1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newConfigDir";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "steps";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/idea/StartupUtil$AppStarter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "importFinished";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "customizeIdeWizardDialog";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

