/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.featureStatistics.fusCollectors;

import com.intellij.diagnostic.PluginException;
import com.intellij.diagnostic.VMOptions;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.internal.statistic.utils.StatisticsUploadAssistant;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LifecycleUsageTriggerCollector {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.featureStatistics.fusCollectors.LifecycleUsageTriggerCollector");
    private static final String LIFECYCLE = "lifecycle";

    public static void onIdeStart() {
        FeatureUsageData data = new FeatureUsageData().addData("eap", ApplicationManager.getApplication().isEAP());
        LifecycleUsageTriggerCollector.addIfTrue(data, "test", StatisticsUploadAssistant.isTestStatisticsEnabled());
        LifecycleUsageTriggerCollector.addIfTrue(data, "command_line", ApplicationManager.getApplication().isCommandLine());
        LifecycleUsageTriggerCollector.addIfTrue(data, "internal", ApplicationManager.getApplication().isInternal());
        LifecycleUsageTriggerCollector.addIfTrue(data, "headless", ApplicationManager.getApplication().isHeadlessEnvironment());
        FUCounterUsageLogger.getInstance().logEvent(LIFECYCLE, "ide.start", data);
    }

    private static void addIfTrue(@NotNull FeatureUsageData data, @NotNull String key, boolean value) {
        if (data == null) {
            LifecycleUsageTriggerCollector.$$$reportNull$$$0(0);
        }
        if (key == null) {
            LifecycleUsageTriggerCollector.$$$reportNull$$$0(1);
        }
        if (value) {
            data.addData(key, value);
        }
    }

    public static void onIdeClose(boolean restart2) {
        FeatureUsageData data = new FeatureUsageData().addData("restart", restart2);
        FUCounterUsageLogger.getInstance().logEvent(LIFECYCLE, "ide.close", data);
    }

    public static void onProjectOpenFinished(@NotNull Project project, long time) {
        if (project == null) {
            LifecycleUsageTriggerCollector.$$$reportNull$$$0(2);
        }
        FeatureUsageData data = new FeatureUsageData().addProject(project).addData("duration_ms", time);
        FUCounterUsageLogger.getInstance().logEvent(LIFECYCLE, "project.opening.finished", data);
    }

    public static void onProjectOpened(@NotNull Project project) {
        if (project == null) {
            LifecycleUsageTriggerCollector.$$$reportNull$$$0(3);
        }
        FeatureUsageData data = new FeatureUsageData().addProject(project);
        FUCounterUsageLogger.getInstance().logEvent(LIFECYCLE, "project.opened", data);
    }

    public static void onProjectClosed(@NotNull Project project) {
        if (project == null) {
            LifecycleUsageTriggerCollector.$$$reportNull$$$0(4);
        }
        FeatureUsageData data = new FeatureUsageData().addProject(project);
        FUCounterUsageLogger.getInstance().logEvent(LIFECYCLE, "project.closed", data);
    }

    public static void onFrameActivated(@Nullable Project project) {
        FeatureUsageData data = new FeatureUsageData().addProject(project);
        FUCounterUsageLogger.getInstance().logEvent(LIFECYCLE, "frame.activated", data);
    }

    public static void onFrameDeactivated(@Nullable Project project) {
        FeatureUsageData data = new FeatureUsageData().addProject(project);
        FUCounterUsageLogger.getInstance().logEvent(LIFECYCLE, "frame.deactivated", data);
    }

    public static void onFreeze(int lengthInSeconds) {
        long ms = (long)lengthInSeconds * 1000L;
        FeatureUsageData data = new FeatureUsageData().addData("duration_ms", ms).addData("duration_grouped", LifecycleUsageTriggerCollector.toLengthGroup(lengthInSeconds));
        FUCounterUsageLogger.getInstance().logEvent(LIFECYCLE, "ide.freeze", data);
    }

    public static void onError(@Nullable PluginId pluginId, @Nullable Throwable throwable, @Nullable VMOptions.MemoryKind memoryErrorKind) {
        try {
            FeatureUsageData data = new FeatureUsageData().addPluginInfo(pluginId == null ? PluginInfoDetectorKt.getPlatformPlugin() : PluginInfoDetectorKt.getPluginInfoById(pluginId)).addData("error", LifecycleUsageTriggerCollector.getThrowableClassName(throwable));
            if (memoryErrorKind != null) {
                data.addData("memory_error_kind", StringUtil.toLowerCase((String)memoryErrorKind.name()));
            }
            FUCounterUsageLogger.getInstance().logEvent(LIFECYCLE, "ide.error", data);
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
    }

    @NotNull
    private static String toLengthGroup(int seconds) {
        if (seconds >= 60) {
            if ("60s+" == null) {
                LifecycleUsageTriggerCollector.$$$reportNull$$$0(5);
            }
            return "60s+";
        }
        if (seconds > 10) {
            seconds -= seconds % 10;
            String string = seconds + "s+";
            if (string == null) {
                LifecycleUsageTriggerCollector.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = seconds + "s";
        if (string == null) {
            LifecycleUsageTriggerCollector.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    private static String getThrowableClassName(@Nullable Throwable t) {
        if (t == null) {
            if ("unknown" == null) {
                LifecycleUsageTriggerCollector.$$$reportNull$$$0(8);
            }
            return "unknown";
        }
        boolean isPluginException = t instanceof PluginException && t.getCause() != null;
        Class<?> throwableClass = isPluginException ? t.getCause().getClass() : t.getClass();
        PluginInfo throwableLocation = PluginInfoDetectorKt.getPluginInfo(throwableClass);
        String string = throwableLocation.isSafeToReport() ? throwableClass.getName() : "third.party";
        if (string == null) {
            LifecycleUsageTriggerCollector.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/featureStatistics/fusCollectors/LifecycleUsageTriggerCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/featureStatistics/fusCollectors/LifecycleUsageTriggerCollector";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "toLengthGroup";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getThrowableClassName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addIfTrue";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "onProjectOpenFinished";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "onProjectOpened";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "onProjectClosed";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

