/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.settings;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInsight.intention.impl.config.ActionUsagePanel;
import com.intellij.codeInsight.intention.impl.config.BeforeAfterMetaData;
import com.intellij.codeInsight.intention.impl.config.PlainTextDescriptor;
import com.intellij.codeInsight.intention.impl.config.TextDescriptor;
import com.intellij.codeInsight.template.postfix.settings.PostfixTemplateMetaData;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.HintHint;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.io.IOException;
import java.io.StringReader;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PostfixDescriptionPanel
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.impl.config.IntentionDescriptionPanel");
    private JPanel myPanel;
    private JPanel myAfterPanel;
    private JPanel myBeforePanel;
    private JEditorPane myDescriptionBrowser;

    PostfixDescriptionPanel() {
        this.$$$setupUI$$$();
        this.myDescriptionBrowser.setMargin((Insets)JBUI.insets((int)5));
        this.initializeExamplePanel(this.myAfterPanel);
        this.initializeExamplePanel(this.myBeforePanel);
    }

    public void reset(@NotNull BeforeAfterMetaData actionMetaData) {
        if (actionMetaData == null) {
            PostfixDescriptionPanel.$$$reportNull$$$0(0);
        }
        boolean isEmpty = actionMetaData == PostfixTemplateMetaData.EMPTY_METADATA;
        this.readHtml(actionMetaData, isEmpty);
        PostfixDescriptionPanel.showUsages(this.myBeforePanel, isEmpty ? new PlainTextDescriptor(CodeInsightBundle.message((String)"templates.postfix.settings.category.before", (Object[])new Object[0]), "before.txt.template") : (TextDescriptor)ArrayUtil.getFirstElement((Object[])actionMetaData.getExampleUsagesBefore()));
        PostfixDescriptionPanel.showUsages(this.myAfterPanel, isEmpty ? new PlainTextDescriptor(CodeInsightBundle.message((String)"templates.postfix.settings.category.after", (Object[])new Object[0]), "after.txt.template") : (TextDescriptor)ArrayUtil.getFirstElement((Object[])actionMetaData.getExampleUsagesAfter()));
    }

    private void readHtml(@NotNull BeforeAfterMetaData actionMetaData, boolean isEmpty) {
        if (actionMetaData == null) {
            PostfixDescriptionPanel.$$$reportNull$$$0(1);
        }
        HintHint hintHint = new HintHint(this.myDescriptionBrowser, new Point(0, 0));
        hintHint.setFont(UIUtil.getLabelFont());
        String description = isEmpty ? CodeInsightBundle.message((String)"templates.postfix.settings.category.text", (Object[])new Object[0]) : PostfixDescriptionPanel.getDescription(actionMetaData.getDescription());
        try {
            this.myDescriptionBrowser.read(new StringReader(HintUtil.prepareHintText(description, hintHint)), null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @NotNull
    private static String getDescription(TextDescriptor url) {
        String string;
        try {
            string = url.getText();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            if ("" == null) {
                PostfixDescriptionPanel.$$$reportNull$$$0(3);
            }
            return "";
        }
        if (string == null) {
            PostfixDescriptionPanel.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static void showUsages(@NotNull JPanel panel2, @Nullable TextDescriptor exampleUsage) {
        if (panel2 == null) {
            PostfixDescriptionPanel.$$$reportNull$$$0(4);
        }
        String text2 = "";
        PlainTextFileType fileType = PlainTextFileType.INSTANCE;
        if (exampleUsage != null) {
            try {
                text2 = exampleUsage.getText();
                String name = exampleUsage.getFileName();
                FileTypeManagerEx fileTypeManager = FileTypeManagerEx.getInstanceEx();
                String extension = fileTypeManager.getExtension(name);
                fileType = fileTypeManager.getFileTypeByExtension(extension);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        ((ActionUsagePanel)panel2.getComponent(0)).reset(text2, (FileType)fileType);
        panel2.repaint();
    }

    private void initializeExamplePanel(@NotNull JPanel panel2) {
        if (panel2 == null) {
            PostfixDescriptionPanel.$$$reportNull$$$0(5);
        }
        panel2.setLayout(new BorderLayout());
        ActionUsagePanel actionUsagePanel = new ActionUsagePanel();
        panel2.add(actionUsagePanel);
        Disposer.register((Disposable)this, (Disposable)actionUsagePanel);
    }

    synchronized JPanel getComponent() {
        return this.myPanel;
    }

    public void dispose() {
    }

    public void resetHeights(int preferredWidth) {
        double height = (this.myDescriptionBrowser.getSize().getHeight() + this.myBeforePanel.getSize().getHeight() + this.myAfterPanel.getSize().getHeight()) / 3.0;
        if (height == 0.0) {
            return;
        }
        Dimension newd = new Dimension(preferredWidth, (int)height);
        this.myDescriptionBrowser.setSize(newd);
        this.myDescriptionBrowser.setPreferredSize(newd);
        this.myDescriptionBrowser.setMaximumSize(newd);
        this.myDescriptionBrowser.setMinimumSize(newd);
        this.myBeforePanel.setSize(newd);
        this.myBeforePanel.setPreferredSize(newd);
        this.myBeforePanel.setMaximumSize(newd);
        this.myBeforePanel.setMinimumSize(newd);
        this.myAfterPanel.setSize(newd);
        this.myAfterPanel.setPreferredSize(newd);
        this.myAfterPanel.setMaximumSize(newd);
        this.myAfterPanel.setMinimumSize(newd);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionMetaData";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/postfix/settings/PostfixDescriptionPanel";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/postfix/settings/PostfixDescriptionPanel";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "readHtml";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "showUsages";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "initializeExamplePanel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JEditorPane jEditorPane;
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        this.myPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myAfterPanel = jPanel2 = new JPanel();
        jPanel4.add((Component)jPanel2, new GridConstraints(5, 0, 1, 1, 0, 3, 3, 3, new Dimension(-1, 60), null, null));
        this.myBeforePanel = jPanel = new JPanel();
        jPanel4.add((Component)jPanel, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, new Dimension(-1, 60), null, null));
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText("Before");
        jPanel4.add((Component)titledSeparator, new GridConstraints(2, 0, 1, 1, 0, 1, 7, 0, null, null, null));
        TitledSeparator titledSeparator2 = new TitledSeparator();
        titledSeparator2.setAlignmentY(0.2f);
        titledSeparator2.setText("After");
        jPanel4.add((Component)titledSeparator2, new GridConstraints(4, 0, 1, 1, 0, 1, 7, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel4.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 3, null, null, null));
        this.myDescriptionBrowser = jEditorPane = new JEditorPane();
        jEditorPane.setContentType("text/html");
        jEditorPane.setEditable(false);
        jBScrollPane.setViewportView(jEditorPane);
        TitledSeparator titledSeparator3 = new TitledSeparator();
        titledSeparator3.setText("Description");
        jPanel4.add((Component)titledSeparator3, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

