/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeHighlighting.EditorBoundHighlightingPass;
import com.intellij.codeInsight.hints.CollectorWithSettings;
import com.intellij.codeInsight.hints.InlayHintsSettings;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00060\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u001f\u0010\u0004\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001f\u0010\u0013\u001a\u0010\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00030\u00030\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001d"}, d2={"Lcom/intellij/codeInsight/hints/InlayHintsPass;", "Lcom/intellij/codeHighlighting/EditorBoundHighlightingPass;", "rootElement", "Lcom/intellij/psi/PsiElement;", "collectors", "", "Lcom/intellij/codeInsight/hints/CollectorWithSettings;", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "settings", "Lcom/intellij/codeInsight/hints/InlayHintsSettings;", "(Lcom/intellij/psi/PsiElement;Ljava/util/List;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/codeInsight/hints/InlayHintsSettings;)V", "getCollectors", "()Ljava/util/List;", "getRootElement", "()Lcom/intellij/psi/PsiElement;", "getSettings", "()Lcom/intellij/codeInsight/hints/InlayHintsSettings;", "traverser", "Lcom/intellij/psi/SyntaxTraverser;", "kotlin.jvm.PlatformType", "getTraverser", "()Lcom/intellij/psi/SyntaxTraverser;", "doApplyInformationToEditor", "", "doCollectInformation", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.platform.lang.impl"})
public final class InlayHintsPass
extends EditorBoundHighlightingPass {
    @NotNull
    private final SyntaxTraverser<PsiElement> traverser;
    @NotNull
    private final PsiElement rootElement;
    @NotNull
    private final List<CollectorWithSettings<? extends Object>> collectors;
    @NotNull
    private final InlayHintsSettings settings;

    @NotNull
    public final SyntaxTraverser<PsiElement> getTraverser() {
        return this.traverser;
    }

    @Override
    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        Intrinsics.checkParameterIsNotNull((Object)progress, (String)"progress");
        Iterable $this$forEach$iv = (Iterable)this.traverser;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiElement element = (PsiElement)element$iv;
            boolean bl = false;
            for (CollectorWithSettings<? extends Object> collector : this.collectors) {
                if (!this.settings.hintsEnabled(collector.getKey(), collector.getLanguage())) continue;
                PsiElement psiElement = element;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"element");
                Editor editor = this.myEditor;
                Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"myEditor");
                collector.collectHints(psiElement, editor);
            }
        }
    }

    @Override
    public void doApplyInformationToEditor() {
        PsiElement element = this.rootElement;
        int startOffset = element.getTextOffset();
        TextRange textRange = element.getTextRange();
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"element.textRange");
        int endOffset = textRange.getEndOffset();
        Editor editor = this.myEditor;
        Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"myEditor");
        InlayModel inlayModel = editor.getInlayModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)inlayModel, (String)"myEditor.inlayModel");
        InlayModel inlayModel2 = inlayModel;
        List list2 = inlayModel2.getInlineElementsInRange(startOffset, endOffset);
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"inlayModel.getInlineElem\u2026e(startOffset, endOffset)");
        List existingHorizontalInlays = list2;
        List list3 = inlayModel2.getBlockElementsInRange(startOffset, endOffset);
        Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"inlayModel.getBlockEleme\u2026e(startOffset, endOffset)");
        List existingVerticalInlays = list3;
        for (CollectorWithSettings<? extends Object> collector : this.collectors) {
            Editor editor2 = this.myEditor;
            Intrinsics.checkExpressionValueIsNotNull((Object)editor2, (String)"myEditor");
            collector.applyToEditor(editor2, existingHorizontalInlays, existingVerticalInlays, this.settings.hintsEnabled(collector.getKey(), collector.getLanguage()));
        }
    }

    @NotNull
    public final PsiElement getRootElement() {
        return this.rootElement;
    }

    @NotNull
    public final List<CollectorWithSettings<? extends Object>> getCollectors() {
        return this.collectors;
    }

    @NotNull
    public final InlayHintsSettings getSettings() {
        return this.settings;
    }

    public InlayHintsPass(@NotNull PsiElement rootElement, @NotNull List<? extends CollectorWithSettings<? extends Object>> collectors, @NotNull Editor editor, @NotNull InlayHintsSettings settings) {
        Intrinsics.checkParameterIsNotNull((Object)rootElement, (String)"rootElement");
        Intrinsics.checkParameterIsNotNull(collectors, (String)"collectors");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        super(editor, rootElement.getContainingFile(), true);
        this.rootElement = rootElement;
        this.collectors = collectors;
        this.settings = settings;
        SyntaxTraverser syntaxTraverser = SyntaxTraverser.psiTraverser((PsiElement)this.rootElement);
        Intrinsics.checkExpressionValueIsNotNull((Object)syntaxTraverser, (String)"SyntaxTraverser.psiTraverser(rootElement)");
        this.traverser = syntaxTraverser;
    }
}

