/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.hints.HintUtilsKt;
import com.intellij.codeInsight.hints.InlayParameterHintsExtension;
import com.intellij.codeInsight.hints.InlayParameterHintsProvider;
import com.intellij.codeInsight.hints.settings.Diff;
import com.intellij.codeInsight.hints.settings.ParameterNameHintsSettings;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorSettingsProvider;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.components.JBLabel;
import java.awt.Dimension;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\t\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u001e\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0011"}, d2={"createBlacklistDependencyInfoLabel", "Lcom/intellij/ui/components/JBLabel;", "language", "Lcom/intellij/lang/Language;", "createBlacklistEditorField", "Lcom/intellij/ui/EditorTextField;", "text", "", "getBlacklistExplanationHTML", "getLanguageBlackList", "highlightErrorLines", "", "lines", "", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.platform.lang.impl"})
public final class BlackListPanelKt {
    private static final String getLanguageBlackList(Language language) {
        InlayParameterHintsProvider inlayParameterHintsProvider = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(language);
        if (inlayParameterHintsProvider == null) {
            return "";
        }
        InlayParameterHintsProvider hintsProvider = inlayParameterHintsProvider;
        Diff diff = ParameterNameHintsSettings.Companion.getInstance().getBlackListDiff(HintUtilsKt.getLanguageForSettingKey(language));
        Set set = hintsProvider.getDefaultBlackList();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"hintsProvider.defaultBlackList");
        Set blackList = diff.applyOn(set);
        String string = StringUtil.join((Collection)blackList, (String)"\n");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringUtil.join(blackList, \"\\n\")");
        return string;
    }

    private static final EditorTextField createBlacklistEditorField(String text2) {
        Document document = EditorFactory.getInstance().createDocument((CharSequence)text2);
        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"EditorFactory.getInstance().createDocument(text)");
        Document document2 = document;
        EditorTextField field = new EditorTextField(document2, null, (FileType)FileTypes.PLAIN_TEXT, false, false);
        field.setPreferredSize(new Dimension(200, 350));
        field.addSettingsProvider(new EditorSettingsProvider(text2){
            final /* synthetic */ String $text;

            public final void customizeSettings(EditorEx editor) {
                editor.setVerticalScrollbarVisible(true);
                editor.setHorizontalScrollbarVisible(true);
                EditorEx editorEx = editor;
                Intrinsics.checkExpressionValueIsNotNull((Object)editorEx, (String)"editor");
                EditorSettings editorSettings = editorEx.getSettings();
                Intrinsics.checkExpressionValueIsNotNull((Object)editorSettings, (String)"editor.settings");
                editorSettings.setAdditionalLinesCount(2);
                BlackListPanelKt.access$highlightErrorLines(HintUtilsKt.getBlackListInvalidLineNumbers(this.$text), editor);
            }
            {
                this.$text = string;
            }
        });
        return field;
    }

    private static final void highlightErrorLines(List<Integer> lines, Editor editor) {
        TextAttributes attributes = editor.getColorsScheme().getAttributes(CodeInsightColors.ERRORS_ATTRIBUTES);
        Document document = editor.getDocument();
        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"editor.document");
        Document document2 = document;
        int totalLines = document2.getLineCount();
        MarkupModel markupModel = editor.getMarkupModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)markupModel, (String)"editor.markupModel");
        MarkupModel model2 = markupModel;
        model2.removeAllHighlighters();
        lines.stream().filter((Predicate)new Predicate<Integer>(totalLines){
            final /* synthetic */ int $totalLines;

            public final boolean test(Integer current) {
                return Intrinsics.compare((int)current, (int)this.$totalLines) < 0;
            }
            {
                this.$totalLines = n;
            }
        }).forEach((Consumer)new Consumer<Integer>(model2, attributes){
            final /* synthetic */ MarkupModel $model;
            final /* synthetic */ TextAttributes $attributes;

            public final void accept(Integer line2) {
                Integer n = line2;
                if (n == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"line!!");
                this.$model.addLineHighlighter(n.intValue(), 5000, this.$attributes);
            }
            {
                this.$model = markupModel;
                this.$attributes = textAttributes;
            }
        });
    }

    private static final String getBlacklistExplanationHTML(Language language) {
        InlayParameterHintsProvider inlayParameterHintsProvider = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(language);
        if (inlayParameterHintsProvider == null) {
            String string = CodeInsightBundle.message((String)"inlay.hints.blacklist.pattern.explanation", (Object[])new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"CodeInsightBundle.messag\u2026ist.pattern.explanation\")");
            return string;
        }
        InlayParameterHintsProvider hintsProvider = inlayParameterHintsProvider;
        String string = hintsProvider.getBlacklistExplanationHTML();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"hintsProvider.blacklistExplanationHTML");
        return string;
    }

    private static final JBLabel createBlacklistDependencyInfoLabel(Language language) {
        InlayParameterHintsProvider provider;
        InlayParameterHintsProvider inlayParameterHintsProvider = provider = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(language);
        Intrinsics.checkExpressionValueIsNotNull((Object)inlayParameterHintsProvider, (String)"provider");
        Language language2 = inlayParameterHintsProvider.getBlackListDependencyLanguage();
        if (language2 == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)language2, (String)"provider.blackListDepend\u2026cyLanguage ?: return null");
        Language dependencyLanguage = language2;
        return new JBLabel("<html>Additionally <b>" + dependencyLanguage.getDisplayName() + "</b> language blacklist will be applied.</html>");
    }

    public static final /* synthetic */ String access$getLanguageBlackList(Language language) {
        return BlackListPanelKt.getLanguageBlackList(language);
    }

    public static final /* synthetic */ EditorTextField access$createBlacklistEditorField(String text2) {
        return BlackListPanelKt.createBlacklistEditorField(text2);
    }

    public static final /* synthetic */ String access$getBlacklistExplanationHTML(Language language) {
        return BlackListPanelKt.getBlacklistExplanationHTML(language);
    }

    public static final /* synthetic */ JBLabel access$createBlacklistDependencyInfoLabel(Language language) {
        return BlackListPanelKt.createBlacklistDependencyInfoLabel(language);
    }

    public static final /* synthetic */ void access$highlightErrorLines(List lines, Editor editor) {
        BlackListPanelKt.highlightErrorLines(lines, editor);
    }
}

