/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.editor;

import com.intellij.application.options.editor.EditorAppearanceConfigurableEP;
import com.intellij.application.options.editor.EditorOptionsListener;
import com.intellij.application.options.editor.EditorOptionsPanel;
import com.intellij.application.options.editor.EditorOptionsProvider;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.hints.InlayParameterHintsExtension;
import com.intellij.codeInsight.hints.ParameterHintsPassFactory;
import com.intellij.codeInsight.hints.settings.ParameterNameHintsConfigurable;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.options.CompositeConfigurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class EditorAppearanceConfigurable
extends CompositeConfigurable<UnnamedConfigurable>
implements EditorOptionsProvider {
    private static final ExtensionPointName<EditorAppearanceConfigurableEP> EP_NAME = ExtensionPointName.create((String)"com.intellij.editorAppearanceConfigurable");
    private JPanel myRootPanel;
    private JCheckBox myCbBlinkCaret;
    private JCheckBox myCbBlockCursor;
    private JCheckBox myCbRightMargin;
    private JCheckBox myCbShowLineNumbers;
    private JCheckBox myCbShowWhitespaces;
    private JCheckBox myLeadingWhitespacesCheckBox;
    private JCheckBox myInnerWhitespacesCheckBox;
    private JCheckBox myTrailingWhitespacesCheckBox;
    private JTextField myBlinkIntervalField;
    private JPanel myAddonPanel;
    private JCheckBox myCbShowMethodSeparators;
    private JCheckBox myShowCodeLensInEditorCheckBox;
    private JCheckBox myShowVerticalIndentGuidesCheckBox;
    private JBCheckBox myCbShowIntentionBulbCheckBox;
    private JPanel myParameterHintsSettingsPanel;
    private JBCheckBox myShowParameterNameHints;
    private JButton myConfigureParameterHintsButton;
    private JBCheckBox myFocusModeCheckBox;

    public EditorAppearanceConfigurable() {
        this.$$$setupUI$$$();
        this.myCbBlinkCaret.addActionListener(e -> this.myBlinkIntervalField.setEnabled(this.myCbBlinkCaret.isSelected()));
        this.myCbShowWhitespaces.addActionListener(e -> this.updateWhitespaceCheckboxesState());
        this.myFocusModeCheckBox.setVisible(ApplicationManager.getApplication().isInternal());
        this.initInlaysPanel();
    }

    private void initInlaysPanel() {
        boolean isInlayProvidersAvailable = InlayParameterHintsExtension.INSTANCE.hasAnyExtensions();
        this.myParameterHintsSettingsPanel.setVisible(isInlayProvidersAvailable);
        if (!isInlayProvidersAvailable) {
            return;
        }
        this.myConfigureParameterHintsButton.addActionListener(e -> {
            ParameterNameHintsConfigurable configurable2 = new ParameterNameHintsConfigurable();
            configurable2.show();
        });
    }

    private void setParameterNameHintsSettings(EditorSettingsExternalizable settings) {
        settings.setShowParameterNameHints(this.myShowParameterNameHints.isSelected());
        ParameterHintsPassFactory.forceHintsUpdateOnNextPass();
    }

    private void updateWhitespaceCheckboxesState() {
        boolean enabled = this.myCbShowWhitespaces.isSelected();
        this.myLeadingWhitespacesCheckBox.setEnabled(enabled);
        this.myInnerWhitespacesCheckBox.setEnabled(enabled);
        this.myTrailingWhitespacesCheckBox.setEnabled(enabled);
    }

    @Override
    public void reset() {
        EditorSettingsExternalizable editorSettings = EditorSettingsExternalizable.getInstance();
        this.myCbShowMethodSeparators.setSelected(DaemonCodeAnalyzerSettings.getInstance().SHOW_METHOD_SEPARATORS);
        this.myCbBlinkCaret.setSelected(editorSettings.isBlinkCaret());
        this.myBlinkIntervalField.setText(Integer.toString(editorSettings.getBlinkPeriod()));
        this.myBlinkIntervalField.setEnabled(editorSettings.isBlinkCaret());
        this.myCbRightMargin.setSelected(editorSettings.isRightMarginShown());
        this.myCbShowLineNumbers.setSelected(editorSettings.isLineNumbersShown());
        this.myCbBlockCursor.setSelected(editorSettings.isBlockCursor());
        this.myCbShowWhitespaces.setSelected(editorSettings.isWhitespacesShown());
        this.myLeadingWhitespacesCheckBox.setSelected(editorSettings.isLeadingWhitespacesShown());
        this.myInnerWhitespacesCheckBox.setSelected(editorSettings.isInnerWhitespacesShown());
        this.myTrailingWhitespacesCheckBox.setSelected(editorSettings.isTrailingWhitespacesShown());
        this.myShowVerticalIndentGuidesCheckBox.setSelected(editorSettings.isIndentGuidesShown());
        this.myFocusModeCheckBox.setSelected(editorSettings.isFocusMode());
        this.myCbShowIntentionBulbCheckBox.setSelected(editorSettings.isShowIntentionBulb());
        this.myShowCodeLensInEditorCheckBox.setSelected(UISettings.getInstance().getShowEditorToolTip());
        this.updateWhitespaceCheckboxesState();
        this.myShowParameterNameHints.setSelected(editorSettings.isShowParameterNameHints());
        super.reset();
    }

    @Override
    public void apply() throws ConfigurationException {
        EditorSettingsExternalizable editorSettings = EditorSettingsExternalizable.getInstance();
        editorSettings.setBlinkCaret(this.myCbBlinkCaret.isSelected());
        try {
            editorSettings.setBlinkPeriod(Integer.parseInt(this.myBlinkIntervalField.getText()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        editorSettings.setBlockCursor(this.myCbBlockCursor.isSelected());
        editorSettings.setRightMarginShown(this.myCbRightMargin.isSelected());
        editorSettings.setLineNumbersShown(this.myCbShowLineNumbers.isSelected());
        editorSettings.setWhitespacesShown(this.myCbShowWhitespaces.isSelected());
        editorSettings.setLeadingWhitespacesShown(this.myLeadingWhitespacesCheckBox.isSelected());
        editorSettings.setInnerWhitespacesShown(this.myInnerWhitespacesCheckBox.isSelected());
        editorSettings.setTrailingWhitespacesShown(this.myTrailingWhitespacesCheckBox.isSelected());
        editorSettings.setIndentGuidesShown(this.myShowVerticalIndentGuidesCheckBox.isSelected());
        editorSettings.setFocusMode(this.myFocusModeCheckBox.isSelected());
        editorSettings.setShowIntentionBulb(this.myCbShowIntentionBulbCheckBox.isSelected());
        this.setParameterNameHintsSettings(editorSettings);
        EditorOptionsPanel.reinitAllEditors();
        DaemonCodeAnalyzerSettings.getInstance().SHOW_METHOD_SEPARATORS = this.myCbShowMethodSeparators.isSelected();
        UISettings uiSettings = UISettings.getInstance();
        boolean uiSettingsModified = false;
        boolean lafSettingsModified = false;
        if (uiSettings.getShowEditorToolTip() != this.myShowCodeLensInEditorCheckBox.isSelected()) {
            uiSettings.setShowEditorToolTip(this.myShowCodeLensInEditorCheckBox.isSelected());
            uiSettingsModified = true;
            lafSettingsModified = true;
        }
        if (lafSettingsModified) {
            LafManager.getInstance().repaintUI();
        }
        if (uiSettingsModified) {
            uiSettings.fireUISettingsChanged();
        }
        EditorOptionsPanel.restartDaemons();
        ((EditorOptionsListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(EditorOptionsListener.APPEARANCE_CONFIGURABLE_TOPIC)).changesApplied();
        super.apply();
    }

    @Override
    public boolean isModified() {
        if (super.isModified()) {
            return true;
        }
        EditorSettingsExternalizable editorSettings = EditorSettingsExternalizable.getInstance();
        boolean isModified = this.isModified(this.myCbBlinkCaret, editorSettings.isBlinkCaret());
        isModified |= this.isModified(this.myBlinkIntervalField, editorSettings.getBlinkPeriod(), EditorSettingsExternalizable.BLINKING_RANGE);
        isModified |= this.isModified(this.myCbBlockCursor, editorSettings.isBlockCursor());
        isModified |= this.isModified(this.myCbRightMargin, editorSettings.isRightMarginShown());
        isModified |= this.isModified(this.myCbShowLineNumbers, editorSettings.isLineNumbersShown());
        isModified |= this.isModified(this.myCbShowWhitespaces, editorSettings.isWhitespacesShown());
        isModified |= this.isModified(this.myLeadingWhitespacesCheckBox, editorSettings.isLeadingWhitespacesShown());
        isModified |= this.isModified(this.myInnerWhitespacesCheckBox, editorSettings.isInnerWhitespacesShown());
        isModified |= this.isModified(this.myTrailingWhitespacesCheckBox, editorSettings.isTrailingWhitespacesShown());
        isModified |= this.isModified(this.myShowVerticalIndentGuidesCheckBox, editorSettings.isIndentGuidesShown());
        isModified |= this.isModified((JToggleButton)this.myFocusModeCheckBox, editorSettings.isFocusMode());
        isModified |= this.isModified((JToggleButton)this.myCbShowIntentionBulbCheckBox, editorSettings.isShowIntentionBulb());
        isModified |= this.isModified(this.myCbShowMethodSeparators, DaemonCodeAnalyzerSettings.getInstance().SHOW_METHOD_SEPARATORS);
        isModified |= this.myShowCodeLensInEditorCheckBox.isSelected() != UISettings.getInstance().getShowEditorToolTip();
        return isModified |= this.myShowParameterNameHints.isSelected() != editorSettings.isShowParameterNameHints();
    }

    @Nls
    public String getDisplayName() {
        return ApplicationBundle.message((String)"tab.editor.settings.appearance", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        return "reference.settingsdialog.IDE.editor.appearance";
    }

    public JComponent createComponent() {
        for (UnnamedConfigurable provider : this.getConfigurables()) {
            JComponent component = provider.createComponent();
            if (component == null) continue;
            this.myAddonPanel.add((Component)component, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 15, 0), 0, 0));
        }
        return this.myRootPanel;
    }

    @Override
    public void disposeUIResources() {
        this.myAddonPanel.removeAll();
        super.disposeUIResources();
    }

    @Override
    @NotNull
    protected List<UnnamedConfigurable> createConfigurables() {
        List<UnnamedConfigurable> list2 = ConfigurableWrapper.createConfigurables(EP_NAME);
        if (list2 == null) {
            EditorAppearanceConfigurable.$$$reportNull$$$0(0);
        }
        return list2;
    }

    @NotNull
    public String getId() {
        if ("editor.preferences.appearance" == null) {
            EditorAppearanceConfigurable.$$$reportNull$$$0(1);
        }
        return "editor.preferences.appearance";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/application/options/editor/EditorAppearanceConfigurable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfigurables";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JButton jButton;
        JBCheckBox jBCheckBox3;
        JPanel jPanel;
        JCheckBox jCheckBox;
        JTextField jTextField;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JPanel jPanel2;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JCheckBox jCheckBox7;
        JCheckBox jCheckBox8;
        JCheckBox jCheckBox9;
        JCheckBox jCheckBox10;
        JCheckBox jCheckBox11;
        JPanel jPanel3;
        this.myRootPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(16, 1, new Insets(0, 0, 0, 0), -1, 0, false, false));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(15, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myCbBlockCursor = jCheckBox11 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox11, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.use.block.caret"));
        jPanel3.add((Component)jCheckBox11, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbRightMargin = jCheckBox10 = new JCheckBox();
        jCheckBox10.setSelected(false);
        this.$$$loadButtonText$$$(jCheckBox10, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.right.margin"));
        jPanel3.add((Component)jCheckBox10, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbShowLineNumbers = jCheckBox9 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox9, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.show.line.numbers"));
        jPanel3.add((Component)jCheckBox9, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbShowWhitespaces = jCheckBox8 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox8, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.show.whitespaces"));
        jPanel3.add((Component)jCheckBox8, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myLeadingWhitespacesCheckBox = jCheckBox7 = new JCheckBox();
        ((Component)jCheckBox7).setEnabled(false);
        jCheckBox7.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox7, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.show.leading.whitespaces"));
        jPanel3.add((Component)jCheckBox7, new GridConstraints(6, 0, 1, 1, 8, 0, 3, 0, null, null, null, 2));
        this.myInnerWhitespacesCheckBox = jCheckBox6 = new JCheckBox();
        ((Component)jCheckBox6).setEnabled(false);
        jCheckBox6.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox6, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.show.inner.whitespaces"));
        jPanel3.add((Component)jCheckBox6, new GridConstraints(7, 0, 1, 1, 8, 0, 3, 0, null, null, null, 2));
        this.myTrailingWhitespacesCheckBox = jCheckBox5 = new JCheckBox();
        ((Component)jCheckBox5).setEnabled(false);
        jCheckBox5.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox5, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.show.trailing.whitespaces"));
        jPanel3.add((Component)jCheckBox5, new GridConstraints(8, 0, 1, 1, 8, 0, 3, 0, null, null, null, 2));
        this.myShowVerticalIndentGuidesCheckBox = jCheckBox4 = new JCheckBox();
        jCheckBox4.setText("Show indent guides");
        jPanel3.add((Component)jCheckBox4, new GridConstraints(9, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myAddonPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel3.add((Component)jPanel2, new GridConstraints(14, 0, 1, 1, 8, 2, 3, 3, null, null, null));
        this.myCbShowMethodSeparators = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.show.method.separators"));
        jPanel3.add((Component)jCheckBox3, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myCbBlinkCaret = jCheckBox2 = new JCheckBox();
        jCheckBox2.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.caret.blinking.ms"));
        jPanel4.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myBlinkIntervalField = jTextField = new JTextField();
        jTextField.setColumns(5);
        jTextField.setText("500");
        jPanel4.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 0, 6, 0, null, null, null));
        this.myShowCodeLensInEditorCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.show.editor.preview.popup"));
        jPanel3.add((Component)jCheckBox, new GridConstraints(12, 0, 1, 1, 8, 0, 3, 0, null, new Dimension(251, 19), null));
        this.myParameterHintsSettingsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(13, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myShowParameterNameHints = jBCheckBox3 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox3, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.show.parameter.name.hints"));
        jPanel.add((Component)jBCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myConfigureParameterHintsButton = jButton = new JButton();
        jButton.setText("Configure...");
        jPanel.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 8, 0, 5, 0, null, null, null));
        this.myCbShowIntentionBulbCheckBox = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setText("Show intention bulb");
        jPanel3.add((Component)jBCheckBox2, new GridConstraints(11, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myFocusModeCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Highlight only current declaration");
        jPanel3.add((Component)jBCheckBox, new GridConstraints(10, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c2 = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c2);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

